/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.EncryptedData;
import de.osci.osci12.encryption.EncryptedDataBuilder;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ExitDialog;
import de.osci.osci12.messagetypes.FetchDelivery;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.InitDialog;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesH;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesHBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public class SendParsedEncryptedData {
    private static final String PIN = "123456";
    private static final String DAVE_CIPHER_REF = "reader_dave_cipher_ref";
    private static final String ALICE_SIGN_REF = "author_alice_sign_ref";
    private static final List<String> SAMPLE_CONTENT_NAMES = Arrays.asList("messageText", "form.xml", "printout.pdf", "protocol.pdf", "protocol.json", "xsozialxslt.xml");

    public static void main(String[] args) throws Exception {
        Reader readerEncrypt = SendParsedEncryptedData.createReaderEncrypt();
        Author authorSign = SendParsedEncryptedData.createAuthorSign();
        byte[] encryptedDataBytes = SendParsedEncryptedData.createEncryptedData(readerEncrypt, authorSign);
        byte[] nonIntermediaryCertificatesBytes = SendParsedEncryptedData.createNonIntermediaryCertificates(readerEncrypt, authorSign);
        String messageId = SendParsedEncryptedData.sendStoreDeliveryWithEncryptedData(encryptedDataBytes, nonIntermediaryCertificatesBytes);
        SendParsedEncryptedData.fetchMessageAndCheckContents(messageId);
    }

    private static byte[] createEncryptedData(Reader readerEncrypt, Author authorSign) throws Exception {
        System.out.println("Erzeuge und signiere Beispiel-Container");
        ContentContainer cocoWithAllContents = new ContentContainer();
        cocoWithAllContents.setRefID("XSOZIAL_DATA");
        SAMPLE_CONTENT_NAMES.forEach(c -> cocoWithAllContents.addContent(SendParsedEncryptedData.createSampleContent(c)));
        cocoWithAllContents.sign((Role)authorSign);
        System.out.println("Erzeuge und serialisiere EncryptedData-Element");
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI(cocoWithAllContents);
        encryptedData.encrypt((Role)readerEncrypt);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        encryptedData.writeXML((OutputStream)outputStream, false);
        return outputStream.toByteArray();
    }

    private static byte[] createNonIntermediaryCertificates(Reader readerEncrypt, Author authorSign) throws Exception {
        System.out.println("Erzeuge NonIntermediaryCertificates-Instanz mit gegebenen Schl\u00fcsseln");
        NonIntermediaryCertificatesH nih = new NonIntermediaryCertificatesH();
        nih.setCipherCertificatesOtherReaders(new Reader[]{readerEncrypt});
        nih.setSignatureCertificatesOtherAuthors(new Author[]{authorSign});
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        nih.writeXML((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static Content createSampleContent(String name) {
        Content msgText;
        try {
            msgText = new Content("some random bytes");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        msgText.setRefID(name);
        return msgText;
    }

    private static String sendStoreDeliveryWithEncryptedData(byte[] encryptedDataBytes, byte[] nonIntermediaryHeaderBytes) throws Exception {
        System.out.println("Bereite OSCI-StoreDelivery-Transport vor");
        DialogHandler senderDialog = SendParsedEncryptedData.createSendDialogHandler();
        Addressee addressee = SendParsedEncryptedData.createAddressee();
        String msgId = SendParsedEncryptedData.getMsgId(senderDialog);
        StoreDelivery storeDelivery = new StoreDelivery(senderDialog, addressee, msgId);
        System.out.println("Lade OSCI-Rollen aus NonIntermediaryCertificates-Element");
        NonIntermediaryCertificatesH nonIntermediaryCertificates = NonIntermediaryCertificatesHBuilder.createFromXmlBytes((byte[])nonIntermediaryHeaderBytes);
        storeDelivery.addReadersAndAuthors(nonIntermediaryCertificates);
        System.out.println("Lese EncryptedData-Element ein und f\u00fcge es der Nachricht hinzu");
        EncryptedData encryptedData = EncryptedDataBuilder.createFromXmlBytes((byte[])encryptedDataBytes);
        storeDelivery.addEncryptedData(new EncryptedDataOSCI(encryptedData, (OSCIMessage)storeDelivery));
        System.out.println("Versende OSCI-StoreDelivery-Nachricht an Intermedi\u00e4r");
        return storeDelivery.send().getMessageId();
    }

    private static void fetchMessageAndCheckContents(String messageId) throws Exception {
        System.out.println("Bereite OSCI-FetchDelivery-Transport vor");
        DialogHandler fetchDialog = SendParsedEncryptedData.createFetchDialogHandler();
        new InitDialog(fetchDialog).send();
        System.out.println("Erzeuge und versende FetchDelivery-Nachricht");
        FetchDelivery fetchDel = new FetchDelivery(fetchDialog);
        fetchDel.setSelectionMode(0);
        fetchDel.setSelectionRule(messageId);
        ResponseToFetchDelivery rsp2FetchDel = fetchDel.send();
        new ExitDialog(fetchDialog).send();
        System.out.println("\u00dcberpr\u00fcfe und entschl\u00fcssele abgeholte Nachricht");
        EncryptedDataOSCI[] fetchedEncryptedData = rsp2FetchDel.getEncryptedData();
        if (fetchedEncryptedData.length != 1) {
            throw new Exception("Nicht genau ein EncryptedData-Element!");
        }
        ContentContainer enc_coco = fetchedEncryptedData[0].decrypt((Role)SendParsedEncryptedData.createReaderDecrypt());
        if (!rsp2FetchDel.getOtherAuthors()[0].getSignatureCertificateId().equals(ALICE_SIGN_REF)) {
            throw new Exception("Falsche Autoren-ID " + rsp2FetchDel.getOtherAuthors()[0].getSignatureCertificateId());
        }
        enc_coco.checkSignature((Role)rsp2FetchDel.getOtherAuthors()[0]);
        if (!enc_coco.getRefID().equals("XSOZIAL_DATA")) {
            throw new Exception("Falscher Content-Container(-Name)");
        }
        if (enc_coco.getContents().length != 6) {
            throw new Exception("Nicht genau 6 Contents im entschl\u00fcsselten ContentContainer!");
        }
        if (!Arrays.stream(enc_coco.getContents()).allMatch(content -> SAMPLE_CONTENT_NAMES.contains(content.getRefID()))) {
            throw new Exception("Nicht alle Contents im entschl\u00fcsselten ContentContainer!");
        }
    }

    private static DialogHandler createSendDialogHandler() throws Exception {
        Intermed intermed = SendParsedEncryptedData.createIntermed();
        Originator originator = SendParsedEncryptedData.createOriginator();
        return new DialogHandler(originator, intermed, (TransportI)new HttpTransport());
    }

    private static DialogHandler createFetchDialogHandler() throws Exception {
        Intermed intermed = SendParsedEncryptedData.createIntermed();
        Originator originator = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/bob_signature_4096.p12", PIN), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.p12", PIN));
        return new DialogHandler(originator, intermed, (TransportI)new HttpTransport());
    }

    private static Intermed createIntermed() throws CertificateException, URISyntaxException {
        X509Certificate cipherCert = SendParsedEncryptedData.createIntermedCipherCert();
        URI uri = SendParsedEncryptedData.createIntermedUri();
        return new Intermed(null, cipherCert, uri);
    }

    private static X509Certificate createIntermedCipherCert() throws CertificateException {
        String testCypher = "/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer";
        InputStream resource = SendParsedEncryptedData.getResource("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer");
        return Tools.createCertificate((InputStream)resource);
    }

    private static InputStream getResource(String resource) {
        return SendParsedEncryptedData.class.getResourceAsStream(resource);
    }

    private static URI createIntermedUri() throws URISyntaxException {
        String testEntry = "http://gov.test.osci.de/osci-manager-entry/externalentry";
        return new URI("http://gov.test.osci.de/osci-manager-entry/externalentry");
    }

    private static Originator createOriginator() throws Exception {
        Signer signer = SendParsedEncryptedData.createSigner();
        PKCS12Decrypter decrypter = new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/alice_cipher_4096.p12", PIN);
        return new Originator(signer, (Decrypter)decrypter);
    }

    private static Signer createSigner() throws Exception {
        String cert = "/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12";
        return new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", PIN);
    }

    private static Addressee createAddressee() throws CertificateException {
        String cert = "/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer";
        InputStream resource = SendParsedEncryptedData.getResource("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer");
        return new Addressee(null, Tools.createCertificate((InputStream)resource));
    }

    private static Reader createReaderEncrypt() throws CertificateException {
        System.out.println("Erzeuge OSCI-Rolle Leser");
        String cert = "/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer";
        InputStream resource = SendParsedEncryptedData.getResource("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer");
        Reader reader = new Reader(Tools.createCertificate((InputStream)resource));
        reader.cipherRefId = DAVE_CIPHER_REF;
        return reader;
    }

    private static Reader createReaderDecrypt() throws Exception {
        Reader reader = new Reader((Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.p12", PIN));
        reader.cipherRefId = DAVE_CIPHER_REF;
        return reader;
    }

    private static Author createAuthorSign() throws Exception {
        Author author = new Author(SendParsedEncryptedData.createSigner(), null);
        author.signatureRefId = ALICE_SIGN_REF;
        return author;
    }

    private static String getMsgId(DialogHandler dh) throws Exception {
        GetMessageId getMsgId = new GetMessageId(dh);
        ResponseToGetMessageId rsp2GetMsgID = getMsgId.send();
        return rsp2GetMsgID.getMessageId();
    }
}

