/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.osci12.common.Constants;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;

public class Base64InputStream
extends FilterInputStream {
    private final byte[] store = new byte[3];
    private int pos = 0;
    private boolean endOfStream;
    private int nos = 0;
    private byte[] buffer;
    private int readPos = 0;
    private int endPos = 0;

    public Base64InputStream(InputStream in) {
        super(new BufferedInputStream(in));
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            this.buffer = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            this.endPos = this.internalRead(this.buffer, 0, this.buffer.length);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.endPos < 0) {
            return 0;
        }
        return this.endPos - this.readPos;
    }

    @Override
    public int read() throws IOException {
        if (this.endPos < 0) {
            return -1;
        }
        if (this.endPos > this.readPos) {
            int ret = this.buffer[this.readPos++] & 0xFF;
            if (this.endPos == this.readPos) {
                this.endPos = this.internalRead(this.buffer, 0, this.buffer.length);
                this.readPos = 0;
            }
            return ret;
        }
        byte[] tmp = new byte[1];
        if (this.read(tmp, 0, 1) < 0) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    public int internalRead() throws IOException {
        if (this.pos >= this.nos) {
            this.getStore();
        }
        if (this.endOfStream) {
            return -1;
        }
        return this.store[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] target) throws IOException {
        return this.read(target, 0, target.length);
    }

    @Override
    public int read(byte[] target, int start, int length) throws IOException {
        if (this.endPos < 0) {
            return -1;
        }
        if (length > this.endPos - this.readPos) {
            length = this.endPos - this.readPos;
        }
        System.arraycopy(this.buffer, this.readPos, target, start, length);
        this.readPos += length;
        if (this.endPos == this.readPos) {
            this.endPos = this.internalRead(this.buffer, 0, this.buffer.length);
            this.readPos = 0;
        }
        return length;
    }

    public int internalRead(byte[] target, int start, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int read = 0;
        while (read < length && this.pos < this.nos) {
            target[start + read++] = this.store[this.pos++];
        }
        while (length - read >= this.nos) {
            this.getStore();
            if (this.endOfStream) break;
            while (this.pos < this.nos) {
                target[start + read++] = this.store[this.pos++];
            }
        }
        if (!this.endOfStream) {
            if (this.pos >= this.nos) {
                this.getStore();
            }
            while (read < length && this.pos < this.nos) {
                target[start + read++] = this.store[this.pos++];
            }
        } else if (read == 0) {
            return -1;
        }
        return read;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void mark() {
    }

    @Override
    public void reset() {
    }

    private void getStore() throws IOException {
        this.pos = 0;
        int buffer = 0;
        int bytesRead = 0;
        block4: while (bytesRead < 4) {
            int data = this.in.read();
            if (data == -1) {
                this.nos = 0;
                this.endOfStream = true;
                return;
            }
            data = this.decodeInt(data);
            switch (data) {
                case -1: {
                    continue block4;
                }
                case -2: {
                    if (bytesRead == 2 || bytesRead == 3) break block4;
                    throw new IOException("Invalid placement of '=' in the stream");
                }
                default: {
                    buffer = buffer << 6 | data;
                    ++bytesRead;
                    continue block4;
                }
            }
        }
        if (bytesRead == 4) {
            this.nos = 3;
            this.store[2] = (byte)(buffer & 0xFF);
            this.store[1] = (byte)((buffer >>= 8) & 0xFF);
            this.store[0] = (byte)((buffer >>= 8) & 0xFF);
        } else if (bytesRead == 2) {
            this.nos = 1;
            this.in.read();
            this.store[0] = (byte)((buffer >>= 4) & 0xFF);
        } else {
            this.nos = 2;
            this.store[1] = (byte)((buffer >>= 2) & 0xFF);
            this.store[0] = (byte)((buffer >>= 8) & 0xFF);
        }
    }

    private int decodeInt(int src) {
        if (src >= 65 && src <= 90) {
            return src - 65;
        }
        if (src >= 97 && src <= 122) {
            return src - 97 + 26;
        }
        if (src >= 48 && src <= 57) {
            return src - 48 + 52;
        }
        if (src == 43) {
            return 62;
        }
        if (src == 47) {
            return 63;
        }
        if (src == 61) {
            return -2;
        }
        return -1;
    }
}

