/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.ParserHelper;
import de.osci.helper.StoreInputStream;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CanParser
extends DefaultHandler
implements LexicalHandler {
    private static Logger log = LoggerFactory.getLogger(CanParser.class);
    private boolean checkIds = true;
    private static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected int elementDepth;
    protected boolean isFirstProcessing = true;
    private DigestOutputStream outs = null;
    private MessageDigest md;
    private XMLReader parser = null;
    private Stack<Map<String, String>> sampleNSStack = new Stack();
    protected boolean useComment = false;
    private boolean insideHeader = false;
    private boolean headerAlreadyFound = false;
    private boolean insideContainerSignatureProps = false;
    private boolean insideTransportSignedInfo = false;
    private String currentTransportSignatureRef;
    private Hashtable<String, String> transportDigestMethods;
    private boolean readNS;
    private boolean signedElement;
    private Map<String, String> tmpMap;
    Hashtable<String, MessageDigest> messageDigests;
    private String id;
    Hashtable<String, byte[]> digestValues;
    private HashSet<String> foundRefIds;
    Vector<byte[]> signedInfos;
    Vector<String> signedProperties;
    Vector<String> cocoNS;
    private OutputStream out;
    private Vector<String> tag;
    private ContentHandler parent;
    private ErrorHandler errorHandler;
    private String name;
    private StoreInputStream sis;
    private static SAXParserFactory spf = SAXParserFactory.newInstance();
    private Writer outWriter;
    private Writer tmpWriter;
    private byte[] controlBlock;
    private String controlBlockID;
    private String soapId;

    public CanParser(Vector<String> tag, XMLReader xmlReader, ContentHandler parent, String name) throws NoSuchAlgorithmException {
        this(xmlReader, new ByteArrayOutputStream());
        this.tag = tag;
        this.parent = parent;
        this.name = name;
    }

    @Deprecated(since="1.8")
    public CanParser(OutputStream out, StoreInputStream sis) throws SAXException, ParserConfigurationException, NoSuchAlgorithmException {
        this(spf.newSAXParser().getXMLReader(), out);
        this.sis = sis;
    }

    public CanParser(OutputStream out, StoreInputStream sis, boolean checkIds) throws SAXException, ParserConfigurationException, NoSuchAlgorithmException {
        this(spf.newSAXParser().getXMLReader(), out);
        this.sis = sis;
        this.checkIds = checkIds;
    }

    private CanParser(XMLReader xmlReader, OutputStream out) {
        this.out = out;
        this.parser = xmlReader;
        this.errorHandler = this.parser.getErrorHandler();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.parser.setDTDHandler(this);
        this.parser.setEntityResolver(this);
        try {
            this.parser.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this);
        }
        catch (SAXException e) {
            log.trace(String.valueOf(e));
        }
        ParserHelper.setFeatures(this.parser);
        this.outs = new DigestOutputStream(this.out, null);
        this.outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outs, Constants.CHARSET_ENCODING));
    }

    @Override
    public void startDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("startDocument");
        }
        TreeMap<String, String> sampleNSMap = new TreeMap<String, String>();
        this.elementDepth = 0;
        sampleNSMap.put("xmlns", "");
        this.sampleNSStack.push(sampleNSMap);
        this.digestValues = new Hashtable();
        this.foundRefIds = new HashSet();
        this.transportDigestMethods = new Hashtable();
        this.messageDigests = new Hashtable();
        this.currentTransportSignatureRef = "";
        if (this.signedInfos == null) {
            this.signedInfos = new Vector();
        }
        if (this.cocoNS == null) {
            this.cocoNS = new Vector();
        }
        this.outs.on(false);
        this.soapId = null;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.elementDepth == 0 && this.isFirstProcessing) {
                this.outWriter.write("<?" + target + " ");
                this.normalizeProcessingInstruction(data);
                this.outWriter.write("?>\n");
            }
            if (this.elementDepth == 0 && !this.isFirstProcessing) {
                this.outWriter.write("\n<?" + target + " ");
                this.normalizeProcessingInstruction(data);
                this.outWriter.write("?>");
            }
            if (this.isFirstProcessing) {
                this.isFirstProcessing = false;
            }
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    private boolean isOSCISignatureHeader(String uri, String localName) {
        return Constants.HeaderTags.SupplierSignature.getNamespace().getUri().equals(uri) && (Constants.HeaderTags.ClientSignature.getElementName().equals(localName) || Constants.HeaderTags.SupplierSignature.getElementName().equals(localName));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("CAN START ELEMENT: " + qName);
        }
        try {
            void var7_12;
            String sKey;
            void var7_10;
            int i;
            String idAll = attrs.getValue("Id");
            if (log.isDebugEnabled()) {
                log.debug("Element: " + qName + " Id: " + idAll);
            }
            if (idAll != null && !this.foundRefIds.add("#" + idAll)) {
                log.error("#### DOUBLE REF-ID FOUND!!! Element with Id: " + idAll + " already exist ###");
                if (this.checkIds && ParserHelper.isSecureTransportDataCheck()) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
                }
            }
            this.signedElement = false;
            this.readNS = false;
            int attCount = attrs.getLength();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            TreeMap<String, String> sampleNSMap = new TreeMap<String, String>(this.sampleNSStack.peek());
            ++this.elementDepth;
            if (this.soapId == null) {
                this.soapId = "";
                for (i = 0; i < attrs.getLength(); ++i) {
                    if (!attrs.getValue(i).equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
                    if (!this.soapId.isEmpty()) {
                        throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
                    }
                    this.soapId = attrs.getQName(i).substring(attrs.getQName(i).indexOf(58) + 1);
                }
            }
            if (this.sis != null && qName.equals(this.soapId + ":Envelope")) {
                this.sis.setSave(attrs.getValue("xsi:schemaLocation") != null && attrs.getValue("xsi:schemaLocation").indexOf("schema/soapMessageEncrypted.xsd") < 0);
            }
            if (qName.equals(this.soapId + ":Header")) {
                if (this.headerAlreadyFound) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + this.soapId + ":Header");
                this.insideHeader = true;
                this.headerAlreadyFound = true;
            } else if (this.insideHeader && localName.equals("ControlBlock")) {
                this.signedElement = true;
                this.controlBlockID = "#" + attrs.getValue("Id");
                this.outWriter = new SplitWriter(this.outWriter);
            } else if (this.insideHeader && this.elementDepth == 3 && !this.isOSCISignatureHeader(uri, localName) || this.elementDepth == 2 && qName.equals(this.soapId + ":Body")) {
                this.id = attrs.getValue("Id");
                String mdm = this.transportDigestMethods.get("#" + this.id);
                if (mdm == null) {
                    mdm = "http://www.w3.org/2001/04/xmlenc#sha256";
                }
                this.signedElement = true;
                try {
                    this.outWriter.flush();
                }
                catch (Throwable e) {
                    log.error(String.valueOf(e));
                }
                if (this.messageDigests.get(mdm) == null) {
                    if (DialogHandler.getSecurityProvider() == null) {
                        this.messageDigests.put(mdm, MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(mdm)));
                    } else {
                        this.messageDigests.put(mdm, MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(mdm), DialogHandler.getSecurityProvider()));
                    }
                }
                this.md = this.messageDigests.get(mdm);
                this.md.reset();
                this.outs.setMessageDigest(this.md);
                this.outs.on(true);
            } else if (localName.equals("SignedInfo") || !this.insideHeader && localName.equals("SignedProperties")) {
                this.signedElement = true;
                this.readNS = true;
                this.outWriter = new SplitWriter(this.outWriter);
                if (this.insideHeader && localName.equals("SignedInfo")) {
                    this.insideTransportSignedInfo = true;
                } else if (localName.equals("SignedProperties")) {
                    this.insideContainerSignatureProps = true;
                }
            } else if (this.insideTransportSignedInfo) {
                if (localName.equals("Reference")) {
                    this.currentTransportSignatureRef = attrs.getValue("URI");
                } else if (localName.equals("DigestMethod")) {
                    this.transportDigestMethods.put(this.currentTransportSignatureRef, attrs.getValue("Algorithm"));
                }
            } else if (localName.equals("ContentContainer")) {
                this.signedElement = true;
                this.readNS = true;
            }
            for (i = 0; i < attCount; ++i) {
                if (attrs.getQName(i).startsWith("xmlns:") || attrs.getQName(i).equals("xmlns")) {
                    if (!sampleNSMap.containsKey(attrs.getQName(i)) || !attrs.getValue(i).equals(sampleNSMap.get(attrs.getQName(i)))) {
                        sampleNSMap.put(attrs.getQName(i), attrs.getValue(i));
                        treeMap.put(" ," + attrs.getQName(i), attrs.getValue(i));
                        continue;
                    }
                    sampleNSMap.put(attrs.getQName(i), attrs.getValue(i));
                    continue;
                }
                if (!attrs.getURI(i).equals("")) {
                    treeMap.put(attrs.getURI(i) + "," + attrs.getQName(i), attrs.getValue(i));
                    continue;
                }
                treeMap.put("," + attrs.getQName(i), attrs.getValue(i));
            }
            this.sampleNSStack.push(sampleNSMap);
            if (this.readNS) {
                this.tmpMap = treeMap;
                TreeMap treeMap2 = new TreeMap();
            }
            this.outWriter.write("<" + qName);
            if (this.signedElement) {
                for (Map.Entry stringStringEntry : sampleNSMap.entrySet()) {
                    Map.Entry entry = stringStringEntry;
                    if (((String)entry.getValue()).isEmpty()) continue;
                    var7_10.put(" ," + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (this.readNS) {
                this.tmpWriter = this.outWriter;
                this.outWriter = new StringWriter();
                for (Map.Entry entry : var7_10.entrySet()) {
                    sKey = (String)entry.getKey();
                    this.outWriter.write(" " + sKey.substring(sKey.indexOf(",") + 1) + "=\"");
                    this.normalizeAttr((String)entry.getValue());
                    this.outWriter.write("\"");
                }
                Map<String, String> map = this.tmpMap;
                if (localName.equals("SignedInfo") || this.insideContainerSignatureProps) {
                    ((SplitWriter)this.tmpWriter).sb.append(((StringWriter)this.outWriter).getBuffer());
                } else {
                    this.cocoNS.add(((StringWriter)this.outWriter).toString());
                }
                this.outWriter = this.tmpWriter;
                this.tmpWriter = null;
            }
            for (Map.Entry entry : var7_12.entrySet()) {
                sKey = (String)entry.getKey();
                this.outWriter.write(" " + sKey.substring(sKey.indexOf(",") + 1) + "=\"");
                this.normalizeAttr((String)entry.getValue());
                this.outWriter.write("\"");
            }
            this.outWriter.write(">");
            return;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.normalizeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("CAN END ELEMENT: " + qName);
        }
        --this.elementDepth;
        try {
            this.outWriter.write("</" + qName + ">");
            if (localName.equals("SignedInfo")) {
                if (!this.insideHeader && this.signedInfos.isEmpty()) {
                    this.signedInfos.add(null);
                }
                this.signedInfos.add(((SplitWriter)this.outWriter).sb.toString().getBytes(Constants.CHARSET_ENCODING));
                this.outWriter = ((SplitWriter)this.outWriter).wr;
                if (this.insideTransportSignedInfo) {
                    this.insideTransportSignedInfo = false;
                    String digAlgo = this.transportDigestMethods.get(this.controlBlockID);
                    if (digAlgo != null) {
                        this.md = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digAlgo)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digAlgo), DialogHandler.getSecurityProvider());
                        this.messageDigests.put(digAlgo, this.md);
                        if (this.digestValues.containsKey(this.controlBlockID)) {
                            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
                        }
                        this.digestValues.put(this.controlBlockID, this.md.digest(this.controlBlock));
                    }
                }
            } else if (this.insideContainerSignatureProps && localName.equals("SignedProperties")) {
                this.signedProperties.add(((SplitWriter)this.outWriter).sb.toString());
                this.outWriter = ((SplitWriter)this.outWriter).wr;
                this.insideContainerSignatureProps = false;
            } else if (this.insideHeader && localName.equals("ControlBlock")) {
                this.outWriter.flush();
                this.controlBlock = ((SplitWriter)this.outWriter).sb.toString().getBytes(Constants.CHARSET_ENCODING);
                this.outWriter = ((SplitWriter)this.outWriter).wr;
                this.id = null;
            } else if (this.insideHeader && this.elementDepth == 2 && !this.isOSCISignatureHeader(uri, localName) || this.elementDepth == 1 && qName.equals(this.soapId + ":Body")) {
                this.outWriter.flush();
                if (this.id != null) {
                    if (this.digestValues.containsKey("#" + this.id)) {
                        throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
                    }
                    log.debug("######### add to msgPart digest to Hashtable: #" + this.id);
                    this.digestValues.put("#" + this.id, this.md.digest());
                    this.md = null;
                }
                this.outs.on(false);
                this.id = null;
            }
            if (!this.sampleNSStack.empty()) {
                this.sampleNSStack.pop();
            }
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        if (qName.equals(this.soapId + ":Header")) {
            this.insideHeader = false;
        }
        if (this.name != null && qName.equals(this.name)) {
            this.endDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("CAN END DOC ");
        }
        this.isFirstProcessing = true;
        try {
            this.outWriter.flush();
            this.outWriter.close();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        if (this.tag != null) {
            this.tag.add(((ByteArrayOutputStream)this.out).toString(Constants.CHARSET_ENCODING));
            if (this.errorHandler != null) {
                this.parser.setErrorHandler(this.errorHandler);
            }
            if (this.parent != null) {
                this.parser.setContentHandler(this.parent);
            }
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Warning: " + ex);
        }
        throw ex;
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Error: " + ex);
        }
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        log.error("Fatal Error: ", (Throwable)ex);
        throw ex;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("CDATA");
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("CDATA");
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.useComment) {
            try {
                if (this.elementDepth == 0) {
                    this.outWriter.write("\n");
                }
                this.outWriter.write("<!--");
                this.normalizeText(ch, start, length);
                this.outWriter.write("-->");
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }
    }

    protected void normalizeAttr(String s) throws IOException {
        block9: for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '&': {
                    this.outWriter.write("&amp;");
                    continue block9;
                }
                case '<': {
                    this.outWriter.write("&lt;");
                    continue block9;
                }
                case '>': {
                    this.outWriter.write("&gt;");
                    continue block9;
                }
                case '\"': {
                    this.outWriter.write("&quot;");
                    continue block9;
                }
                case '\t': {
                    this.outWriter.write("&#x9;");
                    continue block9;
                }
                case '\n': {
                    this.outWriter.write("&#xA;");
                    continue block9;
                }
                case '\r': {
                    this.outWriter.write("&#xD;");
                    continue block9;
                }
                default: {
                    this.outWriter.write(c);
                }
            }
        }
    }

    protected void normalizeProcessingInstruction(String s) throws IOException {
        block3: for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '\r': {
                    this.outWriter.write("&#xD;");
                    continue block3;
                }
                default: {
                    this.outWriter.write(c);
                }
            }
        }
    }

    protected void normalizeText(char[] ch, int off, int len) throws IOException {
        block6: for (int j = off; j < off + len; ++j) {
            switch (ch[j]) {
                case '&': {
                    this.outWriter.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.outWriter.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.outWriter.write("&gt;");
                    continue block6;
                }
                case '\r': {
                    this.outWriter.write("&#xD;");
                    continue block6;
                }
                default: {
                    this.outWriter.write(ch[j]);
                }
            }
        }
    }

    public void startCanonicalization(InputStream in, boolean withComment) throws SAXException, IOException {
        InputSource ins = new InputSource(in);
        this.useComment = withComment;
        this.parser.parse(ins);
    }

    static {
        spf.setNamespaceAware(true);
        spf.setValidating(false);
    }

    static class SplitWriter
    extends Writer {
        Writer wr;
        StringBuffer sb = new StringBuffer();

        SplitWriter(Writer w) {
            this.wr = w;
        }

        @Override
        public void write(String s) throws IOException {
            this.sb.append(s);
            this.wr.write(s);
        }

        @Override
        public void close() throws IOException {
            this.wr.close();
        }

        @Override
        public void flush() throws IOException {
            this.wr.flush();
        }

        @Override
        public void write(int c) throws IOException {
            this.sb.append((char)c);
            this.wr.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.write(new String(cbuf, off, len));
        }
    }
}

