/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.CanParser;
import de.osci.helper.StoreInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Canonizer
extends FilterInputStream {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String EXTERNAL_GENERAL_ENTITIES_FEATURE_ID = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE_ID = "http://xml.org/sax/features/external-parameter-entities";
    private PipedInputStream pis;
    private PipedOutputStream pos;
    private Exception canException;
    private InputStream input;
    private CanParser cp;

    public Canonizer(InputStream in, StoreInputStream sis) throws IOException, SAXException, ParserConfigurationException, NoSuchAlgorithmException {
        this(in, sis, true);
    }

    public Canonizer(InputStream in, StoreInputStream sis, boolean checkIds) throws IOException, SAXException, ParserConfigurationException, NoSuchAlgorithmException {
        super(in);
        this.input = in;
        this.pis = new PipedInputStream();
        this.pos = new PipedOutputStream(this.pis);
        this.cp = new CanParser(this.pos, sis, checkIds);
        this.cp.signedInfos = new Vector();
        this.cp.signedProperties = new Vector();
        this.cp.cocoNS = new Vector();
        this.canException = null;
        new Thread(){

            @Override
            public void run() {
                try {
                    Canonizer.this.cp.startCanonicalization(Canonizer.this.input, false);
                    Canonizer.this.pos.close();
                }
                catch (SAXException e) {
                    Canonizer.this.canException = e.getException();
                }
                catch (Exception e) {
                    Canonizer.this.canException = e;
                }
                finally {
                    try {
                        Canonizer.this.pos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }.start();
    }

    @Override
    public int read() throws IOException {
        return this.pis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.pis.read(b, off, len);
    }

    public Hashtable<String, byte[]> getDigestValues() {
        return this.cp.digestValues;
    }

    public Vector<byte[]> getSignedInfos() {
        return this.cp.signedInfos;
    }

    public Vector<String> getSignedProperties() {
        return this.cp.signedProperties;
    }

    public Vector<String> getContainerNS() {
        return this.cp.cocoNS;
    }

    public Exception getCanException() {
        return this.canException;
    }
}

