/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.Canonizer;
import de.osci.helper.Tools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class CustomHeaderExtention {
    private static Logger log = LoggerFactory.getLogger(CustomHeaderExtention.class);
    private static final String OSCI_NAMESPACE = " xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";

    public abstract String getCustomHeaderRefID();

    public abstract CustomHeaderExtention parseIncomingHeader(String var1) throws IOException;

    public abstract String getOutgoingHeader();

    protected static String addIdToCustomHeader(String customHeaderXml, String id) {
        customHeaderXml = customHeaderXml.substring(customHeaderXml.indexOf(">") + 1);
        int start = customHeaderXml.indexOf(">");
        return customHeaderXml.substring(0, start).concat(" Id=\"" + id + "\"").concat(customHeaderXml.substring(start));
    }

    public static String makeOSCICustomHeader(String customHeaderXml) {
        int startAfterTag = customHeaderXml.indexOf(">");
        String osciCustomHeaderXml = customHeaderXml.substring(0, startAfterTag).concat(OSCI_NAMESPACE).concat(customHeaderXml.substring(startAfterTag));
        Canonizer can = null;
        try {
            can = new Canonizer(new ByteArrayInputStream(osciCustomHeaderXml.getBytes(StandardCharsets.UTF_8)), null);
            return new String(Tools.readBytes(can), StandardCharsets.UTF_8);
        }
        catch (IOException | NoSuchAlgorithmException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Error when canonizing custom header: " + e.getMessage());
        }
    }

    public static String makeOSCICustomHeaderWithId(String customHeaderXml, String id) {
        return CustomHeaderExtention.makeOSCICustomHeader(CustomHeaderExtention.addIdToCustomHeader(customHeaderXml, id));
    }
}

