/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.MIMEParser;
import de.osci.osci12.common.Constants;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class MIMEPartInputStream
extends FilterInputStream {
    private String contentType;
    private String encoding;
    private String contentID;
    private int s;
    private long contentLength;
    private boolean closed = false;
    private byte[] end;
    private MIMEParser parser;
    public Hashtable<String, String> mime_headers;

    public MIMEPartInputStream(MIMEParser parser, String contentType, String encoding, String contentID, long contentLength) throws UnsupportedEncodingException {
        super(parser.in);
        this.parser = parser;
        this.end = ("\r\n--" + parser.boundary).getBytes(Constants.CHARSET_ENCODING);
        this.contentType = contentType;
        this.encoding = encoding;
        this.contentID = contentID;
        this.contentLength = contentLength;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int i = this.read(tmp, 0, 1);
        if (i == -1) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.parser.buffer != null) {
            if (this.parser.bufferPointer + len <= this.parser.buffer.length) {
                System.arraycopy(this.parser.buffer, this.parser.bufferPointer, b, off, len);
                this.parser.bufferPointer += len;
                this.s = len;
            } else {
                int bufBytes = this.parser.buffer.length - this.parser.bufferPointer;
                System.arraycopy(this.parser.buffer, this.parser.bufferPointer, b, off, bufBytes);
                this.s = this.in.read(b, off + bufBytes, len - bufBytes);
                this.s = this.s > -1 ? (this.s += bufBytes) : bufBytes;
                this.parser.buffer = null;
                this.parser.bufferPointer = 0;
            }
        } else {
            this.s = this.in.read(b, off, len);
        }
        if (this.s == -1) {
            throw new IOException("EOS before marker.");
        }
        int i = off;
        int patternIndex = -1;
        for (i = off; i < off + this.s; ++i) {
            if (b[i] == this.end[0]) {
                int tmp = i;
                for (patternIndex = 0; patternIndex < this.end.length && tmp < off + this.s && b[tmp] == this.end[patternIndex]; ++patternIndex, ++tmp) {
                }
                if (patternIndex == this.end.length) {
                    if (this.parser.buffer == null) {
                        this.parser.buffer = new byte[this.s - i + off];
                        System.arraycopy(b, i, this.parser.buffer, 0, this.parser.buffer.length);
                        this.parser.bufferPointer = 0;
                    } else {
                        this.parser.bufferPointer -= len - (i - off);
                    }
                    this.s = i - off;
                    this.closed = true;
                    break;
                }
                if (tmp >= off + this.s) {
                    int rest = this.end.length - patternIndex;
                    if (this.parser.buffer == null || this.parser.buffer.length - this.parser.bufferPointer < rest) {
                        int bufferIndex = 0;
                        if (this.parser.buffer == null) {
                            this.parser.buffer = new byte[rest];
                        } else {
                            bufferIndex = this.parser.buffer.length - this.parser.bufferPointer;
                            byte[] newBuffer = new byte[rest];
                            System.arraycopy(this.parser.buffer, this.parser.bufferPointer, newBuffer, 0, this.parser.buffer.length - this.parser.bufferPointer);
                            this.parser.buffer = newBuffer;
                        }
                        int p = 0;
                        while (bufferIndex < this.parser.buffer.length) {
                            p = this.in.read(this.parser.buffer, bufferIndex, 1);
                            if (p > 0) {
                                ++bufferIndex;
                                continue;
                            }
                            if (p >= 0) continue;
                            throw new IOException("EOS before marker.");
                        }
                        this.parser.bufferPointer = 0;
                    }
                    tmp = this.parser.bufferPointer;
                    while (patternIndex < this.end.length && this.parser.buffer[tmp] == this.end[patternIndex]) {
                        ++patternIndex;
                        ++tmp;
                    }
                    if (patternIndex == this.end.length) {
                        this.s = i - off;
                        byte[] newBuffer = new byte[this.end.length + this.parser.buffer.length - tmp];
                        System.arraycopy(this.end, 0, newBuffer, 0, this.end.length);
                        System.arraycopy(this.parser.buffer, tmp, newBuffer, this.end.length, this.parser.buffer.length - tmp);
                        this.parser.buffer = newBuffer;
                        this.parser.bufferPointer = 0;
                        this.closed = true;
                    }
                }
            }
            patternIndex = 0;
        }
        if (this.s == 0) {
            this.close();
            return -1;
        }
        return this.s;
    }

    @Override
    public void close() throws IOException {
        byte[] tmp = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
        while (this.read(tmp) > -1) {
        }
        this.closed = true;
    }

    public String getContentID() {
        return this.contentID;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }
}

