/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.osci12.common.Constants;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserHelper {
    private static SAXParserFactory spf = SAXParserFactory.newInstance();
    private static Logger log;

    public static void setFeatures(XMLReader reader) {
        ParserHelper.addFeature(reader, "http://xml.org/sax/features/external-general-entities", false);
        ParserHelper.addFeature(reader, "http://xml.org/sax/features/external-parameter-entities", false);
        ParserHelper.addFeature(reader, "http://xml.org/sax/features/validation", false);
        ParserHelper.addFeature(reader, "http://xml.org/sax/features/namespaces", true);
        ParserHelper.addFeature(reader, "http://xml.org/sax/features/namespace-prefixes", true);
        ParserHelper.addFeature(reader, "http://apache.org/xml/features/disallow-doctype-decl", true);
        ParserHelper.addFeature(reader, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        ParserHelper.addFeature(reader, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        ParserHelper.addFeature(reader, "http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static SAXParser getNewSAXParser() throws ParserConfigurationException, SAXException {
        return spf.newSAXParser();
    }

    private static void addFeature(XMLReader reader, String feature, boolean value) {
        block2: {
            try {
                reader.setFeature(feature, value);
            }
            catch (SAXException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("warning: Parser does not support feature (" + feature + ")");
            }
        }
    }

    public static boolean isSecureContentDataCheck() {
        return !"false".equals(System.getProperty(Constants.SystemProperties.SecureContentDataCheck.getPropertyValue()));
    }

    public static boolean isSecureTransportDataCheck() {
        return !"false".equals(System.getProperty(Constants.SystemProperties.SecureTransportDataCheck.getPropertyValue()));
    }

    public static boolean isSwitchToGCM() {
        return !"false".equals(System.getProperty(Constants.SystemProperties.SwitchToGCM.getPropertyValue()));
    }

    public static boolean isGCMAlgorithmOnly() {
        return "true".equals(System.getProperty(Constants.SystemProperties.GCMAlgorithmOnly.getPropertyValue()));
    }

    public static boolean isElement(Constants.HeaderTags expectedElement, String elementName, String uri) {
        return expectedElement.getElementName().equals(elementName) && expectedElement.getNamespace().getUri().equals(uri);
    }

    public static boolean isElement(Constants.CommonTags expectedElement, String elementName, String uri) {
        return expectedElement.getElementName().equals(elementName) && expectedElement.getNamespace().getUri().equals(uri);
    }

    static {
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        log = LoggerFactory.getLogger(ParserHelper.class);
    }
}

