/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StoreInputStream
extends FilterInputStream {
    private OutputStream copyStream;
    private int s;
    private ByteArrayOutputStream buffer;
    private boolean closed = false;
    private boolean save = false;

    public StoreInputStream(InputStream inStream, OutputStream copyStream) {
        super(inStream);
        this.copyStream = copyStream;
        this.buffer = new ByteArrayOutputStream();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        this.s = this.in.read();
        if (this.s == -1) {
            return -1;
        }
        if (this.buffer != null) {
            this.buffer.write(this.s);
        } else if (this.save) {
            this.copyStream.write(this.s);
        }
        return this.s;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        this.s = this.in.read(b, off, len);
        if (this.s == -1) {
            return -1;
        }
        if (this.buffer != null) {
            this.buffer.write(b, off, this.s);
        } else if (this.save) {
            this.copyStream.write(b, off, this.s);
        }
        return this.s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSave(boolean save) throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            this.save = save;
            if (save) {
                this.buffer.close();
                this.copyStream.write(this.buffer.toByteArray());
            }
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.in.close();
        if (this.buffer != null) {
            this.buffer.close();
            this.copyStream.write(this.buffer.toByteArray());
        }
        this.copyStream.close();
        this.closed = true;
    }
}

