/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymCipherInputStream
extends FilterInputStream {
    private static Logger log = LoggerFactory.getLogger(SymCipherInputStream.class);
    private Cipher cipher;
    private String symCipherAlgo = null;
    private int count = 0;
    byte[] iv;
    private boolean encrypt;
    private byte[] b = new byte[1];

    public SymCipherInputStream(InputStream inStream, String symAlgorithm, boolean encrypt) throws IOException, NoSuchAlgorithmException {
        this(inStream, Crypto.createSymKey(symAlgorithm), symAlgorithm, 12, encrypt);
    }

    public SymCipherInputStream(InputStream inStream, SecretKey symKey, String symAlgorithm, boolean encrypt) throws IOException {
        this(inStream, symKey, symAlgorithm, 12, encrypt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SymCipherInputStream(InputStream inStream, SecretKey symKey, String symAlgorithm, int ivLength, boolean encrypt) throws IOException {
        super(null);
        this.symCipherAlgo = symAlgorithm;
        this.encrypt = encrypt;
        if (inStream == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        if (symKey == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_secondargument.name()) + " null");
        }
        try {
            if (symAlgorithm == null) {
                throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " null");
            }
            if (symAlgorithm.endsWith("-cbc")) {
                if (ParserHelper.isGCMAlgorithmOnly()) {
                    throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " Wrong algorithm! only GCM supported! Given: " + symAlgorithm);
                }
                log.warn("CBC will not be supported in the future and is not allowed for transport encryption any longer!");
            }
            this.cipher = DialogHandler.getSecurityProvider() == null ? Cipher.getInstance(Constants.JCA_JCE_MAP.get(symAlgorithm)) : Cipher.getInstance(Constants.JCA_JCE_MAP.get(symAlgorithm), DialogHandler.getSecurityProvider());
            if (encrypt) {
                this.cipher.init(1, symKey);
                this.iv = this.cipher.getIV();
            } else {
                if (this.symCipherAlgo.endsWith("tripledes-cbc")) {
                    this.iv = new byte[8];
                } else if (this.symCipherAlgo.endsWith("-gcm")) {
                    if (ivLength != 16 && ivLength != 12) throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " Wrong IV length " + ivLength + " given for algorithm " + symAlgorithm);
                    log.debug("Use IV length for incoming AES-GCM-encrypted stream: " + ivLength);
                    this.iv = new byte[ivLength];
                    if (ivLength == 16) {
                        log.warn(DialogHandler.text.getString(Constants.LanguageTextEntries.warning_iv_length.name()));
                    }
                } else {
                    this.iv = new byte[16];
                }
                for (int i = 0; i < this.iv.length; ++i) {
                    int tmp = inStream.read();
                    if (tmp == -1) {
                        throw new IOException("Unexpected EOS");
                    }
                    this.iv[i] = (byte)tmp;
                }
                IvParameterSpec algoParamSpec = new IvParameterSpec(this.iv);
                this.cipher.init(2, (Key)symKey, algoParamSpec);
            }
        }
        catch (GeneralSecurityException ex) {
            if (encrypt) {
                log.warn("Exception at encryption", (Throwable)ex);
                throw new IOException(DialogHandler.text.getString("encryption_error"));
            }
            log.warn("Exception at decryption", (Throwable)ex);
            throw new IOException(DialogHandler.text.getString("decryption_error"));
        }
        this.in = new CipherInputStream(inStream, this.cipher);
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.b, 0, 1) == -1) {
            return -1;
        }
        return this.b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.encrypt && this.count < this.iv.length) {
            if (len < this.iv.length - this.count) {
                System.arraycopy(this.iv, this.count, b, off, len);
                this.count += len;
                return len;
            }
            System.arraycopy(this.iv, this.count, b, off, this.iv.length - this.count);
            try {
                int ret = this.in.read(b, off + this.iv.length - this.count, len - this.iv.length + this.count);
                this.count = this.iv.length;
                return ret += this.iv.length - this.count;
            }
            catch (IOException ex) {
                if (this.findException(ex, BadPaddingException.class)) {
                    log.error("Bad padding exception. Return end of stream!!!", (Throwable)ex);
                    return -1;
                }
                throw ex;
            }
        }
        try {
            return this.in.read(b, off, len);
        }
        catch (IOException ex) {
            if (this.findException(ex, BadPaddingException.class)) {
                log.error("Bad padding exception. Return end of stream!!!", (Throwable)ex);
                return -1;
            }
            throw ex;
        }
    }

    public byte[] getIv() {
        return this.iv;
    }

    private boolean findException(Throwable ex, Class<? extends Throwable> findEx) {
        if (this.symCipherAlgo.endsWith("-gcm")) {
            return false;
        }
        while (ex.getCause() != null) {
            if (findEx.isInstance(ex.getCause())) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }
}

