/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.common;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.common.SoapClientException;
import de.osci.osci12.common.SwapBuffer;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.extinterfaces.DialogFinder;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.extinterfaces.ProgressEventHandlerI;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Role;
import de.osci.osci12.soapheader.ControlBlockH;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogHandler {
    private static Logger log = LoggerFactory.getLogger(DialogHandler.class);
    private static Provider securityProvider;
    public static final ResourceBundle text;
    private static String digestAlgorithm;
    private String symmetricCipherAlgorithm = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    private int ivLength = 12;
    private String asymmetricCipherAlgorithm = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    private static String secureRandomAlgorithm;
    private static String signatureAlgorithm;
    private boolean checkSignatures = true;
    private ControlBlockH controlblock = new ControlBlockH();
    private boolean createSignatures = true;
    private boolean sendFeatureDescription = true;
    private TransportI transportModule;
    private boolean encryption = true;
    private String languageList = Locale.getDefault().getLanguage();
    private ProgressEventHandlerI progressEventHandler = null;
    public Role client = null;
    public Role supplier = null;
    boolean disableControlBlockCheck = false;
    static DialogFinder dialogFinder;
    static Role[] defaultSupplier;
    public boolean explicitDialog = false;
    public static String boundary;
    private static OSCIDataSource dataBuffer;
    ProcessCardBundle processCardForTimestampReception;
    private static SecretKey tempKey;
    public String prevChallenge;

    public DialogHandler(Originator client, Intermed supplier, TransportI transportModule) {
        this.supplier = supplier;
        if (supplier == null && defaultSupplier != null) {
            this.supplier = defaultSupplier[0];
        }
        this.transportModule = transportModule;
        this.client = client;
    }

    public DialogHandler(Intermed client, Addressee supplier, TransportI transportModule) {
        this.supplier = supplier;
        if (supplier == null && defaultSupplier != null) {
            this.supplier = defaultSupplier[0];
        }
        this.transportModule = transportModule;
        this.client = client;
    }

    public static SecretKey getTempSymKey() throws NoSuchAlgorithmException {
        if (tempKey == null) {
            tempKey = Crypto.createSymKey("http://www.w3.org/2009/xmlenc11#aes256-gcm");
        }
        return tempKey;
    }

    public boolean isCheckSignatures() {
        return this.checkSignatures;
    }

    public void setCheckSignatures(boolean check) {
        this.checkSignatures = check;
    }

    public boolean isCreateSignatures() {
        return this.createSignatures;
    }

    public void setCreateSignatures(boolean sign) {
        this.createSignatures = sign;
    }

    public boolean isSendFeatureDescription() {
        if ("false".equals(System.getProperty("de.osci.SendFeatureDescription"))) {
            return false;
        }
        if ("true".equals(System.getProperty("de.osci.SendFeatureDescription"))) {
            return true;
        }
        return this.sendFeatureDescription;
    }

    public void setSendFeatureDescription(boolean sendFeatureDescription) {
        this.sendFeatureDescription = sendFeatureDescription;
    }

    public void checkControlBlock(ControlBlockH cb) throws SoapClientException {
        if (this.disableControlBlockCheck) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\nRSP: " + this.controlblock.getResponse() + " : " + cb.getResponse());
        }
        if (log.isDebugEnabled()) {
            log.debug("\nCHALL: " + this.controlblock.getChallenge() + " : " + cb.getChallenge());
        }
        if (log.isDebugEnabled()) {
            log.debug("\nConvID: " + this.controlblock.getConversationID() + " : " + cb.getConversationID());
        }
        if (log.isDebugEnabled()) {
            log.debug("\nSQU: " + this.controlblock.getSequenceNumber() + " : " + cb.getSequenceNumber());
        }
        if (this.controlblock.getChallenge() != null && !cb.getResponse().equals(this.controlblock.getChallenge())) {
            throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
        }
        this.prevChallenge = cb.getChallenge();
        if (this.controlblock.getConversationID() != null) {
            if (!this.controlblock.getConversationID().equals(cb.getConversationID())) {
                throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
            }
        } else {
            this.controlblock.setConversationID(cb.getConversationID());
        }
        if (cb.getSequenceNumber() > -1 && cb.getSequenceNumber() != this.controlblock.getSequenceNumber()) {
            throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
        }
        this.controlblock.setSequenceNumber(cb.getSequenceNumber());
        this.controlblock.setChallenge(cb.getChallenge());
        this.controlblock.setResponse(cb.getResponse());
    }

    public static DialogHandler findDialog(ControlBlockH controlBlock) throws SoapClientException {
        DialogHandler dh = null;
        if (dialogFinder != null) {
            dh = dialogFinder.findDialog(controlBlock);
        }
        if (dh == null) {
            throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
        }
        return dh;
    }

    public TransportI getTransportModule() {
        return this.transportModule;
    }

    public boolean isEncryption() {
        return this.encryption;
    }

    public void setEncryption(boolean doEncryption) {
        this.encryption = doEncryption;
    }

    public ControlBlockH getControlblock() {
        return this.controlblock;
    }

    public ProgressEventHandlerI getProgressEventHandler() {
        return this.progressEventHandler;
    }

    public void setProgressEventHandler(ProgressEventHandlerI progressEventHandler) {
        this.progressEventHandler = progressEventHandler;
    }

    public void resetControlBlock() {
        this.controlblock = new ControlBlockH();
    }

    public Role getClient() {
        return this.client;
    }

    public Role getSupplier() {
        return this.supplier;
    }

    public String getLanguageList() {
        return this.languageList;
    }

    public void setLanguageList(String languageList) {
        this.languageList = languageList;
    }

    public static String getSecureRandomAlgorithm() {
        return secureRandomAlgorithm;
    }

    public static void setSecureRandomAlgorithm(String algorithm) {
        secureRandomAlgorithm = algorithm;
    }

    public static String getSignatureAlgorithm() {
        return signatureAlgorithm;
    }

    public static void setSignatureAlgorithm(String newSignatureAlgorithm) {
        if (Constants.JCA_JCE_MAP.get(newSignatureAlgorithm) == null) {
            throw new IllegalArgumentException(text.getString("invalid_signature_algorithm") + " " + newSignatureAlgorithm);
        }
        if (newSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            log.info("Using SHA-1 with RSA as default signature algorithm for signing OSCI messages.");
        }
        signatureAlgorithm = newSignatureAlgorithm;
    }

    public static void setDataBuffer(OSCIDataSource buffer) {
        dataBuffer = buffer;
    }

    public static synchronized OSCIDataSource getNewDataBuffer() throws IOException {
        return dataBuffer.newInstance();
    }

    public static void setSecurityProvider(Provider provider) {
        securityProvider = provider;
    }

    public static Provider getSecurityProvider() {
        return securityProvider;
    }

    public static void setDefaultSupplier(Addressee supplier) {
        defaultSupplier = new Role[1];
        DialogHandler.defaultSupplier[0] = supplier;
    }

    public static Addressee getDefaultSupplier() {
        if (defaultSupplier == null) {
            throw new IllegalStateException("No default supplier configured.");
        }
        return (Addressee)defaultSupplier[0];
    }

    public static void setDefaultSuppliers(Addressee[] supplier) {
        defaultSupplier = supplier;
    }

    public static Role[] getDefaultSuppliers() {
        return defaultSupplier;
    }

    public String getSymmetricCipherAlgorithm() {
        return this.symmetricCipherAlgorithm;
    }

    public void setSymmetricCipherAlgorithm(String symmetricCipherAlgorithm) {
        this.symmetricCipherAlgorithm = symmetricCipherAlgorithm;
    }

    public int getIvLength() {
        return this.ivLength;
    }

    public void setIvLength(int ivLength) {
        this.ivLength = ivLength;
    }

    public static String getDigestAlgorithm() {
        return digestAlgorithm;
    }

    public static void setDigestAlgorithm(String newDigestAlgorithm) {
        if (Constants.JCA_JCE_MAP.get(newDigestAlgorithm) == null) {
            throw new IllegalArgumentException(text.getString("invalid_hash_algorithm") + " " + newDigestAlgorithm);
        }
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(newDigestAlgorithm)) {
            log.info("Using SHA-1 as default digest algorithm for signing OSCI messages.");
        }
        digestAlgorithm = newDigestAlgorithm;
    }

    public String getAsymmetricCipherAlgorithm() {
        return this.asymmetricCipherAlgorithm;
    }

    public void setAsymmetricCipherAlgorithm(String newAsymmetricCipherAlgorithm) {
        if (newAsymmetricCipherAlgorithm == null || !newAsymmetricCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") && !newAsymmetricCipherAlgorithm.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
            throw new IllegalArgumentException(text.getString("encryption_algorithm_not_supported") + " " + newAsymmetricCipherAlgorithm);
        }
        this.asymmetricCipherAlgorithm = newAsymmetricCipherAlgorithm;
    }

    public void fireEvent(int type) {
        if (this.progressEventHandler != null) {
            this.progressEventHandler.event(type, text.getString("event_" + type), -1);
        }
    }

    public boolean isExplicitDialog() {
        return this.explicitDialog;
    }

    static {
        text = ResourceBundle.getBundle("de.osci.osci12.extinterfaces.language.Text", Locale.getDefault());
        try {
            securityProvider = (Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
            Security.addProvider(securityProvider);
        }
        catch (Exception ex) {
            log.info(text.getString("no_secprov") + " org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
        secureRandomAlgorithm = "SHA1PRNG";
        signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        boundary = "MIME_boundary";
        dataBuffer = new SwapBuffer();
    }
}

