/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.common;

import de.osci.helper.SymCipherInputStream;
import de.osci.helper.SymCipherOutputStream;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.extinterfaces.OSCIDataSourceExt123;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwapBuffer
extends OSCIDataSourceExt123 {
    private static Logger log = LoggerFactory.getLogger(SwapBuffer.class);
    private InputStream is;
    private OutputStream os = new ByteArrayOutputStream();
    private SwapBufferInputStream dbis;
    private SwapBufferOutputStream dbos = new SwapBufferOutputStream();
    private byte[] buffer;
    private File file;
    private static SecretKey tempKey;
    private static final String SYM_CIPHER_ALGO = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    public static long maxBufferSize;
    private static File tmpDir;
    private long byteCount = 0L;

    public SwapBuffer() {
        maxBufferSize = Runtime.getRuntime().freeMemory() / 100L;
    }

    public static void setTmpDir(String dir) {
        tmpDir = new File(dir);
    }

    @Override
    public OSCIDataSource newInstance() throws IOException {
        return new SwapBuffer();
    }

    private void resetInputStream() throws IOException {
        if (this.dbos != null) {
            this.dbos.close();
            this.dbos = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (NegativeArraySizeException ex) {
                log.warn("Problem beim Schlie\u00dfen des InputStreams, trotzdem weiter machen");
                log.debug("Fehlermeldung: " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.is = null;
        this.byteCount = 0L;
        if (this.buffer != null) {
            this.is = new ByteArrayInputStream(this.buffer);
        } else if (this.confidential) {
            try {
                this.is = new SymCipherInputStream(new FileInputStream(this.file), SwapBuffer.getTempSymKey(), SYM_CIPHER_ALGO, false);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        } else {
            this.is = new FileInputStream(this.file);
        }
        this.dbis = new SwapBufferInputStream();
    }

    protected void finalize() throws Throwable {
        try {
            this.deleteTempFile();
        }
        catch (IOException e) {
            log.error("Failed to delete tmp-file, set log level to INFO to see reason");
            log.info("Reason was:", (Throwable)e);
        }
        super.finalize();
    }

    protected void deleteTempFile() throws IOException {
        if (this.file != null) {
            Files.delete(this.file.toPath());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.resetInputStream();
        }
        return this.dbis;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            log.error("SwapBuffer ist bereits im Lesemodus, kein OutputStream verf\u00fcgbar.");
            throw new IllegalStateException();
        }
        return this.dbos;
    }

    @Override
    public long getLength() {
        return this.byteCount;
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String getVendor() {
        return "BOS";
    }

    private static SecretKey getTempSymKey() throws NoSuchAlgorithmException {
        if (tempKey == null) {
            tempKey = Crypto.createSymKey(SYM_CIPHER_ALGO);
        }
        return tempKey;
    }

    static {
        maxBufferSize = Runtime.getRuntime().freeMemory() / 100L;
        tmpDir = new File(System.getProperty("java.io.tmpdir"));
    }

    class SwapBufferOutputStream
    extends OutputStream {
        private FileOutputStream fos;

        SwapBufferOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (SwapBuffer.this.is != null) {
                log.error("DataBuffer ist bereits im Lesemodus, kann nicht beschrieben werden.");
                throw new IllegalStateException();
            }
            if (SwapBuffer.this.os instanceof ByteArrayOutputStream && SwapBuffer.this.byteCount + (long)len > maxBufferSize) {
                if (log.isDebugEnabled()) {
                    log.debug("SWAPPE AUF PLATTE");
                }
                String time = Long.toString(System.currentTimeMillis());
                time = time.substring(time.length() - 4);
                SwapBuffer.this.file = this.createTempFile(time, null, tmpDir);
                SwapBuffer.this.file.deleteOnExit();
                this.flush();
                SwapBuffer.this.buffer = ((ByteArrayOutputStream)SwapBuffer.this.os).toByteArray();
                if (SwapBuffer.this.confidential) {
                    try {
                        this.fos = new FileOutputStream(SwapBuffer.this.file);
                        SwapBuffer.this.os = new SymCipherOutputStream(this.fos, SwapBuffer.getTempSymKey(), SwapBuffer.SYM_CIPHER_ALGO, true);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        log.warn("Verwendeter security provider unterst\u00fctzt nicht den erforderlichen Algoritmus, Daten werden unverschl\u00fcsselt gespeichert !\n" + nsae.getMessage(), (Throwable)nsae);
                        SwapBuffer.this.confidential = false;
                        SwapBuffer.this.os = new FileOutputStream(SwapBuffer.this.file);
                    }
                } else {
                    SwapBuffer.this.os = new FileOutputStream(SwapBuffer.this.file);
                }
                SwapBuffer.this.os.write(SwapBuffer.this.buffer);
                SwapBuffer.this.buffer = null;
            }
            SwapBuffer.this.os.write(b, off, len);
            SwapBuffer.this.byteCount += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void flush() throws IOException {
            SwapBuffer.this.os.flush();
        }

        @Override
        public void close() throws IOException {
            if (SwapBuffer.this.os == null) {
                return;
            }
            SwapBuffer.this.os.flush();
            SwapBuffer.this.os.close();
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
            if (SwapBuffer.this.os instanceof ByteArrayOutputStream) {
                SwapBuffer.this.buffer = ((ByteArrayOutputStream)SwapBuffer.this.os).toByteArray();
            }
            SwapBuffer.this.os = null;
        }

        private File createTempFile(String prefix, String suffix, File tmpDir) throws IOException {
            try {
                return Files.createTempFile(tmpDir.toPath(), prefix, suffix, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                log.warn("Could not create temp file with Files.createTempFile, trying File.createTempFile instead", (Throwable)e);
                return File.createTempFile(prefix, suffix, tmpDir);
            }
        }
    }

    class SwapBufferInputStream
    extends InputStream {
        SwapBufferInputStream() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (SwapBuffer.this.os != null) {
                log.error("DataBuffer ist im Schreibmodus, kann nicht gelesen werden.");
                throw new IllegalStateException();
            }
            return SwapBuffer.this.is.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public void reset() throws IOException {
            SwapBuffer.this.resetInputStream();
        }

        @Override
        public void close() throws IOException {
            SwapBuffer.this.is.close();
        }

        @Override
        public int available() throws IOException {
            return SwapBuffer.this.is.available();
        }
    }
}

