/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherReference {
    private static Logger log = LoggerFactory.getLogger(CipherReference.class);
    private Vector<String> transformList = new Vector();
    private String uri;
    private OSCIDataSource swapBuffer = null;
    private boolean encryptedStream = false;

    public CipherReference(String uri) throws IOException {
        this.uri = uri;
        if (log.isDebugEnabled()) {
            log.debug("Konstruktor");
        }
        this.swapBuffer = DialogHandler.getNewDataBuffer();
    }

    public void setReferencedStream(InputStream refStream) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Der Referenced Stream wurde gesetzt.");
        }
        OutputStream out = this.swapBuffer.getOutputStream();
        byte[] bytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
        int anz = 0;
        while ((anz = refStream.read(bytes)) > -1) {
            out.write(bytes, 0, anz);
        }
    }

    public void addTransform(String transform) {
        this.transformList.add(transform);
    }

    public String getTransform(int i) {
        return this.transformList.get(i);
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public InputStream getReferencedStream() throws IOException {
        return this.swapBuffer.getInputStream();
    }

    public void writeXML(OutputStream out, String ds, String xenc) throws IOException {
        out.write(("<" + xenc + ":CipherReference URI=\"" + this.getURI() + "\">").getBytes(Constants.CHARSET_ENCODING));
        out.write(("<" + xenc + ":Transforms><" + ds + ":Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></" + ds + ":Transform></" + xenc + ":Transforms></" + xenc).getBytes(Constants.CHARSET_ENCODING));
        out.write(":CipherReference>".getBytes(Constants.CHARSET_ENCODING));
    }

    public boolean isEncryptedStream() {
        return this.encryptedStream;
    }

    public void setEncryptedStream(boolean encryptedStream) {
        this.encryptedStream = encryptedStream;
    }
}

