/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.helper.Base64InputStream;
import de.osci.helper.Base64OutputStream;
import de.osci.helper.SymCipherOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.MessagePartsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherValue {
    private static Logger log = LoggerFactory.getLogger(CipherValue.class);
    private OSCIDataSource swapBuffer = null;
    private ContentContainer coco = null;
    private SecretKey key = null;
    private byte[] iv;
    private String symAlgorithm;
    private int ivLength;

    public CipherValue(String data) throws IOException {
        this.swapBuffer = DialogHandler.getNewDataBuffer();
        if (log.isDebugEnabled()) {
            log.debug("Konstruktor String Data");
        }
        OutputStream out = this.swapBuffer.getOutputStream();
        out.write(data.getBytes(Constants.CHARSET_ENCODING));
        out.close();
    }

    public CipherValue(byte[] dataBytes) throws IOException {
        this.swapBuffer = DialogHandler.getNewDataBuffer();
        Base64OutputStream b64out = new Base64OutputStream(this.swapBuffer.getOutputStream(), false);
        b64out.write(dataBytes);
        b64out.close();
    }

    public CipherValue() throws IOException {
        this.swapBuffer = DialogHandler.getNewDataBuffer();
    }

    public CipherValue(ContentContainer contentContainer, SecretKey key, String symAlgorithm, int ivLength) {
        this.coco = contentContainer;
        this.key = key;
        this.symAlgorithm = symAlgorithm;
        this.ivLength = ivLength;
    }

    public CipherValue(ContentContainer contentContainer, SecretKey key, String symAlgorithm) {
        this(contentContainer, key, symAlgorithm, 12);
    }

    public OutputStreamWriter getStreamToWrite() throws IOException {
        return new OutputStreamWriter(this.swapBuffer.getOutputStream(), Constants.CHARSET_ENCODING);
    }

    public InputStream getCipherValueStream() throws IOException {
        this.swapBuffer.getInputStream().reset();
        return new Base64InputStream(this.swapBuffer.getInputStream());
    }

    public void writeXML(OutputStream out, String xenc) throws IOException, OSCIException {
        out.write(("<" + xenc + ":CipherValue>").getBytes(Constants.CHARSET_ENCODING));
        if (this.coco != null) {
            Base64OutputStream b64out = new Base64OutputStream(out, false);
            SymCipherOutputStream scos = new SymCipherOutputStream((OutputStream)b64out, this.key, this.symAlgorithm, this.ivLength, this.iv);
            this.iv = scos.getIv();
            MessagePartsFactory.writeXML(this.coco, scos);
            scos.close();
            b64out.flush(true);
        } else {
            int i;
            InputStream is = this.swapBuffer.getInputStream();
            is.reset();
            byte[] tmp = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            while ((i = is.read(tmp)) > -1) {
                out.write(tmp, 0, i);
            }
            is.close();
        }
        out.write(("</" + xenc + ":CipherValue>").getBytes(Constants.CHARSET_ENCODING));
        out.flush();
    }
}

