/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.OSCICipherException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto {
    private static final Logger LOG = LoggerFactory.getLogger(Crypto.class);
    private static String hex = "0123456789abcdef";

    public static boolean isWeak(Date date, X509Certificate x509Certificate) {
        int keySize = Crypto.getKeySize(x509Certificate);
        return Crypto.isWeak(date, x509Certificate.getPublicKey().getAlgorithm(), keySize);
    }

    public static boolean isWeak(Date date, String algorithm, int keySize) {
        if (date == null) {
            date = Constants.ACTUAL_DATE;
        }
        if (algorithm.equals("EC")) {
            if (keySize < 224) {
                LOG.info("Signature key (EC) has insufficient key size: " + keySize);
                return true;
            }
        } else {
            if (keySize < 1024) {
                LOG.info("Signature key (RSA) has insufficient key size: " + keySize);
                return true;
            }
            if (keySize < 2048 && !date.before(Constants.OUT_DATE_KEYSIZE_1024)) {
                LOG.info("Signature key (RSA) has insufficient key size: " + keySize);
                return true;
            }
            if (keySize > 2048) {
                LOG.info("Signature key (RSA) has sufficient key size (no out date defined yet): " + keySize);
                return false;
            }
        }
        return false;
    }

    public static SecretKey createSymKey(String algorithm) throws NoSuchAlgorithmException {
        String algo = Constants.JCA_JCE_MAP.get(algorithm);
        KeyGenerator keyGenerator = DialogHandler.getSecurityProvider() == null ? KeyGenerator.getInstance(algo.substring(0, algo.indexOf(47))) : KeyGenerator.getInstance(algo.substring(0, algo.indexOf(47)), DialogHandler.getSecurityProvider());
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            keyGenerator.init(128);
        } else if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            keyGenerator.init(192);
        } else if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            keyGenerator.init(256);
        } else if (algorithm.equals("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
            keyGenerator.init(128);
        } else if (algorithm.equals("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
            keyGenerator.init(192);
        } else if (algorithm.equals("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
            keyGenerator.init(256);
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey createSymKey(byte[] data, String algorithm) {
        String algo = Constants.JCA_JCE_MAP.get(algorithm);
        return new SecretKeySpec(data, algo.substring(0, algo.indexOf(47)));
    }

    public static String toHex(byte[] b) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int j = b[i] >> 4 & 0xF;
            s.append(hex.charAt(j));
            j = b[i] & 0xF;
            s.append(hex.charAt(j));
        }
        return s.toString();
    }

    public static byte[] doRSAEncryption(X509Certificate encryptionCert, Key key) throws OSCICipherException, NoSuchAlgorithmException {
        return Crypto.doRSAEncryption(encryptionCert, key, "http://www.w3.org/2009/xmlenc11#rsa-oaep");
    }

    public static byte[] doRSAEncryption(X509Certificate encryptionCert, Key key, String algorithm) throws OSCICipherException, NoSuchAlgorithmException {
        try {
            Cipher cipher = DialogHandler.getSecurityProvider() == null ? Cipher.getInstance(Constants.JCA_JCE_MAP.get(algorithm)) : Cipher.getInstance(Constants.JCA_JCE_MAP.get(algorithm), DialogHandler.getSecurityProvider());
            if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(algorithm)) {
                PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
                String digestAlgorithm = Constants.JCA_JCE_MAP.get("http://www.w3.org/2001/04/xmlenc#sha256");
                if (!"http://www.w3.org/2001/04/xmlenc#ripemd160".equals(DialogHandler.getDigestAlgorithm()) && !"http://www.w3.org/2000/09/xmldsig#sha1".equals(DialogHandler.getDigestAlgorithm())) {
                    digestAlgorithm = "http://www.w3.org/2007/05/xmldsig-more#sha3-256".equals(DialogHandler.getDigestAlgorithm()) ? Constants.JCA_JCE_MAP.get("http://www.w3.org/2001/04/xmlenc#sha256") : ("http://www.w3.org/2007/05/xmldsig-more#sha3-384".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-512".equals(DialogHandler.getDigestAlgorithm()) ? Constants.JCA_JCE_MAP.get("http://www.w3.org/2001/04/xmlenc#sha512") : Constants.JCA_JCE_MAP.get(DialogHandler.getDigestAlgorithm()));
                }
                MGF1ParameterSpec mgfParameterSpec = new MGF1ParameterSpec(digestAlgorithm);
                OAEPParameterSpec oaepParameters = new OAEPParameterSpec(digestAlgorithm, "MGF1", mgfParameterSpec, pSource);
                cipher.init(3, (Key)encryptionCert.getPublicKey(), oaepParameters);
            } else {
                cipher.init(3, encryptionCert);
            }
            return cipher.wrap(key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn("Error: ", (Throwable)ex);
            throw new OSCICipherException("encryption_error");
        }
    }

    public static byte[] doRSADecryption(Key key, byte[] data) throws OSCICipherException, NoSuchAlgorithmException {
        return Crypto.doRSADecryption(key, data, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", null, null, null);
    }

    public static byte[] doRSADecryption(Key key, byte[] data, String algorithm, String mgfAlgorithm, String digestAlgorithm, byte[] oaepParams) throws OSCICipherException, NoSuchAlgorithmException {
        try {
            Cipher cipher = DialogHandler.getSecurityProvider() == null ? Cipher.getInstance(Constants.JCA_JCE_MAP.get(algorithm)) : Cipher.getInstance(Constants.JCA_JCE_MAP.get(algorithm), DialogHandler.getSecurityProvider());
            if (algorithm.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
                MGF1ParameterSpec mgfParameterSpec;
                PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
                if (oaepParams != null) {
                    pSource = new PSource.PSpecified(oaepParams);
                }
                if (mgfAlgorithm.equals("http://www.w3.org/2009/xmlenc11#mgf1sha256")) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-256");
                } else if (mgfAlgorithm.equals("http://www.w3.org/2009/xmlenc11#mgf1sha384")) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-384");
                } else if (mgfAlgorithm.equals("http://www.w3.org/2009/xmlenc11#mgf1sha512")) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-512");
                } else {
                    throw new IllegalArgumentException("Unsupported mask generation function " + mgfAlgorithm);
                }
                OAEPParameterSpec oaepParameters = new OAEPParameterSpec(Constants.JCA_JCE_MAP.get(digestAlgorithm), "MGF1", mgfParameterSpec, pSource);
                cipher.init(2, key, oaepParameters);
            } else {
                cipher.init(2, key);
            }
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn("Error: ", (Throwable)ex);
            throw new OSCICipherException("decryption_error");
        }
    }

    @Deprecated(since="1.8")
    public static String getCipherAlgoID(SecretKey sk) {
        String algo = null;
        if (sk.getAlgorithm().equals("DESede")) {
            algo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        } else if (sk.getAlgorithm().equals("AES")) {
            if (sk.getEncoded().length * 8 == 128) {
                algo = "http://www.w3.org/2009/xmlenc11#aes128-gcm";
            } else if (sk.getEncoded().length * 8 == 192) {
                algo = "http://www.w3.org/2009/xmlenc11#aes192-gcm";
            } else if (sk.getEncoded().length * 8 == 256) {
                algo = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
            }
        }
        return algo;
    }

    public static long calcSymEncLength(long len, String algorithm) {
        return Crypto.calcSymEncLength(len, algorithm, 12);
    }

    public static long calcSymEncLength(long len, String algorithm, int ivLength) {
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 16L + len / 8L * 8L;
        }
        if (algorithm.endsWith("cbc")) {
            return 32L + len / 16L * 16L;
        }
        if (algorithm.endsWith("-gcm") && ivLength == 12) {
            return 28L + len;
        }
        return 32L + len;
    }

    public static int getKeySize(X509Certificate cert) {
        if (cert.getPublicKey().getAlgorithm().equals("EC")) {
            return ((ECPublicKey)cert.getPublicKey()).getParams().getOrder().bitLength();
        }
        return ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength();
    }

    public static String getDigestMethodForOAEP(X509Certificate encryptionCert, String symmetricCipherAlgo) {
        String digAlgo;
        int keyLength;
        int dataLen = 24;
        if (symmetricCipherAlgo.contains("aes")) {
            dataLen = Integer.parseInt(symmetricCipherAlgo.substring(symmetricCipherAlgo.indexOf("#aes") + 4, symmetricCipherAlgo.indexOf("-cbc")));
        }
        if ((keyLength = ((RSAPublicKey)encryptionCert.getPublicKey()).getModulus().bitLength()) < dataLen + 2 + 2 * Integer.parseInt((digAlgo = DialogHandler.getDigestAlgorithm()).substring(digAlgo.indexOf("#sha") + 4))) {
            digAlgo = "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        return digAlgo;
    }
}

