/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.CipherData;
import de.osci.osci12.encryption.CipherReference;
import de.osci.osci12.encryption.CipherValue;
import de.osci.osci12.encryption.EncryptedData;
import de.osci.osci12.signature.KeyInfoBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EncryptedDataBuilder
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(EncryptedDataBuilder.class);
    DefaultHandler parentHandler;
    private Vector<String> transformer = new Vector();
    XMLReader xmlReader;
    private EncryptedData encrytedDataObject;
    private String edId = "";
    private String cipherRefId = "";
    private OutputStreamWriter valueWriter;
    private CipherValue cv;
    protected static final String DS_XMLNS = Constants.Namespaces.XML_SIG.getUri();
    protected static final String XENC_XMLNS = Constants.Namespaces.XML_ENC.getUri();

    public EncryptedDataBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes attributes) {
        this.xmlReader = xmlReader;
        this.parentHandler = parentHandler;
        this.encrytedDataObject = new EncryptedData("");
        if (attributes != null && attributes.getValue("Id") != null) {
            this.encrytedDataObject.setId(attributes.getValue("Id"));
        }
    }

    public EncryptedDataBuilder(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
        this.encrytedDataObject = new EncryptedData("");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block14: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Start-Element: " + localName);
                }
                if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
                    if (log.isDebugEnabled()) {
                        log.debug("encryptedData");
                    }
                    if (this.encrytedDataObject == null) {
                        this.encrytedDataObject = new EncryptedData(this.edId);
                    }
                    if (attributes.getValue("Id") != null) {
                        this.encrytedDataObject.setId(attributes.getValue("Id"));
                    }
                    break block14;
                }
                if (localName.equals("EncryptionMethod") && uri.equals(XENC_XMLNS)) {
                    this.encrytedDataObject.setEncryptionMethodAlgorithm(attributes.getValue("Algorithm"));
                    break block14;
                }
                if (localName.equals("IvLength") && uri.equals(Constants.Namespaces.OSCI128.getUri())) {
                    this.encrytedDataObject.setIvLength(Integer.valueOf(attributes.getValue("Value")));
                    this.encrytedDataObject.setIvLengthParsed(true);
                    break block14;
                }
                if (localName.equals("KeyInfo") && uri.equals(DS_XMLNS)) {
                    KeyInfoBuilder childBuilder = new KeyInfoBuilder(this.xmlReader, this, attributes);
                    this.xmlReader.setContentHandler(childBuilder);
                    break block14;
                }
                if (localName.equals("CipherData") && uri.equals(XENC_XMLNS)) break block14;
                if (localName.equals("CipherReference") && uri.equals(XENC_XMLNS)) {
                    this.cipherRefId = attributes.getValue("URI");
                    break block14;
                }
                if (localName.equals("Transforms") && uri.equals(XENC_XMLNS)) break block14;
                if (localName.equals("Transform") && uri.equals(DS_XMLNS)) {
                    this.transformer.add(attributes.getValue("Algorithm"));
                    break block14;
                }
                if (localName.equals("CipherValue") && uri.equals(XENC_XMLNS)) {
                    this.cv = new CipherValue();
                    this.valueWriter = this.cv.getStreamToWrite();
                    break block14;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex1) {
                log.error("Allgemeiner Fehler im Start-Element: " + localName);
                throw new SAXException(ex1);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.valueWriter == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ' || Character.isDigit(ch[start + i])) continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            try {
                this.valueWriter.write(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Ende-Element: " + localName);
        }
        if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
            if (this.parentHandler != null) {
                this.xmlReader.setContentHandler(this.parentHandler);
                this.parentHandler.endElement(uri, localName, qName);
            }
        } else if (!(localName.equals("EncryptionMethod") && uri.equals(XENC_XMLNS) || localName.equals("CipherData") && uri.equals(XENC_XMLNS) || localName.equals("EncryptedKey") && uri.equals(XENC_XMLNS))) {
            if (localName.equals("CipherReference") && uri.equals(XENC_XMLNS)) {
                try {
                    CipherReference cr = new CipherReference(this.cipherRefId);
                    Enumeration<String> transformers = this.transformer.elements();
                    while (transformers.hasMoreElements()) {
                        cr.addTransform(transformers.nextElement());
                    }
                    this.encrytedDataObject.setCipherData(new CipherData(cr));
                }
                catch (Exception ex1) {
                    log.error("Fehler beim setzen der CipherReference.", (Throwable)ex1);
                    throw new SAXException(ex1);
                }
            }
            if (!(localName.equals("Transforms") && uri.equals(XENC_XMLNS) || localName.equals("Transform") && uri.equals(DS_XMLNS))) {
                if (localName.equals("CipherValue") && uri.equals(XENC_XMLNS)) {
                    try {
                        this.valueWriter.close();
                    }
                    catch (IOException ex) {
                        throw new SAXException(ex);
                    }
                    this.encrytedDataObject.setCipherData(new CipherData(this.cv));
                } else if (localName.equals("IvLength") && uri.equals(Constants.Namespaces.OSCI128.getUri())) {
                    log.trace("IV-Length-Element gefunden");
                } else {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
            }
        }
        if (!this.encrytedDataObject.isIvLengthParsed()) {
            this.encrytedDataObject.setIvLength(16);
        }
        this.valueWriter = null;
    }

    public EncryptedData getEncryptedData() {
        return this.encrytedDataObject;
    }

    public static EncryptedData createFromXmlBytes(byte[] xmlBytes) throws SAXException {
        try {
            SAXParser parser = ParserHelper.getNewSAXParser();
            ParserHelper.setFeatures(parser.getXMLReader());
            EncryptedDataBuilder encBuilder = new EncryptedDataBuilder(parser.getXMLReader());
            parser.parse(new InputSource(new ByteArrayInputStream(xmlBytes)), (DefaultHandler)encBuilder);
            return encBuilder.getEncryptedData();
        }
        catch (IOException | ParserConfigurationException ex) {
            log.error("Allgemeiner Fehler beim Parsen des eingelesenen EncryptedData-Elements");
            throw new SAXException(ex);
        }
    }
}

