/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePart;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChunkInformation
extends MessagePart
implements Serializable {
    private static final long serialVersionUID = -4517673667797670551L;
    private int chunkNumber = 0;
    private long totalMessageSize = 0L;
    private long chunkSize = 0L;
    private CheckInstance checkInstance;
    private List<Integer> receivedChunks = new ArrayList<Integer>();
    private int totalChunkNumbers = 0;

    ChunkInformation(CheckInstance checkInstance) {
        this.setCheckInstance(checkInstance);
    }

    public ChunkInformation(long chunkSize, int chunkNumber, long totalMessageSize, int totalChunkNumbers) {
        this.setCheckInstance(CheckInstance.PartialStoreDelivery);
        this.setTotalMessageSize(totalMessageSize);
        this.setTotalChunkNumbers(totalChunkNumbers);
        this.setChunkSize(chunkSize);
        this.setChunkNumber(chunkNumber);
    }

    public ChunkInformation(long chunkSize, int chunkNumber, List<Integer> receivedChunks) {
        this.setCheckInstance(CheckInstance.PartialFetchDelivery);
        this.setChunkSize(chunkSize);
        this.setChunkNumber(chunkNumber);
        if (receivedChunks == null || receivedChunks.isEmpty()) {
            this.setReceivedChunks(new Integer[]{-1});
        } else {
            this.setReceivedChunks(receivedChunks);
        }
    }

    public ChunkInformation(long chunkSize, int chunkNumber, Integer ... receivedChunks) {
        this.setCheckInstance(CheckInstance.PartialFetchDelivery);
        this.setChunkSize(chunkSize);
        this.setChunkNumber(chunkNumber);
        if (receivedChunks == null || receivedChunks.length == 0) {
            this.setReceivedChunks(new Integer[]{-1});
        } else {
            this.setReceivedChunks(Arrays.asList(receivedChunks));
        }
    }

    public CheckInstance getCheckInstance() {
        return this.checkInstance;
    }

    public void setCheckInstance(CheckInstance checkInstance) {
        if (checkInstance == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " checkInstance");
        }
        this.checkInstance = checkInstance;
    }

    public int getTotalChunkNumbers() {
        return this.totalChunkNumbers;
    }

    public void setTotalChunkNumbers(int totalChunkNumbers) {
        if (!this.checkInstance.totalChunkNumberCheck) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " totalChunkNumbers");
        }
        this.totalChunkNumbers = totalChunkNumbers;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public void setChunkNumber(int chunkNumber) {
        if (!this.checkInstance.chunkNumberCheck) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " chunkNumber");
        }
        this.chunkNumber = chunkNumber;
    }

    public long getTotalMessageSize() {
        return this.totalMessageSize;
    }

    public void setTotalMessageSize(long totalMessageSize) {
        this.totalMessageSize = totalMessageSize;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(long chunkSize) {
        if (!this.checkInstance.chunkSizeCheck) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " chunkSize");
        }
        this.chunkSize = chunkSize;
    }

    public List<Integer> getReceivedChunks() {
        return this.receivedChunks;
    }

    public void setReceivedChunks(List<Integer> receivedChunks) {
        if (!this.checkInstance.receivedChunksCheck) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " receivedChunks");
        }
        this.receivedChunks = receivedChunks;
    }

    public void setReceivedChunks(Integer[] receivedChunks) {
        this.setReceivedChunks(Arrays.asList(receivedChunks));
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException, OSCIException {
        out.write(("<" + this.osci2017NSPrefix + ":ChunkInformation").getBytes(Constants.CHARSET_ENCODING));
        if (this.getChunkNumber() != 0) {
            out.write((" ChunkNumber=\"" + this.getChunkNumber() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.getChunkSize() != 0L) {
            out.write((" ChunkSize=\"" + this.getChunkSize() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.getReceivedChunks() != null && !this.getReceivedChunks().isEmpty()) {
            String reciverChunksString = " ReceivedChunks=\"";
            for (int chunkNumberRec : this.getReceivedChunks()) {
                reciverChunksString = reciverChunksString.concat(Integer.toString(chunkNumberRec) + " ");
            }
            reciverChunksString = reciverChunksString.substring(0, reciverChunksString.length() - 1);
            reciverChunksString = reciverChunksString.concat("\"");
            out.write(reciverChunksString.getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.getTotalChunkNumbers() != 0) {
            out.write((" TotalChunkNumbers=\"" + this.getTotalChunkNumbers() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.getTotalMessageSize() != 0L) {
            out.write((" TotalMessageSize=\"" + this.getTotalMessageSize() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("></" + this.osci2017NSPrefix + ":ChunkInformation>").getBytes(Constants.CHARSET_ENCODING));
    }

    public static enum CheckInstance {
        PartialStoreDelivery(true, true, true, false, true),
        ResponsePartialStoreDelivery(false, true, false, true, true),
        PartialFetchDelivery(true, true, false, true, false),
        ResponsePartialFetchDelivery(false, true, true, false, true);

        private boolean chunkSizeCheck;
        private boolean chunkNumberCheck;
        private boolean totalMessageSizeCheck;
        private boolean receivedChunksCheck;
        private boolean totalChunkNumberCheck;

        private CheckInstance(boolean chunkSizeCheck, boolean chunkNumberCheck, boolean totalMessageSizeCheck, boolean receivedChunksCheck, boolean totalChunkNumberCheck) {
            this.chunkSizeCheck = chunkSizeCheck;
            this.chunkNumberCheck = chunkNumberCheck;
            this.totalMessageSizeCheck = totalMessageSizeCheck;
            this.receivedChunksCheck = receivedChunksCheck;
            this.totalChunkNumberCheck = totalChunkNumberCheck;
        }

        public boolean isChunkSizeCheck() {
            return this.chunkSizeCheck;
        }

        public boolean isChunkNumberCheck() {
            return this.chunkNumberCheck;
        }

        public boolean isTotalMessageSizeCheck() {
            return this.totalMessageSizeCheck;
        }

        public boolean isReceivedChunksCheck() {
            return this.receivedChunksCheck;
        }

        public boolean isTotalChunkNumberCheck() {
            return this.totalChunkNumberCheck;
        }
    }
}

