/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.ParserHelper;
import de.osci.helper.SymCipherOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messageparts.OSCISignatureReference;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Role;
import de.osci.osci12.signature.OSCISignatureException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentContainer
extends MessagePart
implements Serializable {
    private static final long serialVersionUID = 4443521943513857170L;
    private static Logger log = LoggerFactory.getLogger(ContentContainer.class);
    static boolean STATE_OF_OBJECT_CONSTRUCTION = true;
    static boolean STATE_OF_OBJECT_PARSING = false;
    boolean stateOfObject = STATE_OF_OBJECT_CONSTRUCTION;
    protected static final int INNER_CONTAINER = 1;
    protected static final int SIGNED_CONTAINER = 2;
    protected static final int ENCRYPTED_CONTAINER = 3;
    private static int idNr = -1;
    int signedSigPropNr = 0;
    Vector<OSCISignature> signerList = new Vector();
    Vector<Role> roles = new Vector();
    Hashtable<String, Attachment> attachments = new Hashtable();
    private Vector<Content> contentList = new Vector();
    private Vector<EncryptedDataOSCI> encryptedDataList = new Vector();

    public ContentContainer() {
        this.id = this.typ + ++idNr;
    }

    public boolean checkSignature(Role signatureRole) throws OSCISignatureException, OSCIRoleException {
        boolean check;
        if (log.isDebugEnabled()) {
            log.debug("(start) checkSignature (...) ");
        }
        if (check = this.checkContainsSigner(signatureRole)) {
            try {
                OSCISignature[] signatures = this.findSignatureObjects(signatureRole);
                for (int j = 0; j < signatures.length; ++j) {
                    int i;
                    if (log.isDebugEnabled()) {
                        log.debug("Signature Objekt: " + signatures[j]);
                    }
                    if (signatures[j].getDigestMethods().containsValue("http://www.w3.org/2000/09/xmldsig#sha1")) {
                        log.info("SHA-1 used as digest algorithm for content signature.");
                    }
                    if (signatures[j].signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                        log.info("SHA-1 with RSA used as signature algorithm for content signature.");
                    }
                    Hashtable<CallSite, MessagePart> newHashes = new Hashtable<CallSite, MessagePart>();
                    for (i = 0; i < this.contentList.size(); ++i) {
                        Content co = this.contentList.get(i);
                        newHashes.put((CallSite)((Object)("#" + co.getRefID())), co);
                    }
                    for (i = 0; i < this.encryptedDataList.size(); ++i) {
                        EncryptedDataOSCI encData = this.encryptedDataList.get(i);
                        newHashes.put((CallSite)((Object)("#" + encData.getRefID())), encData);
                    }
                    Enumeration<Attachment> e = this.attachments.elements();
                    while (e.hasMoreElements()) {
                        Attachment att = e.nextElement();
                        newHashes.put((CallSite)((Object)("cid:" + att.getRefID())), att);
                    }
                    Map<String, OSCISignatureReference> sigRefs = signatures[j].getReferences();
                    if (log.isDebugEnabled()) {
                        for (String refId : sigRefs.keySet()) {
                            log.debug("Reference: " + refId);
                        }
                        log.debug("Anzahl contents und encData: " + newHashes.size() + " OSCISIGReferenzen: " + sigRefs.size());
                    }
                    Vector<String> checked = new Vector<String>();
                    int sigRefCount = sigRefs.size();
                    if (signatures[j].signingTime != null) {
                        --sigRefCount;
                        log.info("Add signing time to count list");
                    }
                    if (sigRefCount != newHashes.size()) {
                        log.error("The number of references and hashed parts are not equal");
                        return false;
                    }
                    for (OSCISignatureReference signatureRef : sigRefs.values()) {
                        byte[] newDigest;
                        String id = signatureRef.getRefID();
                        if (log.isDebugEnabled()) {
                            log.debug("ID die kontrolliert wird: " + id + ":" + signatures[j].signingPropsId);
                        }
                        if (id.equals("#" + signatures[j].signingPropsId)) {
                            MessageDigest mdg = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(signatureRef.getDigestMethodAlgorithm())) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(signatureRef.getDigestMethodAlgorithm()), DialogHandler.getSecurityProvider());
                            newDigest = mdg.digest(signatures[j].signingProperties.getBytes(Constants.CHARSET_ENCODING));
                        } else {
                            MessagePart mp = (MessagePart)newHashes.get(id);
                            newDigest = mp.getDigestValue(signatureRef.getDigestMethodAlgorithm());
                        }
                        byte[] digest = signatureRef.digestValue;
                        if (newDigest == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Der aktuelle Digest f\u00fcr die RefID: " + id + " konnte nicht gefunden werden");
                            }
                            return false;
                        }
                        if (!MessageDigest.isEqual(digest, newDigest)) {
                            log.error("Der Digest f\u00fcr die RefID: " + id + " ist falsch!");
                            return false;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Der Digest ist richtig.");
                        }
                        checked.add(id);
                    }
                    Enumeration en = newHashes.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        if (checked.contains(key)) continue;
                        log.error("Unsigniertes Containerelement gefunden: " + this.id);
                        return false;
                    }
                    X509Certificate c = signatureRole.getSignatureCertificate();
                    if (c.getKeyUsage() != null && !c.getKeyUsage()[0] && !c.getKeyUsage()[1]) {
                        log.error("Signature certificate has wrong key usage.");
                        return false;
                    }
                    Signature sg = DialogHandler.getSecurityProvider() == null ? Signature.getInstance(Constants.JCA_JCE_MAP.get(signatures[j].signatureAlgorithm)) : Signature.getInstance(Constants.JCA_JCE_MAP.get(signatures[j].signatureAlgorithm), DialogHandler.getSecurityProvider());
                    sg.initVerify(c.getPublicKey());
                    sg.update(signatures[j].getSignedInfoBytes());
                    if (!sg.verify(signatures[j].signatureValue)) {
                        log.error("Signatur falsch !" + new String(signatures[j].getSignedInfoBytes()));
                        return false;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Die Signaturpr\u00fcfung wurde erfolgreich abgeschlossen.");
                }
            }
            catch (IllegalStateException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
                throw new OSCISignatureException("signature_check_error");
            }
        } else {
            log.warn("Content-Signatur konnte nicht \u00fcberpr\u00fcft werden (Falsches Role Objekt).");
            throw new OSCIRoleException("no_signature_for_role");
        }
        if (log.isDebugEnabled()) {
            log.debug("(ende) findSignatureObject");
        }
        return true;
    }

    public OSCISignature[] getSignatures() {
        return this.signerList.toArray(new OSCISignature[this.signerList.size()]);
    }

    private OSCISignature[] findSignatureObjects(Role roleToCheck) throws OSCIRoleException {
        if (log.isDebugEnabled()) {
            log.debug("(start) findSignatureObject (...) ");
        }
        Enumeration<OSCISignature> e = this.signerList.elements();
        Vector<OSCISignature> sigs = new Vector<OSCISignature>();
        if (log.isDebugEnabled()) {
            log.debug("Anzahl SignerList: " + this.signerList.size());
        }
        while (e.hasMoreElements()) {
            OSCISignature signature = e.nextElement();
            if (!signature.signer.getSignatureCertificate().equals(roleToCheck.getSignatureCertificate())) continue;
            sigs.add(signature);
        }
        return sigs.toArray(new OSCISignature[0]);
    }

    void addSignature(OSCISignature signature) {
        this.signerList.add(signature);
        this.roles.add(signature.signer);
    }

    private boolean checkContainsSigner(Role roleToCheck) throws OSCIRoleException {
        if (log.isDebugEnabled()) {
            log.debug("(start) checkContainsRole (...) ");
        }
        Role[] signer = this.getSigners();
        for (int i = 0; i < signer.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Role Object: " + signer[i].id);
            }
            if (!signer[i].getSignatureCertificate().equals(roleToCheck.getSignatureCertificate())) continue;
            return true;
        }
        return false;
    }

    public boolean hasWeakSignature(Role signer, Date date) throws OSCIRoleException {
        if (!this.checkContainsSigner(signer)) {
            throw new IllegalStateException("Message is not signed by given role object " + signer.id + ".");
        }
        OSCISignature[] signatures = this.findSignatureObjects(signer);
        if (date == null) {
            date = Constants.ACTUAL_DATE;
        }
        if (Crypto.isWeak(date, signer.getSignatureCertificate())) {
            return true;
        }
        for (int j = 0; j < signatures.length; ++j) {
            if (Constants.OUT_DATES.containsKey(signatures[j].signatureAlgorithm) && !date.before(Constants.OUT_DATES.get(signatures[j].signatureAlgorithm))) {
                return true;
            }
            String[] digMeths = signatures[j].getDigestMethods().values().toArray(new String[0]);
            for (int i = 0; i < digMeths.length; ++i) {
                if (!Constants.OUT_DATES.containsKey(digMeths[i]) || date.before(Constants.OUT_DATES.get(digMeths[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkAllSignatures() throws OSCIRoleException, OSCISignatureException {
        Role[] signer = this.getSigners();
        if (signer.length == 0) {
            throw new OSCISignatureException("no_signature");
        }
        for (int i = 0; i < signer.length; ++i) {
            if (this.checkSignature(signer[i])) continue;
            return false;
        }
        return true;
    }

    public Attachment[] getAttachments() {
        if (log.isDebugEnabled()) {
            log.debug("Anzahl der Attachments: " + this.attachments.size());
        }
        Attachment[] atts = null;
        if (this.attachments.size() > 0) {
            atts = new Attachment[this.attachments.size()];
            Enumeration<Attachment> e = this.attachments.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                atts[count] = e.nextElement();
                ++count;
            }
        }
        return atts;
    }

    public Role[] getRoles() {
        return this.roles.toArray(new Role[0]);
    }

    public void sign(Role signer, String digestAlgorithm) throws OSCIException, NoSuchAlgorithmException, SignatureException, IOException {
        this.sign(signer, digestAlgorithm, null);
    }

    public void sign(Role signer) throws OSCIException, NoSuchAlgorithmException, SignatureException, IOException {
        this.sign(signer, DialogHandler.getDigestAlgorithm(), null);
    }

    @Deprecated(since="2.0.1")
    public void sign(Role signer, String digestAlgorithm, String time) throws OSCIException, NoSuchAlgorithmException, SignatureException, IOException {
        if (!this.roles.contains(signer)) {
            this.roles.add(signer);
        }
        if (!(signer instanceof Author) && !(signer instanceof Originator)) {
            throw new OSCIRoleException("wrong_role_sign_cont");
        }
        OSCISignature sig = new OSCISignature();
        if (this.signerList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Anzahl der Contents" + this.contentList.size());
            }
            for (int i = 0; i < this.contentList.size(); ++i) {
                Content cnt = this.contentList.get(i);
                this.setNSPrefixes(cnt.soapNSPrefix, cnt.osciNSPrefix, cnt.dsNSPrefix, cnt.xencNSPrefix, cnt.xsiNSPrefix);
                this.addSignatureReference(sig, cnt, digestAlgorithm);
            }
            this.addAttachmentSigRefs(sig, this, digestAlgorithm);
            for (int i = 0; i < this.encryptedDataList.size(); ++i) {
                EncryptedDataOSCI enc = this.encryptedDataList.get(i);
                this.setNSPrefixes(enc.soapNSPrefix, enc.osciNSPrefix, enc.dsNSPrefix, enc.xencNSPrefix, enc.xsiNSPrefix);
                this.addSignatureReference(sig, enc, digestAlgorithm);
            }
        } else {
            for (OSCISignatureReference sigRef : this.signerList.get(0).getReferences().values()) {
                log.debug("RefId: " + sigRef.getRefID());
                if (sigRef.getRefID().startsWith("#" + this.getRefID() + "TS")) continue;
                sig.addSignatureReference(sigRef);
            }
        }
        if (time != null) {
            sig.addSignatureTime(time, this.id + "TS" + this.signedSigPropNr++, digestAlgorithm);
        }
        sig.sign(signer);
        this.signerList.add(sig);
    }

    private void addAttachmentSigRefs(OSCISignature sig, ContentContainer coco, String digestAlgorithm) throws OSCIException, IOException, NoSuchAlgorithmException {
        for (int i = 0; i < coco.contentList.size(); ++i) {
            Content cnt = coco.contentList.get(i);
            if (cnt.getContentType() == 0) {
                if (sig.getReferences().containsKey("cid:" + cnt.getAttachment().getRefID())) continue;
                this.addSignatureReference(sig, cnt.getAttachment(), digestAlgorithm);
                continue;
            }
            if (cnt.getContentType() != 1) continue;
            this.addAttachmentSigRefs(sig, cnt.getContentContainer(), digestAlgorithm);
        }
    }

    private void addSignatureReference(OSCISignature osciSignature, MessagePart messagePart, String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        osciSignature.addSignatureReference(new OSCISignatureReference(messagePart, digestAlgorithm));
    }

    public Role[] getSigners() {
        Role[] roles = new Role[this.signerList.size()];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = this.signerList.get((int)i).signer;
        }
        return roles;
    }

    private boolean listContainsRefid(String refId) {
        if (refId == null) {
            return false;
        }
        for (Content content : this.contentList) {
            String refIdInList = content.getRefID();
            if (!refId.equals(refIdInList)) continue;
            return true;
        }
        return false;
    }

    public void addContent(Content content) {
        this.addContentInternal(content, true);
    }

    void addContentInternal(Content content, boolean checkForDuplicateId) {
        if (!this.signerList.isEmpty() && this.stateOfObject == STATE_OF_OBJECT_CONSTRUCTION) {
            throw new IllegalStateException(DialogHandler.text.getString("signature_violation"));
        }
        boolean containsElement = this.contentList.contains(content);
        if (ParserHelper.isSecureContentDataCheck() && this.getRefID() != null && this.getRefID().equals(content.getRefID())) {
            throw new IllegalArgumentException("refId " + content.getRefID() + " equals ContentContainer ID " + this.getRefID());
        }
        if (!containsElement) {
            if (checkForDuplicateId && this.listContainsRefid(content.getRefID())) {
                throw new IllegalArgumentException("refId " + content.getRefID() + " is already in ContentContainer");
            }
            this.contentList.add(content);
            if (content.getAttachment() != null) {
                this.attachments.put(content.getAttachment().getRefID(), content.getAttachment());
            }
            if (content.getContentContainer() != null) {
                Role[] rls = content.getContentContainer().getRoles();
                this.roles.addAll(Arrays.asList(rls));
                Attachment[] atts = content.getContentContainer().getAttachments();
                if (atts != null) {
                    for (int i = 0; i < atts.length; ++i) {
                        this.attachments.put(atts[i].getRefID(), atts[i]);
                    }
                }
            }
        }
    }

    public Content[] getContents() {
        return this.contentList.toArray(new Content[this.contentList.size()]);
    }

    public void removeContent(Content content) throws IllegalArgumentException {
        boolean erg;
        if (!this.signerList.isEmpty() && this.stateOfObject == STATE_OF_OBJECT_CONSTRUCTION) {
            throw new IllegalStateException(DialogHandler.text.getString("signature_violation"));
        }
        if (log.isDebugEnabled()) {
            log.debug("start remove");
        }
        if (!(erg = this.contentList.remove(content))) {
            throw new IllegalArgumentException();
        }
        if (content.getAttachment() != null) {
            this.attachments.remove(content.getAttachment().getRefID());
        }
    }

    public void addEncryptedData(EncryptedDataOSCI encryptedDataElement) {
        if (!this.signerList.isEmpty() && this.stateOfObject == STATE_OF_OBJECT_CONSTRUCTION) {
            throw new IllegalStateException(DialogHandler.text.getString("signature_violation"));
        }
        if (!this.encryptedDataList.contains(encryptedDataElement)) {
            if (log.isDebugEnabled()) {
                log.debug("Encrypted-Data Element wird hinzugef\u00fcgt.");
            }
            this.encryptedDataList.add(encryptedDataElement);
        }
        Attachment[] atts = encryptedDataElement.getAttachments();
        for (int i = 0; i < atts.length; ++i) {
            if (this.attachments.contains(atts[i])) continue;
            this.attachments.put(atts[i].getRefID(), atts[i]);
        }
        Role[] rls = encryptedDataElement.getRoles();
        Collections.addAll(this.roles, rls);
        if (log.isDebugEnabled()) {
            log.debug("Anzahl der neuen Roles: " + rls.length);
        }
    }

    public void removeEncryptedData(EncryptedDataOSCI encryptedDataElement, boolean removeAttachment) throws IllegalStateException {
        if (!this.signerList.isEmpty() && this.stateOfObject == STATE_OF_OBJECT_CONSTRUCTION) {
            throw new IllegalStateException(DialogHandler.text.getString("signature_violation"));
        }
        this.encryptedDataList.remove(encryptedDataElement);
        if (removeAttachment) {
            for (Attachment attachment : encryptedDataElement.attachments) {
                this.attachments.remove(attachment.getRefID());
            }
        }
    }

    public EncryptedDataOSCI[] getEncryptedData() {
        return this.encryptedDataList.toArray(new EncryptedDataOSCI[this.encryptedDataList.size()]);
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException, OSCIException {
        this.writeXML(out, true);
    }

    protected void writeXML(OutputStream out, boolean inner) throws IOException, OSCIException {
        int i;
        out.write(("<" + this.osciNSPrefix + ":ContentContainer").getBytes(Constants.CHARSET_ENCODING));
        if (out instanceof SymCipherOutputStream || !(out instanceof DigestOutputStream) && !inner) {
            out.write(this.ns);
        }
        if (this.getRefID() != null && this.getRefID().length() > 0) {
            out.write((" Id=\"" + this.getRefID() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(62);
        if (!this.signerList.isEmpty()) {
            for (i = 0; i < this.signerList.size(); ++i) {
                this.signerList.get(i).writeXML(out);
            }
        }
        for (i = 0; i < this.contentList.size(); ++i) {
            this.contentList.get(i).writeXML(out, true);
        }
        for (i = 0; i < this.encryptedDataList.size(); ++i) {
            this.encryptedDataList.get(i).writeXML(out, inner);
        }
        out.write(("</" + this.osciNSPrefix + ":ContentContainer>").getBytes(Constants.CHARSET_ENCODING));
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeXML(out);
        }
        catch (Exception ex1) {
            log.error("Error", (Throwable)ex1);
        }
        return out.toString(Constants.CHARSET_ENCODING);
    }
}

