/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Canonizer;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.EncryptedDataBuilder;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.extinterfaces.OSCIDataSourceExt123;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.OSCISignatureBuilder;
import de.osci.osci12.messageparts.OSCISignatureReference;
import de.osci.osci12.messagetypes.OSCIMessage;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ContentContainerBuilder
extends MessagePartParser {
    private static Logger log = LoggerFactory.getLogger(ContentContainerBuilder.class);
    private boolean readContent = false;
    private boolean underlyingCoco = false;
    private ContentContainerBuilder cocoBuilder = null;
    private OSCIDataSource swapBuffer = null;
    private Attachment att = null;
    private String contentID = null;
    private ContentContainer coco;
    private EncryptedDataBuilder encDataBuilder = null;
    private OSCISignatureBuilder sigBuilder;
    private OutputStreamWriter osw;
    Canonizer can;
    String cocoNS;
    private String soapNSPrefix;
    private String osciNSPrefix;
    private String dsNSPrefix;
    private String xencNSPrefix;
    private String xsiNSPrefix;

    public ContentContainerBuilder(XMLReader xmlReader, DefaultHandler parentHandler, OSCIMessage parentMessage, Attributes atts, Canonizer can) {
        super(xmlReader, parentHandler);
        this.msg = parentMessage;
        this.coco = new ContentContainer();
        this.cocoNS = can.getContainerNS().remove(0);
        this.coco.ns = this.cocoNS.getBytes(Constants.CHARSET_ENCODING);
        StringTokenizer ns = new StringTokenizer(this.cocoNS.substring(1), " =");
        while (ns.hasMoreElements()) {
            String prefix = ns.nextToken();
            prefix = prefix.substring(prefix.indexOf(":") + 1);
            String uri = ns.nextToken();
            if ((uri = uri.substring(1, uri.length() - 1)).equals(SOAP_XMLNS)) {
                this.soapNSPrefix = prefix;
                continue;
            }
            if (uri.equals(OSCI_XMLNS)) {
                this.osciNSPrefix = prefix;
                continue;
            }
            if (uri.equals(DS_XMLNS)) {
                this.dsNSPrefix = prefix;
                continue;
            }
            if (uri.equals(XENC_XMLNS)) {
                this.xencNSPrefix = prefix;
                continue;
            }
            if (!uri.equals(XSI_XMLNS)) continue;
            this.xsiNSPrefix = prefix;
        }
        this.coco.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
        this.coco.stateOfObject = ContentContainer.STATE_OF_OBJECT_PARSING;
        if (atts.getValue("Id") != null) {
            this.coco.setRefID(atts.getValue("Id"));
        }
        this.can = can;
    }

    public ContentContainer getContentContainer() {
        return this.coco;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("start-Element: " + localName);
        }
        if (localName.equals("Signature") && uri.equals(DS_XMLNS)) {
            this.sigBuilder = new OSCISignatureBuilder(this.xmlReader, this, attributes, true);
            this.sigBuilder.sig.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
            this.sigBuilder.sig.ns = this.cocoNS.getBytes(Constants.CHARSET_ENCODING);
            this.xmlReader.setContentHandler(this.sigBuilder);
        } else if (localName.equals("Content") && uri.equals(OSCI_XMLNS)) {
            this.contentID = attributes.getValue("Id");
            if (attributes.getValue("href") != null) {
                String href = attributes.getValue("href").substring(4);
                if (this.msg.attachments.containsKey(href)) {
                    this.att = this.msg.attachments.get(href);
                    if (log.isDebugEnabled()) {
                        log.debug("########## Attachment gefunden. ");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Attchment wird der Nachricht hinzugef\u00fcgt.");
                    }
                    try {
                        this.att = this.msg.isSigned() ? new Attachment(null, href, 0L, this.msg.signatureHeader.getDigestMethods().get("cid:" + href)) : new Attachment(null, href, 0L, null);
                    }
                    catch (Exception ex1) {
                        throw new SAXException(ex1);
                    }
                    this.msg.attachments.put(this.att.getRefID(), this.att);
                    this.att.stateOfAttachment = 1;
                }
            }
        } else if (localName.equals("Base64Content") && uri.equals(OSCI_XMLNS)) {
            this.contentID = attributes.getValue("Id");
            this.readContent = true;
            try {
                this.swapBuffer = DialogHandler.getNewDataBuffer();
                if (this.swapBuffer instanceof OSCIDataSourceExt123) {
                    ((OSCIDataSourceExt123)this.swapBuffer).setConfidential(true);
                }
                this.osw = new OutputStreamWriter(this.swapBuffer.getOutputStream(), Constants.CHAR_ENCODING);
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        } else if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
            if (this.encDataBuilder != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Encrypted-Data wird hinzugef\u00fcgt.");
                }
                EncryptedDataOSCI enc = new EncryptedDataOSCI(this.encDataBuilder.getEncryptedData(), this.msg);
                enc.setNS(this.cocoNS);
                enc.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
                this.coco.addEncryptedData(enc);
            }
            this.encDataBuilder = new EncryptedDataBuilder(this.xmlReader, this, attributes);
            this.xmlReader.setContentHandler(this.encDataBuilder);
        } else if (localName.equals("ContentContainer") && uri.equals(OSCI_XMLNS)) {
            this.readContent = false;
            this.underlyingCoco = true;
            this.cocoBuilder = new ContentContainerBuilder(this.xmlReader, this, this.msg, attributes, this.can);
            this.xmlReader.setContentHandler(this.cocoBuilder);
        } else {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("readContent: " + this.readContent + " " + new String(ch, start, length));
        }
        if (this.readContent) {
            try {
                this.osw.write(ch, start, length);
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block21: {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + localName);
            }
            try {
                if (localName.equals("Content") && uri.equals(OSCI_XMLNS)) {
                    if (this.att != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("######### attachment:");
                        }
                        Content co = new Content(this.att);
                        co.transformers.set(0, "<" + this.dsNSPrefix + ":Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></" + this.dsNSPrefix + ":Transform>");
                        co.coNS = this.cocoNS;
                        co.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
                        co.setRefID(this.contentID);
                        if (log.isDebugEnabled()) {
                            log.debug("RefID: " + this.contentID);
                        }
                        this.coco.addContentInternal(co, false);
                        this.att = null;
                    }
                    break block21;
                }
                if (localName.equals("Base64Content") && uri.equals(OSCI_XMLNS)) {
                    if (log.isDebugEnabled()) {
                        log.debug("#### read Content");
                    }
                    this.osw.close();
                    Content co = new Content(this.swapBuffer);
                    co.coNS = this.cocoNS;
                    co.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
                    co.setRefID(this.contentID);
                    this.coco.addContent(co);
                    this.readContent = false;
                    this.swapBuffer = null;
                    break block21;
                }
                if (localName.equals("ContentContainer") && uri.equals(OSCI_XMLNS)) {
                    if (this.underlyingCoco) {
                        ContentContainer newCoco = this.cocoBuilder.getContentContainer();
                        Content tmpCnt = new Content(newCoco);
                        tmpCnt.transformers.set(0, "<" + this.cocoBuilder.dsNSPrefix + ":Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></" + this.cocoBuilder.dsNSPrefix + ":Transform>");
                        tmpCnt.coNS = this.cocoBuilder.cocoNS;
                        tmpCnt.setRefID(this.contentID);
                        tmpCnt.setNSPrefixes(this.cocoBuilder.soapNSPrefix, this.cocoBuilder.osciNSPrefix, this.cocoBuilder.dsNSPrefix, this.cocoBuilder.xencNSPrefix, this.cocoBuilder.xsiNSPrefix);
                        this.coco.addContent(tmpCnt);
                        this.underlyingCoco = false;
                    } else {
                        if (this.encDataBuilder != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Encrypted-Data wird hinzugef\u00fcgt.Parent Message: ");
                            }
                            EncryptedDataOSCI enc = new EncryptedDataOSCI(this.encDataBuilder.getEncryptedData(), this.msg);
                            enc.setNS(this.cocoNS);
                            enc.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
                            this.coco.addEncryptedData(enc);
                            this.encDataBuilder = null;
                        }
                        if (!this.coco.signerList.isEmpty()) {
                            Map<String, OSCISignatureReference> refs = this.coco.signerList.get(0).getReferences();
                            Content[] cnt = this.coco.getContents();
                            for (int i = 0; i < cnt.length; ++i) {
                                String refKey = "#" + cnt[i].getRefID();
                                if (!refs.containsKey(refKey)) {
                                    throw new SAXException(DialogHandler.text.getString("signature_violation") + ": " + refKey);
                                }
                                cnt[i].transformers = refs.get((Object)refKey).transformerAlgorithms;
                            }
                        }
                        this.xmlReader.setContentHandler(this.parentHandler);
                        if (log.isDebugEnabled()) {
                            log.debug("parentHandler: " + this.parentHandler);
                        }
                        this.parentHandler.endElement(uri, localName, qName);
                    }
                    break block21;
                }
                if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
                    if (this.encDataBuilder != null) {
                        EncryptedDataOSCI enc = new EncryptedDataOSCI(this.encDataBuilder.getEncryptedData(), this.msg);
                        enc.setNS(this.cocoNS);
                        enc.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
                        this.coco.addEncryptedData(enc);
                    }
                    this.encDataBuilder = null;
                    break block21;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Name des Elementes: " + localName);
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (IOException ex) {
                log.error("Fehler beim End-Element.", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
    }
}

