/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Canonizer;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.EncryptedDataBuilder;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.ContentContainerBuilder;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class ContentPackageBuilder
extends MessagePartParser {
    private static Logger log = LoggerFactory.getLogger(ContentPackageBuilder.class);
    private Object lastObject = null;
    private EncryptedDataBuilder encDataBuilder = null;
    private ContentContainerBuilder cocoBuilder = null;
    private Canonizer can;

    public ContentPackageBuilder(XMLReader reader, OSCIMessage msg, Canonizer can) {
        super(reader, null);
        this.msg = msg;
        this.can = can;
    }

    public ContentPackageBuilder(OSCIMessageBuilder parentBuilder) {
        super(parentBuilder);
        this.can = parentBuilder.getCanStream();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName);
        }
        if (!ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) {
            if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
                try {
                    this.encDataBuilder = new EncryptedDataBuilder(this.xmlReader, this, attributes);
                    this.xmlReader.setContentHandler(this.encDataBuilder);
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            } else if (localName.equals("ContentContainer") && uri.equals(OSCI_XMLNS)) {
                this.cocoBuilder = new ContentContainerBuilder(this.xmlReader, this, this.msg, attributes, this.can);
                this.xmlReader.setContentHandler(this.cocoBuilder);
            } else {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + localName);
            }
            try {
                if (ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) {
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                if (localName.equals("ContentContainer") && uri.equals(OSCI_XMLNS)) {
                    this.lastObject = this.cocoBuilder.getContentContainer();
                    if (this.parentHandler != null) {
                        this.msg.contentContainer.put(((ContentContainer)this.lastObject).getRefID(), (ContentContainer)this.lastObject);
                    }
                    break block10;
                }
                if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Encrypted-Data wird hinzugef\u00fcgt.");
                    }
                    this.lastObject = new EncryptedDataOSCI(this.encDataBuilder.getEncryptedData(), this.msg);
                    ((EncryptedDataOSCI)this.lastObject).setRefID(this.encDataBuilder.getEncryptedData().getId());
                    if (this.parentHandler != null) {
                        this.msg.encryptedData.put(((EncryptedDataOSCI)this.lastObject).getRefID(), (EncryptedDataOSCI)this.lastObject);
                    }
                    ((EncryptedDataOSCI)this.lastObject).setNSPrefixes(this.msg);
                    ((EncryptedDataOSCI)this.lastObject).setNS(this.msg.ns);
                    break block10;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error("Fehler beim End Element. ", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
    }

    public Object getLastCreatedObject() {
        return this.lastObject;
    }
}

