/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.helper.Canonizer;
import de.osci.helper.ParserHelper;
import de.osci.helper.SymCipherInputStream;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCICancelledException;
import de.osci.osci12.encryption.CipherReference;
import de.osci.osci12.encryption.CipherValue;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.encryption.EncryptedData;
import de.osci.osci12.encryption.EncryptedKey;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.ContentPackageBuilder;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Role;
import de.osci.osci12.signature.KeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class EncryptedDataOSCI
extends MessagePart {
    private static Logger log = LoggerFactory.getLogger(EncryptedDataOSCI.class);
    private static int idNr = -1;
    private int keyIDs = 0;
    private static final int TYPE_OF_DATA_ATTACHMENT = 0;
    private static final int TYPE_OF_DATA_CONTENTCONTAINER = 1;
    private int typeOfData = -1;
    private static int ENCRYPTEDDATA_START = 0;
    private static int ENCRYPTEDDATA_ENCRYPTED = 1;
    private int stateOfObject = ENCRYPTEDDATA_START;
    private EncryptedData encryptedDataObject = null;
    Vector<Role> roles = new Vector();
    Vector<Role> readers = new Vector();
    Vector<Attachment> attachments = new Vector();
    private Hashtable<Role, EncryptedKey> encryptedKeyList = new Hashtable();
    private MessagePart content = null;
    private OSCIMessage msg = null;
    private SecretKey secretKey = null;

    EncryptedDataOSCI(Attachment attachment) throws IOException {
        this.typeOfData = 0;
        if (attachment == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " attachment = null");
        }
        this.attachments.add(attachment);
        if (!attachment.isEncrypted()) {
            throw new IllegalArgumentException(DialogHandler.text.getString("error_unencrypted_attachment"));
        }
        if (attachment.getSymmetricCipherAlgorithm() == null) {
            if (log.isDebugEnabled()) {
                log.error("SymmetricCipherAlgorithm wurde nicht gesetzt.");
            }
            throw new IllegalArgumentException(DialogHandler.text.getString("error_unencrypted_attachment"));
        }
        this.secretKey = attachment.secretKey;
        if (log.isDebugEnabled()) {
            log.debug("Secret-Key des Attachments wird verwendet.");
        }
        CipherReference ref = new CipherReference("cid:" + attachment.getRefID());
        this.setRefID("Attachment" + attachment.getRefID());
        this.encryptedDataObject = new EncryptedData(ref, attachment.getSymmetricCipherAlgorithm(), attachment.getIvLength(), this.getRefID());
        this.stateOfObject = ENCRYPTEDDATA_ENCRYPTED;
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setMgmtData(Base64.encode(attachment.secretKey.getEncoded()));
        this.encryptedDataObject.setKeyInfo(keyInfo);
        this.content = attachment;
    }

    public EncryptedDataOSCI(ContentContainer coco) throws NoSuchAlgorithmException, IOException {
        this(null, "http://www.w3.org/2009/xmlenc11#aes256-gcm", 12, coco);
    }

    @Deprecated(since="1.8")
    public EncryptedDataOSCI(SecretKey secretKey, ContentContainer coco) throws NoSuchAlgorithmException, IOException {
        this(secretKey, Crypto.getCipherAlgoID(secretKey), 12, coco);
    }

    public EncryptedDataOSCI(String symmetricCipherAlgorithm, int ivLength, ContentContainer coco) throws NoSuchAlgorithmException, IOException {
        this(null, symmetricCipherAlgorithm, ivLength, coco);
    }

    public EncryptedDataOSCI(String symmetricCipherAlgorithm, ContentContainer coco) throws NoSuchAlgorithmException, IOException {
        this(null, symmetricCipherAlgorithm, 12, coco);
    }

    public EncryptedDataOSCI(SecretKey secretKey, String algo, ContentContainer coco) throws NoSuchAlgorithmException {
        this(secretKey, algo, 12, coco);
    }

    public EncryptedDataOSCI(SecretKey secretKey, String algo, int ivLength, ContentContainer coco) throws NoSuchAlgorithmException {
        int i;
        int len;
        String secKeyAlgo;
        this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></ds:Transform>");
        this.id = this.typ + ++idNr;
        if (algo == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " algo = null");
        }
        if (secretKey == null) {
            secretKey = Crypto.createSymKey(algo);
        }
        if (!(secKeyAlgo = secretKey.getAlgorithm()).equals("DESede") && !secKeyAlgo.equals("AES")) {
            throw new NoSuchAlgorithmException(DialogHandler.text.getString("encryption_algorithm_not_supported") + secKeyAlgo);
        }
        if (secKeyAlgo.equals("AES") && (len = secretKey.getEncoded().length) != 16 && len != 24 && len != 32) {
            throw new NoSuchAlgorithmException(DialogHandler.text.getString("encryption_algorithm_not_supported AES-" + len * 8));
        }
        if (coco == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " coco = null");
        }
        this.typeOfData = 1;
        this.id = "encdata_" + idNr++;
        this.secretKey = secretKey;
        this.content = coco;
        this.encryptedDataObject = new EncryptedData(coco, algo, ivLength, this.id, this.secretKey);
        Attachment[] atts = coco.getAttachments();
        if (atts != null && atts.length > 0) {
            for (i = 0; i < atts.length; ++i) {
                this.attachments.add(atts[i]);
            }
        }
        for (i = 0; i < coco.roles.size(); ++i) {
            this.roles.add(coco.roles.get(i));
        }
        this.setNSPrefixes(coco.soapNSPrefix, coco.osciNSPrefix, coco.dsNSPrefix, coco.xencNSPrefix, coco.xsiNSPrefix);
        this.setNS(new String(coco.ns, Constants.CHARSET_ENCODING));
    }

    public EncryptedDataOSCI(EncryptedData encryptedData, OSCIMessage osciMsg) throws SAXException {
        this.encryptedDataObject = encryptedData;
        this.stateOfObject = ENCRYPTEDDATA_ENCRYPTED;
        this.id = encryptedData.getId();
        this.msg = osciMsg;
        EncryptedKey[] encKeys = encryptedData.getKeyInfo().getEncryptedKeys();
        for (int i = 0; i < encKeys.length; ++i) {
            Role role;
            String uri = encKeys[i].getKeyInfo().getRetrievalMethod().getURI();
            if (uri.startsWith("#")) {
                uri = uri.substring(1);
            }
            if ((role = osciMsg.getRoleForRefID(uri)) == null) {
                throw new SAXException(DialogHandler.text.getString("no_cipher_cert") + uri);
            }
            this.roles.add(role);
            this.readers.add(role);
        }
    }

    void setNS(String ns) {
        this.encryptedDataObject.encNS = ns;
    }

    @Override
    public void setNSPrefixes(String soap, String osci, String ds, String xenc, String xsi) {
        this.encryptedDataObject.soapNSPrefix = soap;
        this.encryptedDataObject.osciNSPrefix = osci;
        this.encryptedDataObject.dsNSPrefix = ds;
        this.encryptedDataObject.xencNSPrefix = xenc;
        this.encryptedDataObject.xsiNSPrefix = xsi;
    }

    public ContentContainer decrypt(Role reader) throws OSCICipherException, OSCIRoleException, IOException, OSCICancelledException, SAXException, NoSuchAlgorithmException {
        EncryptedKey encKey = this.encryptedDataObject.findEncrypedKey(this.getCertificatIdForRole(reader));
        if (log.isDebugEnabled()) {
            log.debug("Anzahl der Empf\u00e4nger: " + this.encryptedKeyList.size());
        }
        if (encKey == null || !reader.hasCipherPrivateKey()) {
            throw new IllegalArgumentException(DialogHandler.text.getString("no_encryption_for_role"));
        }
        if (log.isDebugEnabled()) {
            log.debug("key: " + encKey.getKeyInfo().getRetrievalMethod().getURI());
        }
        InputStream keyIn = encKey.getCipherData().getCipherValue().getCipherValueStream();
        keyIn.reset();
        byte[] dt = Tools.readBytes(keyIn);
        byte[] decryptedKey = encKey.getEncryptionMethodAlgorithm().equals("http://www.w3.org/2009/xmlenc11#rsa-oaep") ? reader.getDecrypter().decrypt(dt, encKey.mgfAlgorithm, encKey.digestAlgorithm) : reader.getDecrypter().decrypt(dt);
        if (this.encryptedDataObject.getCipherData().getCipherReference() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Es handelt sich um eine CipherReference unbekannter herkunft.");
            }
            throw new OSCICipherException("invalid_reference");
        }
        if (log.isDebugEnabled()) {
            log.debug("Es handelt sich um ein CipherValue.");
        }
        InputStream in = this.encryptedDataObject.getCipherData().getCipherValue().getCipherValueStream();
        in.reset();
        if (!this.encryptedDataObject.isIvLengthParsed()) {
            this.encryptedDataObject.setIvLength(16);
        }
        SymCipherInputStream cin = new SymCipherInputStream(in, Crypto.createSymKey(decryptedKey, this.encryptedDataObject.getEncryptionMethodAlgorithm()), this.encryptedDataObject.getEncryptionMethodAlgorithm(), this.encryptedDataObject.getIvLength(), false);
        return this.parseInputStream(cin);
    }

    private String getCertificatIdForRole(Role role) throws OSCIRoleException {
        if (role == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " reader = null");
        }
        String rdId = null;
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!role.getCipherCertificate().equals(this.roles.get(i).getCipherCertificate())) continue;
            rdId = this.roles.get(i).getCipherCertificateId();
            break;
        }
        if (rdId == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString("no_encryption_for_role"));
        }
        return rdId;
    }

    public String getAsymEncryptionAlgorithm(Role reader) throws OSCIRoleException {
        EncryptedKey encKey = this.encryptedDataObject.findEncrypedKey(this.getCertificatIdForRole(reader));
        if (encKey != null) {
            return encKey.getEncryptionMethodAlgorithm();
        }
        return null;
    }

    public void encrypt(byte[] encryptedSymKey, Role reader) throws OSCIRoleException, IOException, OSCICipherException {
        this.encrypt(encryptedSymKey, reader, "http://www.w3.org/2009/xmlenc11#rsa-oaep");
    }

    public void encrypt(byte[] encryptedSymKey, Role reader, String algorithm) throws OSCIRoleException, IOException, OSCICipherException {
        if (!this.readers.contains(reader)) {
            this.roles.add(reader);
            this.readers.add(reader);
        }
        this.stateOfObject = ENCRYPTEDDATA_ENCRYPTED;
        if (log.isDebugEnabled()) {
            log.debug("Encrypted-Data Methode encrypt mit :" + reader.getCipherCertificateId());
        }
        KeyInfo keyInfo = null;
        keyInfo = this.content == null ? new KeyInfo("#" + reader.getCipherCertificate()) : new KeyInfo("#" + reader.getCipherCertificateId());
        CipherValue cipherValue = new CipherValue(encryptedSymKey);
        EncryptedKey encryptedKey = new EncryptedKey(algorithm, cipherValue);
        encryptedKey.setId("EncData_" + this.id + "_" + this.keyIDs);
        encryptedKey.setKeyInfo(keyInfo);
        if (this.encryptedDataObject.getKeyInfo() == null) {
            this.encryptedDataObject.setKeyInfo(new KeyInfo());
        }
        this.encryptedDataObject.getKeyInfo().addEncryptedKey(encryptedKey);
        this.encryptedKeyList.put(reader, encryptedKey);
        if (this.content instanceof ContentContainer) {
            this.createEncryptedAttachments((ContentContainer)this.content, encryptedSymKey, reader);
        }
        if (log.isDebugEnabled()) {
            log.debug("Fertig mit Encrypted-Data Methode encrypt mit.");
        }
    }

    private ContentContainer parseInputStream(InputStream in) throws OSCICipherException, IOException, SAXException, NoSuchAlgorithmException {
        ContentPackageBuilder copaBuilder = null;
        try {
            Canonizer can = null;
            can = ParserHelper.isSecureContentDataCheck() ? new Canonizer(in, null, true) : new Canonizer(in, null, false);
            InputStreamReader isr = new InputStreamReader((InputStream)can, Constants.CHARSET_ENCODING);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            XMLReader rd = parser.getXMLReader();
            ParserHelper.setFeatures(rd);
            copaBuilder = new ContentPackageBuilder(rd, this.msg, can);
            rd.setContentHandler(copaBuilder);
            rd.parse(new InputSource(isr));
        }
        catch (ParserConfigurationException ex1) {
            throw new SAXException(ex1);
        }
        finally {
            in.close();
        }
        if (copaBuilder.getLastCreatedObject() instanceof ContentContainer) {
            ContentContainer coco = (ContentContainer)copaBuilder.getLastCreatedObject();
            this.decryptAttachments(coco);
            return coco;
        }
        throw new OSCICipherException("sax_exception");
    }

    private void decryptAttachments(ContentContainer contentContainer) throws IOException {
        EncryptedDataOSCI[] encDatas = contentContainer.getEncryptedData();
        for (int i = 0; i < encDatas.length; ++i) {
            if (encDatas[i].encryptedDataObject.getCipherData().getCipherReference() == null) continue;
            String uri = encDatas[i].encryptedDataObject.getCipherData().getCipherReference().getURI();
            if (uri.startsWith("cid:")) {
                uri = uri.substring(4);
            }
            encDatas[i].setRefID(uri);
            Hashtable<String, Attachment> msgAtts = this.msg.attachments;
            Attachment att = msgAtts.get(uri);
            att.stateOfAttachment = 2;
            att.encrypt = true;
            if (log.isDebugEnabled()) {
                log.debug("das Attachment: " + att + " URI: " + uri);
            }
            att.secretKey = Crypto.createSymKey(Base64.decode(encDatas[i].encryptedDataObject.getKeyInfo().getMgmtData()), encDatas[i].encryptedDataObject.getEncryptionMethodAlgorithm());
            att.symmetricCipherAlgorithm = encDatas[i].encryptedDataObject.getEncryptionMethodAlgorithm();
            att.ivLength = encDatas[i].encryptedDataObject.getIvLength();
            contentContainer.attachments.put(att.getRefID(), att);
            contentContainer.removeEncryptedData(encDatas[i], false);
        }
        Content[] cnts = contentContainer.getContents();
        for (int i = 0; i < cnts.length; ++i) {
            if (cnts[i].getContentType() != 1) continue;
            this.decryptAttachments(cnts[i].getContentContainer());
        }
    }

    private void createEncryptedAttachments(ContentContainer cc, byte[] encryptedSymKey, Role reader) throws IOException {
        Attachment[] atts = cc.getAttachments();
        if (atts != null) {
            int i;
            ContentContainer coco = (ContentContainer)this.content;
            coco.stateOfObject = ContentContainer.STATE_OF_OBJECT_PARSING;
            HashSet<Object> encDataRefIds = new HashSet<Object>();
            EncryptedDataOSCI[] edo = coco.getEncryptedData();
            for (i = 0; i < edo.length; ++i) {
                encDataRefIds.add(edo[i].getRefID());
            }
            for (i = 0; i < atts.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("Ein weiteres Attachment." + atts[i].getRefID());
                }
                if (!encDataRefIds.add("Attachment" + atts[i].getRefID())) continue;
                EncryptedDataOSCI encData = new EncryptedDataOSCI(atts[i]);
                encData.setNSPrefixes(coco.soapNSPrefix, coco.osciNSPrefix, coco.dsNSPrefix, coco.xencNSPrefix, coco.xsiNSPrefix);
                encData.setNS(new String(coco.ns, Constants.CHARSET_ENCODING));
                coco.addEncryptedData(encData);
            }
            Role[] roles = ((ContentContainer)this.content).getRoles();
            for (int i2 = 0; i2 < roles.length; ++i2) {
                if (this.roles.contains(roles[i2])) continue;
                this.roles.add(roles[i2]);
            }
        }
        Content[] cnts = cc.getContents();
        for (int i = 0; i < cnts.length; ++i) {
            if (cnts[i].getContentType() != 1) continue;
            this.createEncryptedAttachments(cnts[i].getContentContainer(), encryptedSymKey, reader);
        }
    }

    public void encrypt(Role reader) throws OSCICipherException, OSCIRoleException, IOException, NoSuchAlgorithmException {
        this.encrypt(reader, "http://www.w3.org/2009/xmlenc11#rsa-oaep");
    }

    public void encrypt(Role reader, String algorithm) throws OSCICipherException, OSCIRoleException, IOException, NoSuchAlgorithmException {
        if (!this.readers.contains(reader)) {
            this.roles.add(reader);
            this.readers.add(reader);
        }
        this.stateOfObject = ENCRYPTEDDATA_ENCRYPTED;
        if (log.isDebugEnabled()) {
            log.debug("Encrypted-Data Methode encrypt mit :" + reader.getCipherCertificateId() + " Es handelt sich um ein EncryptedData Objekt vom Typ:" + this.typeOfData);
        }
        if (this.secretKey == null) {
            throw new OSCICipherException("no_secret_key");
        }
        byte[] encryptedSymKey = Crypto.doRSAEncryption(reader.getCipherCertificate(), this.secretKey, algorithm);
        this.encrypt(encryptedSymKey, reader, algorithm);
    }

    @Override
    public void writeXML(OutputStream out) throws IOException, OSCIException {
        this.writeXML(out, true);
    }

    public void writeXML(OutputStream out, boolean inner) throws IOException, OSCIException {
        if (this.stateOfObject < ENCRYPTEDDATA_ENCRYPTED) {
            throw new IllegalStateException(DialogHandler.text.getString("invalid_stateofobject") + " not encrypted.");
        }
        this.encryptedDataObject.setId(this.getRefID());
        this.encryptedDataObject.writeXML(out, inner);
    }

    public String getSymEncryptionMethod() {
        return this.encryptedDataObject.getEncryptionMethodAlgorithm();
    }

    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[0]);
    }

    public Role[] getRoles() {
        return this.roles.toArray(new Role[0]);
    }

    public Role[] getReaders() {
        return this.readers.toArray(new Role[0]);
    }

    public void setIvLength(int ivLength) {
        if (this.encryptedDataObject != null) {
            this.encryptedDataObject.setIvLength(ivLength);
        } else {
            log.warn("Could not set IV, encryptedDataObject is null");
        }
    }
}

