/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.helper.CanParser;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIErrorException;
import de.osci.osci12.messageparts.ContentContainerBuilder;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messageparts.OSCISignatureReference;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.roles.Role;
import de.osci.osci12.signature.OSCISignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class OSCISignatureBuilder
extends MessagePartParser {
    private static Logger log = LoggerFactory.getLogger(OSCISignatureBuilder.class);
    OSCISignature sig;
    boolean insideSignature = false;
    Boolean insideSignedInfo;
    boolean insideReference = false;
    boolean insideObject = false;
    boolean insideXades = false;
    boolean insideKeyInfo = false;
    private OSCISignatureReference sr;
    private String signingTime;
    private String signingPropsId;

    public OSCISignatureBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes atts, boolean signatureElementAvaliable) throws SAXException {
        super(xmlReader, parentHandler);
        this.insideSignature = signatureElementAvaliable;
        if (parentHandler instanceof OSCIMessageBuilder) {
            OSCIMessage msg = ((OSCIMessageBuilder)parentHandler).getOSCIMessage();
            String signatureName = ((OSCIMessageBuilder)parentHandler).getOSCIMessage() instanceof OSCIRequest ? Constants.HeaderTags.ClientSignature.getElementName() : Constants.HeaderTags.SupplierSignature.getElementName();
            String name = "<" + msg.osciNSPrefix + ":";
            String soap = msg.soapNSPrefix;
            name = name + signatureName + " Id=\"";
            name = name + atts.getValue("Id") + "\" ";
            name = name + soap + ":actor=\"http://schemas.xmlsoap.org/soap/actor/next\" " + soap + ":mustUnderstand=\"1\">";
            this.sig = new OSCISignature(name);
            this.sig.setNSPrefixes(soap, msg.osciNSPrefix, msg.dsNSPrefix, msg.xencNSPrefix, msg.xsiNSPrefix);
        } else {
            this.sig = new OSCISignature();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element" + uri + ":" + localName);
        }
        if (!(!uri.equals(DS_XMLNS) || !localName.equals("Signature") || this.insideSignature || this.insideKeyInfo || this.insideObject || this.insideReference || this.insideSignedInfo != null && this.insideSignedInfo.booleanValue() || this.insideXades)) {
            this.insideSignature = true;
            return;
        }
        if (!this.insideSignature) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        if (this.insideSignedInfo != null && this.insideSignedInfo.booleanValue() && uri.equals(DS_XMLNS)) {
            if (localName.equals("Reference")) {
                this.insideReference = true;
                this.sr = new OSCISignatureReference();
                String rf = attributes.getValue("URI");
                this.sr.setRefID(rf);
                try {
                    this.sig.addSignatureReference(this.sr);
                    return;
                }
                catch (OSCIErrorException ex) {
                    log.error("Error add the reference!", (Throwable)ex);
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName, ex);
                }
            }
            if (localName.equals("CanonicalizationMethod")) {
                return;
            }
            if (!this.insideReference) {
                if (!localName.equals("SignatureMethod")) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                this.sig.signatureAlgorithm = attributes.getValue("Algorithm");
                if (Constants.JCA_JCE_MAP.get(attributes.getValue("Algorithm")) != null) return;
                throw new SAXException(DialogHandler.text.getString("invalid_signature_algorithm") + " " + attributes.getValue("Algorithm"));
            }
            if (localName.equals("Transforms")) {
                return;
            }
            if (localName.equals("Transform")) {
                try {
                    CanParser cp = new CanParser(this.sr.transformerAlgorithms, this.xmlReader, this, qName);
                    this.xmlReader.setContentHandler(cp);
                    cp.startDocument();
                    cp.startElement(uri, localName, qName, attributes);
                    return;
                }
                catch (Exception ex) {
                    throw new SAXException(DialogHandler.text.getString("sax_exception_transfomation"), ex);
                }
            }
            if (localName.equals("DigestMethod")) {
                this.sr.setDigestMethodAlgorithm(attributes.getValue("Algorithm"));
                return;
            }
            if (!localName.equals("DigestValue")) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            this.currentElement = new StringBuffer();
            return;
        }
        if (!this.insideKeyInfo && !this.insideObject && uri.equals(DS_XMLNS)) {
            if (localName.equals("SignedInfo") && this.insideSignedInfo == null) {
                this.insideSignedInfo = true;
                return;
            }
            if (localName.equals("KeyInfo")) {
                this.insideKeyInfo = true;
                return;
            }
            if (localName.equals("Object")) {
                this.insideObject = true;
                return;
            }
            if (!localName.equals("SignatureValue")) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            if (this.sig.signatureValue != null) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            this.currentElement = new StringBuffer();
            return;
        }
        if (this.insideKeyInfo && uri.equals(DS_XMLNS) && localName.equals("RetrievalMethod")) {
            String rf;
            this.sig.signerId = rf = attributes.getValue("URI");
            return;
        }
        if (!this.insideObject) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        if (!uri.equals("http://uri.etsi.org/01903/v1.3.2#")) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        if (localName.equals("QualifyingProperties")) {
            this.insideXades = true;
            return;
        }
        if (!this.insideXades) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        if (localName.equals("QualifyingProperties")) return;
        if (localName.equals("SignedSignatureProperties")) {
            return;
        }
        if (localName.equals("SigningTime")) {
            this.currentElement = new StringBuffer();
            return;
        }
        if (!localName.equals("SignedProperties")) return;
        this.signingPropsId = attributes.getValue("Id");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block35: {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + uri + ":" + localName);
            }
            try {
                if (this.insideSignature) {
                    if (uri.equals(DS_XMLNS)) {
                        if (localName.equals("Signature")) {
                            this.insideSignature = false;
                            if (this.parentHandler instanceof ContentContainerBuilder) {
                                Role signer;
                                String sigId;
                                if (log.isDebugEnabled()) {
                                    log.debug("##########" + this.sig.signerId);
                                }
                                if ((sigId = this.sig.signerId).charAt(0) == '#') {
                                    sigId = sigId.substring(1);
                                }
                                if ((signer = ((ContentContainerBuilder)this.parentHandler).msg.getRoleForRefID(sigId)) == null) {
                                    log.error("Das referenzierte Signer-Objekt konnte nicht gefunden werden.");
                                    throw new OSCISignatureException("no_signature_cert", sigId);
                                }
                                this.sig.signer = signer;
                                ((ContentContainerBuilder)this.parentHandler).getContentContainer().addSignature(this.sig);
                                this.sig.signedInfo = ((ContentContainerBuilder)this.parentHandler).can.getSignedInfos().remove(1);
                                if (this.signingPropsId != null) {
                                    this.sig.signingProperties = ((ContentContainerBuilder)this.parentHandler).can.getSignedProperties().remove(0);
                                    this.sig.signingPropsId = this.signingPropsId;
                                    this.sig.signingTime = this.signingTime;
                                }
                            } else if (this.parentHandler instanceof OSCIMessageBuilder) {
                                if (((OSCIMessageBuilder)this.parentHandler).getOSCIMessage().signatureHeader != null) {
                                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                                }
                                ((OSCIMessageBuilder)this.parentHandler).getOSCIMessage().signatureHeader = this.sig;
                            }
                            this.xmlReader.setContentHandler(this.parentHandler);
                        } else if (localName.equals("Object")) {
                            this.insideObject = false;
                        } else if (localName.equals("Reference")) {
                            this.insideReference = false;
                            if (log.isDebugEnabled()) {
                                String[] tr = this.sr.getTransformerAlgorithms();
                                for (int i = 0; i < tr.length; ++i) {
                                    log.debug("\nTRANS: " + this.sr.getRefID() + " - " + tr[i]);
                                }
                            }
                            this.sr = null;
                        } else if (localName.equals("SignedInfo")) {
                            this.insideSignedInfo = false;
                        } else if (localName.equals("SignatureValue")) {
                            this.sig.signatureValue = Base64.decode(this.currentElement.toString());
                        } else if (localName.equals("KeyInfo")) {
                            this.insideKeyInfo = false;
                        } else if (this.insideReference && localName.equals("DigestValue")) {
                            if (log.isDebugEnabled()) {
                                log.debug("ID " + this.sr.getRefID());
                            }
                            byte[] dv = Base64.decode(this.currentElement.toString());
                            this.sr.setDigestValue(dv);
                        }
                        break block35;
                    }
                    if (this.insideXades && uri.equals("http://uri.etsi.org/01903/v1.3.2#")) {
                        if (localName.equals("QualifyingProperties")) {
                            this.insideXades = false;
                        } else if (localName.equals("SigningTime") && this.parentHandler instanceof ContentContainerBuilder) {
                            this.signingTime = this.currentElement.toString();
                        } else if (!localName.equals("SignedProperties") && !localName.equals("SignedSignatureProperties")) {
                            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                        }
                        break block35;
                    }
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (Exception ex) {
                log.error("Fehler im End-Element!", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
        this.currentElement = null;
    }
}

