/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.MessagePart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OSCISignatureReference
extends MessagePart {
    private static Logger log = LoggerFactory.getLogger(OSCISignatureReference.class);
    Vector<String> transformerAlgorithms = new Vector();
    String digestMethodAlgorithm;
    byte[] digestValue;

    OSCISignatureReference(MessagePart messagePart, String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        this.id = messagePart instanceof Attachment ? "cid:" + messagePart.getRefID() : "#" + messagePart.getRefID();
        this.setNSPrefixes(messagePart.soapNSPrefix, messagePart.osciNSPrefix, messagePart.dsNSPrefix, messagePart.xencNSPrefix, messagePart.xsiNSPrefix);
        this.digestMethodAlgorithm = digestAlgorithm;
        this.digestValue = messagePart.getDigestValue(this.digestMethodAlgorithm);
        this.transformerAlgorithms = messagePart.transformers;
    }

    OSCISignatureReference() {
    }

    public String getDigestMethodAlgorithm() {
        return this.digestMethodAlgorithm;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public String[] getTransformerAlgorithms() {
        return this.transformerAlgorithms.toArray(new String[0]);
    }

    public void setDigestMethodAlgorithm(String digestMethodAlgorithm) {
        if (Constants.JCA_JCE_MAP.get(digestMethodAlgorithm) == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString("invalid_hash_algorithm") + " " + digestMethodAlgorithm);
        }
        this.digestMethodAlgorithm = digestMethodAlgorithm;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        out.write(("<" + this.dsNSPrefix + ":Reference URI=\"" + this.id + "\">\n").getBytes(Constants.CHARSET_ENCODING));
        if (!this.transformerAlgorithms.isEmpty()) {
            out.write(("<" + this.dsNSPrefix + ":Transforms>\n").getBytes(Constants.CHARSET_ENCODING));
            for (int j = 0; j < this.transformerAlgorithms.size(); ++j) {
                out.write(this.transformerAlgorithms.get(j).getBytes(Constants.CHARSET_ENCODING));
            }
            out.write(("\n</" + this.dsNSPrefix + ":Transforms>\n").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("<" + this.dsNSPrefix + ":DigestMethod Algorithm=\"" + this.digestMethodAlgorithm + "\"></" + this.dsNSPrefix + ":DigestMethod>\n<" + this.dsNSPrefix + ":DigestValue>" + Base64.encode(this.digestValue) + "</" + this.dsNSPrefix + ":DigestValue>\n</" + this.dsNSPrefix + ":Reference>\n").getBytes(Constants.CHARSET_ENCODING));
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeXML(out);
            return out.toString();
        }
        catch (IOException ex) {
            log.trace(String.valueOf(ex));
            return "";
        }
    }
}

