/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.InspectionBuilder;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messageparts.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class TimestampBuilder
extends MessagePartParser {
    private static Logger log = LoggerFactory.getLogger(TimestampBuilder.class);
    private Timestamp timestamp = new Timestamp();

    public TimestampBuilder(XMLReader xmlReader, DefaultHandler parentHandler) {
        super(xmlReader, parentHandler);
        MessagePart mp = parentHandler instanceof InspectionBuilder ? ((InspectionBuilder)parentHandler).inspection : ((ProcessCardBundleBuilder)parentHandler).processCard;
        this.timestamp.setNSPrefixes(mp.soapNSPrefix, mp.osciNSPrefix, mp.dsNSPrefix, mp.xencNSPrefix, mp.xsiNSPrefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug("Start-Element: " + localName);
            }
            try {
                if (localName.equals("Plain") && uri.equals(OSCI_XMLNS)) {
                    this.currentElement = new StringBuffer();
                    break block7;
                }
                if (localName.equals("Cryptographic") && uri.equals(OSCI_XMLNS)) {
                    this.currentElement = new StringBuffer();
                    String algo = attributes.getValue("Algorithm");
                    if (algo == null || algo.equals("")) {
                        throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Algorithm");
                    }
                    this.timestamp.setAlgorithm(algo);
                    break block7;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception ex) {
                log.error("Fehler im Start-Element", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + localName);
            }
            try {
                if (localName.equals("Plain") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setTimeStamp(this.currentElement.toString());
                    break block10;
                }
                if (localName.equals("Cryptographic") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setTimeStamp(new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING));
                    break block10;
                }
                if (localName.equals("Timestamp") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setNameID(3);
                    this.parentHandler.endElement(uri, localName, qName);
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                if (localName.equals("Creation") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setNameID(0);
                    this.parentHandler.endElement(uri, localName, qName);
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                if (localName.equals("Forwarding") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setNameID(1);
                    this.parentHandler.endElement(uri, localName, qName);
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                if (localName.equals("Reception") && uri.equals(OSCI_XMLNS)) {
                    this.timestamp.setNameID(2);
                    this.parentHandler.endElement(uri, localName, qName);
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error("Fehler im End-Element!", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
        this.currentElement = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }

    Timestamp getTimestampObject() {
        return this.timestamp;
    }
}

