/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.ForwardDelivery;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToAcceptDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.IntermediaryCertificatesH;
import de.osci.osci12.soapheader.OsciH;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class AcceptDelivery
extends OSCIRequest
implements ContentPackageI {
    public ProcessCardBundle processCardBundle = null;
    public DialogHandler fwdDH;

    AcceptDelivery(DialogHandler dh) {
        super(dh);
        this.messageType = 1;
        this.addressee = (Addressee)dh.getSupplier();
    }

    AcceptDelivery() {
        this.messageType = 1;
    }

    AcceptDelivery(ForwardDelivery fd) throws OSCIRoleException, NoSuchAlgorithmException {
        super(new DialogHandler((Intermed)fd.dialogHandler.getSupplier(), fd.addressee, null));
        int i;
        this.messageType = 1;
        this.uriReceiver = fd.uriReceiver;
        this.addressee = fd.addressee;
        this.originator = fd.originator;
        this.desiredLanguagesH = new DesiredLanguagesH(fd.desiredLanguagesH.getLanguageList());
        ContentContainer[] con = fd.getContentContainer();
        for (int i2 = 0; i2 < con.length; ++i2) {
            this.addContentContainer(con[i2]);
        }
        EncryptedDataOSCI[] enc = fd.getEncryptedData();
        for (int i3 = 0; i3 < enc.length; ++i3) {
            this.addEncryptedData(enc[i3]);
        }
        Attachment[] att = fd.getAttachments();
        for (i = 0; i < att.length; ++i) {
            this.addAttachment(att[i]);
        }
        for (i = 0; i < fd.getOtherAuthors().length; ++i) {
            this.otherAutors.put(fd.getOtherAuthors()[i].id, fd.getOtherAuthors()[i]);
        }
        for (i = 0; i < fd.getOtherReaders().length; ++i) {
            this.otherReaders.put(fd.getOtherReaders()[i].id, fd.getOtherReaders()[i]);
        }
        this.dialogHandler.setEncryption(fd.getDialogHandler().isEncryption());
        this.dialogHandler.getControlblock().setResponse(null);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setConversationID(null);
        this.dialogHandler.getControlblock().setSequenceNumber(-1);
        this.fwdDH = fd.getDialogHandler();
    }

    ResponseToAcceptDelivery send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToAcceptDelivery)this.transmit(null, null);
    }

    public ProcessCardBundle getProcessCardBundle() {
        return this.processCardBundle;
    }

    public Timestamp getTimestampCreation() {
        return this.processCardBundle.getCreation();
    }

    public Timestamp getTimestampForwarding() {
        return this.processCardBundle.getForwarding();
    }

    public Inspection[] getInspections() {
        return this.processCardBundle.getInspections();
    }

    @Override
    public String getSubject() {
        return this.processCardBundle.getSubject();
    }

    public String getRecentModification() {
        return this.processCardBundle.getRecentModification();
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addCustomHeaderExtention(CustomHeaderExtention extention) {
        super.addCustomHeaderExtention(extention);
    }

    @Override
    public CustomHeaderExtention getCustomHeader(CustomHeaderExtention ext) throws IOException {
        return super.getCustomHeader(ext);
    }

    @Override
    public String getMessageId() {
        return this.processCardBundle.getMessageId();
    }

    void setProcessCardBundle(ProcessCardBundle processCardBundle) {
        this.processCardBundle = processCardBundle;
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(5, this.intermediaryCertificatesH);
        this.messageParts.set(3, null);
    }

    @Override
    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        if (this.processCardBundle == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": ProcessCardBundle");
        }
        this.osciH = new OsciH(Constants.HeaderTags.acceptDelivery.getElementName(), this.processCardBundle.writeToString());
        this.messageParts.add(this.osciH);
        if (this.dialogHandler.getClient().hasCipherCertificate()) {
            if (this.intermediaryCertificatesH == null) {
                this.intermediaryCertificatesH = new IntermediaryCertificatesH();
            }
            this.intermediaryCertificatesH.setCipherCertificateIntermediary((Intermed)this.dialogHandler.getClient());
        }
        this.messageParts.add(this.intermediaryCertificatesH);
        this.createNonIntermediaryCertificatesH();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.body == null) {
            this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        }
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

