/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.AcceptDelivery;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesHBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class AcceptDeliveryBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(AcceptDeliveryBuilder.class);
    private ProcessCardBundleBuilder processCardBuilder = null;
    private Boolean insideAcceptDelivery = null;

    public AcceptDeliveryBuilder(OSCIEnvelopeBuilder parentBuilder) {
        super(parentBuilder);
        this.msg = new AcceptDelivery();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            this.msg.osci2017NSPrefix = prefix;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName);
        }
        if (this.insideBody) {
            if (!ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            this.setContentPackageHandler(localName);
            return;
        } else if (this.insideHeader) {
            if (log.isDebugEnabled()) {
                log.debug("inside Header");
            }
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{0, 1, 0, 0}));
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.ClientSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.DesiredLanguages, localName, uri)) {
                this.msg.desiredLanguagesH = new DesiredLanguagesH(this, attributes.getValue("Id"), attributes.getValue("LanguagesList"));
                this.msg.desiredLanguagesH.setRefID(attributes.getValue("Id"));
                this.msg.desiredLanguagesH.setNSPrefixes(this.msg);
                this.msg.dialogHandler.setLanguageList(attributes.getValue("LanguagesList"));
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.acceptDelivery, localName, uri)) {
                this.addFoundMsgPartIds(attributes.getValue("Id"), Constants.HeaderTags.acceptDelivery.getNamespace().getUri() + ":" + Constants.HeaderTags.acceptDelivery.getElementName());
                if (this.insideAcceptDelivery != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideAcceptDelivery = true;
                return;
            } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri) && this.insideAcceptDelivery.booleanValue()) {
                int[] check = new int[]{1, 1, 0, -1};
                this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{-1, -1};
                this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.NonIntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{-1, -1, -1, -1, -1, -1, 0};
                this.parentBuilder.xmlReader.setContentHandler(new NonIntermediaryCertificatesHBuilder(this, attributes, check));
                return;
            } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                featureBuilder.startElement(uri, localName, qName, attributes);
                return;
            } else {
                this.startCustomSoapHeader(uri, localName, qName, attributes);
            }
            return;
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
            ((AcceptDelivery)this.msg).setProcessCardBundle(this.processCardBuilder.getProcessCardBundleObject());
            this.insideHeader = false;
        } else if (ParserHelper.isElement(Constants.HeaderTags.acceptDelivery, localName, uri)) {
            this.insideAcceptDelivery = false;
        } else {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

