/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.FetchRequestAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class FetchDelivery
extends FetchRequestAbstract {
    FetchDelivery() {
        this.messageType = 3;
    }

    public FetchDelivery(DialogHandler dh) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 3;
        this.originator = (Originator)dh.getClient();
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    public ResponseToFetchDelivery send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchDelivery)this.transmit(null, null);
    }

    public ResponseToFetchDelivery send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchDelivery)this.transmit(storeOutput, storeInput);
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(5, this.nonIntermediaryCertificatesH);
        this.messageParts.set(3, null);
    }

    @Override
    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.osciH = new OsciH(Constants.HeaderTags.fetchDelivery.getElementName(), this.getSelectionRuleString());
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body("");
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

