/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToFetchProcessCard;
import de.osci.osci12.roles.Originator;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class FetchProcessCard
extends OSCIRequest {
    private String selectionRule;
    private int selectionMode = -1;
    private int roleForSelection = -1;
    private boolean selectNoReceptionOnly = false;
    private long quantityLimit = -1L;

    public FetchProcessCard(DialogHandler dh) throws NoSuchAlgorithmException {
        super(dh);
        this.originator = (Originator)dh.getClient();
        this.messageType = 4;
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    FetchProcessCard() {
        this.messageType = 4;
    }

    public ResponseToFetchProcessCard send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchProcessCard)this.transmit(null, null);
    }

    public ResponseToFetchProcessCard send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchProcessCard)this.transmit(storeOutput, storeInput);
    }

    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 0 && selectionMode != 1 && selectionMode != 2 && selectionMode != -1) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + selectionMode);
        }
        this.selectionMode = selectionMode;
    }

    public void setRoleForSelection(int role) {
        if (role != 1 && role != 0 && role != -1) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + role);
        }
        this.roleForSelection = role;
    }

    public int getRoleForSelection() {
        return this.roleForSelection;
    }

    public void setSelectNoReceptionOnly(boolean noReceptionOnly) {
        this.selectNoReceptionOnly = noReceptionOnly;
    }

    public boolean isSelectNoReception() {
        return this.selectNoReceptionOnly;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public long getQuantityLimit() {
        return this.quantityLimit;
    }

    public void setQuantityLimit(long quantityLimit) {
        if (quantityLimit <= 0L) {
            throw new IllegalArgumentException("Limit f\u00fcr die Zahl der Laufzettel muss gr\u00f6\u00dfer 0 sein.");
        }
        this.quantityLimit = quantityLimit;
    }

    @Override
    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.compose();
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        Object selectionAttributes = "";
        if (this.selectNoReceptionOnly) {
            selectionAttributes = (String)selectionAttributes + " NoReception=\"true\"";
        }
        if (this.roleForSelection == 0) {
            selectionAttributes = (String)selectionAttributes + " Role=\"Addressee\"";
        } else if (this.roleForSelection == 1) {
            selectionAttributes = (String)selectionAttributes + " Role=\"Originator\"";
        }
        StringBuffer selection = new StringBuffer("<");
        selection.append(this.osciNSPrefix);
        selection.append(":SelectionRule>");
        if (this.selectionMode == 0) {
            String[] msgIds = this.selectionRule.split(";");
            for (int i = 0; i < msgIds.length; ++i) {
                selection.append("<");
                selection.append(this.osciNSPrefix);
                selection.append(":MessageId>");
                selection.append(Base64.encode(msgIds[i].getBytes(Constants.CHARSET_ENCODING)));
                selection.append("</");
                selection.append(this.osciNSPrefix);
                selection.append(":MessageId>");
            }
            selection.append("</");
        } else if (this.selectionMode == 1) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":ReceptionOfDelivery" + (String)selectionAttributes + ">" + this.selectionRule + "</");
            selection.append(this.osciNSPrefix);
            selection.append(":ReceptionOfDelivery></");
        } else if (this.selectionMode == 2) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":RecentModification" + (String)selectionAttributes + ">" + this.selectionRule + "</");
            selection.append(this.osciNSPrefix);
            selection.append(":RecentModification></");
        } else {
            selection.delete(0, selection.length());
        }
        if (selection.length() > 0) {
            selection.append(this.osciNSPrefix);
            selection.append(":SelectionRule>");
        }
        if (this.quantityLimit >= 0L) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":Quantity Limit=\"" + this.quantityLimit + "\"></");
            selection.append(this.osciNSPrefix);
            selection.append(":Quantity>");
        }
        this.body = new Body("<" + this.osciNSPrefix + ":fetchProcessCard>" + selection + "</" + this.osciNSPrefix + ":fetchProcessCard>");
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

