/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messagetypes.OSCIRequest;
import java.io.IOException;

public class FetchRequestAbstract
extends OSCIRequest {
    private String selectionRule = null;
    private int selectionMode = -1;

    FetchRequestAbstract() {
    }

    public FetchRequestAbstract(DialogHandler dh) {
        super(dh);
    }

    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 0 && selectionMode != 1 && selectionMode != -1) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + selectionMode);
        }
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    protected String getSelectionRuleString() throws IOException {
        if (this.getSelectionMode() == 0 || this.getSelectionMode() == 1) {
            if (this.getSelectionRule() == null) {
                throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SelectionRule");
            }
            StringBuilder selectionBuilder = new StringBuilder("<");
            selectionBuilder.append(this.osciNSPrefix);
            selectionBuilder.append(":SelectionRule><");
            selectionBuilder.append(this.osciNSPrefix);
            if (this.getSelectionMode() == 0) {
                selectionBuilder.append(":MessageId>");
                selectionBuilder.append(Base64.encode(this.getSelectionRule().getBytes(Constants.CHARSET_ENCODING)));
                selectionBuilder.append("</");
                selectionBuilder.append(this.osciNSPrefix);
                selectionBuilder.append(":MessageId></");
            } else {
                selectionBuilder.append(":ReceptionOfDelivery>");
                selectionBuilder.append(this.getSelectionRule());
                selectionBuilder.append("</");
                selectionBuilder.append(this.osciNSPrefix);
                selectionBuilder.append(":ReceptionOfDelivery></");
            }
            selectionBuilder.append(this.osciNSPrefix);
            selectionBuilder.append(":SelectionRule>");
            return selectionBuilder.toString();
        }
        return "";
    }
}

