/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesH;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class GetMessageId
extends OSCIRequest {
    public GetMessageId(DialogHandler dh) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 6;
        this.originator = (Originator)dh.getClient();
        if (!this.dialogHandler.isExplicitDialog()) {
            this.dialogHandler.resetControlBlock();
        }
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    GetMessageId() {
        this.messageType = 6;
    }

    public ResponseToGetMessageId send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToGetMessageId)this.transmit(null, null);
    }

    @Override
    protected void compose() throws OSCIException, NoSuchAlgorithmException, IOException {
        if (this.dialogHandler.getClient().hasCipherCertificate()) {
            if (this.nonIntermediaryCertificatesH == null) {
                this.nonIntermediaryCertificatesH = new NonIntermediaryCertificatesH();
            }
            this.nonIntermediaryCertificatesH.setCipherCertificateOriginator((Originator)this.dialogHandler.getClient());
        }
        super.compose();
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.body = new Body("<" + this.osciNSPrefix + ":getMessageId></" + this.osciNSPrefix + ":getMessageId>");
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

