/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToMediateDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import de.osci.osci12.soapheader.QualityOfTimestampH;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;

public class MediateDelivery
extends OSCIRequest
implements ContentPackageI {
    private String subject;

    public MediateDelivery(DialogHandler dh, Addressee addressee, String uriReceiver) throws URISyntaxException, NoSuchAlgorithmException {
        super(dh);
        this.messageType = 8;
        this.originator = (Originator)dh.getClient();
        this.addressee = addressee;
        this.uriReceiver = new URI(uriReceiver);
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
        this.setQualityOfTimeStampCreation(false);
        this.setQualityOfTimeStampReception(false);
    }

    MediateDelivery() {
        this.messageType = 8;
    }

    public ResponseToMediateDelivery send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToMediateDelivery)this.transmit(null, null);
    }

    public ResponseToMediateDelivery send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToMediateDelivery)this.transmit(storeOutput, storeInput);
    }

    @Override
    public void addContentContainer(ContentContainer container) throws OSCIRoleException {
        super.addContentContainer(container);
    }

    @Override
    public void removeContentContainer(ContentContainer container) {
        super.removeContentContainer(container);
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public void addEncryptedData(EncryptedDataOSCI encData) throws OSCIRoleException {
        super.addEncryptedData(encData);
    }

    @Override
    public void removeEncryptedData(EncryptedDataOSCI encData) {
        super.removeEncryptedData(encData);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addCustomHeaderExtention(CustomHeaderExtention extention) {
        super.addCustomHeaderExtention(extention);
    }

    @Override
    public CustomHeaderExtention getCustomHeader(CustomHeaderExtention ext) throws IOException {
        return super.getCustomHeader(ext);
    }

    public void setQualityOfTimeStampCreation(boolean cryptographic) {
        this.qualityOfTimestampTypeCreation = new QualityOfTimestampH(false, cryptographic);
    }

    public boolean getQualityOfTimeStampCreation() {
        return this.qualityOfTimestampTypeCreation.isQualityCryptographic();
    }

    public void setQualityOfTimeStampReception(boolean cryptographic) {
        this.qualityOfTimestampTypeReception = new QualityOfTimestampH(true, cryptographic);
    }

    public boolean getQualityOfTimeStampReception() {
        return this.qualityOfTimestampTypeReception.isQualityCryptographic();
    }

    public String getContentReceiver() {
        return this.uriReceiver.toString();
    }

    public void setContentReceiver(String uri) throws URISyntaxException {
        this.uriReceiver = new URI(uri);
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(3, null);
        this.messageParts.set(7, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.importAllCertificates();
        this.createNonIntermediaryCertificatesH();
        if (this.uriReceiver == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": URI - contentReceiver");
        }
        String head = "<" + this.osciNSPrefix + ":ContentReceiver URI=\"" + this.uriReceiver.toString() + "\"></" + this.osciNSPrefix + ":ContentReceiver>";
        if (this.messageId != null) {
            head = head + "<" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId>";
            if (this.subject != null) {
                head = head + "<" + this.osciNSPrefix + ":Subject>" + this.subject + "</" + this.osciNSPrefix + ":Subject>";
            }
        } else {
            this.qualityOfTimestampTypeCreation = null;
            this.qualityOfTimestampTypeReception = null;
        }
        this.messageParts.add(this.qualityOfTimestampTypeCreation);
        this.messageParts.add(this.qualityOfTimestampTypeReception);
        this.osciH = new OsciH(Constants.HeaderTags.mediateDelivery.getElementName(), head);
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

