/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.signature.OSCISignatureException;
import de.osci.osci12.soapheader.ControlBlockH;
import de.osci.osci12.soapheader.CustomHeader;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.FeatureDescriptionH;
import de.osci.osci12.soapheader.IntermediaryCertificatesH;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesH;
import de.osci.osci12.soapheader.OsciH;
import de.osci.osci12.soapheader.QualityOfTimestampH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

public abstract class OSCIMessage {
    private static Logger log = LoggerFactory.getLogger(OSCIMessage.class);
    public Hashtable<String, byte[]> hashableMsgPart;
    public Hashtable<String, String> parsedMsgPartsIds;
    private String digestAlgorithm = DialogHandler.getDigestAlgorithm();
    private static final String INCOMPATIBLE_ROLE_ERROR = "incompatible_role_error";
    public static final int TYPE_UNDEFINED = 0;
    public static final int ACCEPT_DELIVERY = 1;
    public static final int EXIT_DIALOG = 2;
    public static final int FETCH_DELIVERY = 3;
    public static final int PARTIAL_FETCH_DELIVERY = 50;
    public static final int FETCH_PROCESS_CARD = 4;
    public static final int FORWARD_DELIVERY = 5;
    public static final int GET_MESSAGE_ID = 6;
    public static final int INIT_DIALOG = 7;
    public static final int MEDIATE_DELIVERY = 8;
    public static final int PROCESS_DELIVERY = 9;
    public static final int STORE_DELIVERY = 10;
    public static final int PARTIAL_STORE_DELIVERY = 11;
    public static final int RESPONSE_TO_ACCEPT_DELIVERY = 16;
    public static final int RESPONSE_TO_EXIT_DIALOG = 32;
    public static final int RESPONSE_TO_FETCH_DELIVERY = 48;
    public static final int RESPONSE_TO_PARTIAL_FETCH_DELIVERY = 49;
    public static final int RESPONSE_TO_FETCH_PROCESS_CARD = 64;
    public static final int RESPONSE_TO_FORWARD_DELIVERY = 80;
    public static final int RESPONSE_TO_GET_MESSAGE_ID = 96;
    public static final int RESPONSE_TO_INIT_DIALOG = 112;
    public static final int RESPONSE_TO_MEDIATE_DELIVERY = 128;
    public static final int RESPONSE_TO_PROCESS_DELIVERY = 144;
    public static final int RESPONSE_TO_STORE_DELIVERY = 160;
    public static final int RESPONSE_TO_PARTIAL_STORE_DELIVERY = 161;
    public static final int SOAP_MESSAGE_ENCRYPTED = 256;
    public static final int SOAP_FAULT_MESSAGE = 176;
    public static final int NO_SELECTION_RULE = -1;
    public static final int SELECT_BY_MESSAGE_ID = 0;
    public static final int SELECT_BY_DATE_OF_RECEPTION = 1;
    public static final int SELECT_BY_RECENT_MODIFICATION = 2;
    public static final int SELECT_ALL = -1;
    public static final int SELECT_ADDRESSEE = 0;
    public static final int SELECT_ORIGINATOR = 1;
    protected String messageId;
    public static final String contentID = "osci@message";
    protected Originator originator;
    protected Addressee addressee;
    Hashtable<String, Author> otherAutors = new Hashtable();
    Hashtable<String, Reader> otherReaders = new Hashtable();
    public Hashtable<String, ContentContainer> contentContainer = new Hashtable();
    public Hashtable<String, EncryptedDataOSCI> encryptedData = new Hashtable();
    public Hashtable<String, Attachment> attachments = new Hashtable();
    protected XMLReader xmlReader = null;
    protected String currentElement;
    protected Hashtable<String, String> xmlns = new Hashtable();
    protected int messageType = 0;
    public OSCISignature signatureHeader;
    public DesiredLanguagesH desiredLanguagesH;
    public QualityOfTimestampH qualityOfTimestampTypeCreation;
    public QualityOfTimestampH qualityOfTimestampTypeReception;
    OsciH osciH;
    public NonIntermediaryCertificatesH nonIntermediaryCertificatesH;
    public IntermediaryCertificatesH intermediaryCertificatesH;
    public ControlBlockH controlBlock;
    Body body = null;
    public DialogHandler dialogHandler;
    X509Certificate signerCert;
    int stateOfMsg = 0;
    protected static final int STATE_COMPOSED = 1;
    protected static final int STATE_SIGNED = 2;
    protected static final int STATE_PARSED = 4;
    protected Vector<CustomHeader> customHeaders = new Vector();
    public String soapNSPrefix = Constants.Namespaces.SOAP.getPrefix();
    public String osciNSPrefix = Constants.Namespaces.OSCI.getPrefix();
    public String osci2017NSPrefix = Constants.Namespaces.OSCI2017.getPrefix();
    public String osci2019NSPrefix = Constants.Namespaces.OSCI128.getPrefix();
    public String dsNSPrefix = Constants.Namespaces.XML_SIG.getPrefix();
    public String xencNSPrefix = Constants.Namespaces.XML_ENC.getPrefix();
    public String xsiNSPrefix = Constants.Namespaces.XML_SCHEMA.getPrefix();
    public String ns = " xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    protected String boundaryString;
    protected boolean base64 = false;
    protected Vector<MessagePart> messageParts = new Vector();
    protected FeatureDescriptionH featureDescription = null;

    protected OSCIMessage() {
    }

    protected OSCIMessage(DialogHandler dh) {
        this.dialogHandler = dh;
    }

    public boolean hasWeakSignature(Date date) throws OSCIRoleException {
        if (this.signatureHeader == null) {
            throw new IllegalStateException("Message is not signed.");
        }
        if (this.signerCert == null) {
            throw new IllegalStateException("Role object referenced in signature not found.");
        }
        if (date == null) {
            date = Constants.ACTUAL_DATE;
        }
        if (Crypto.isWeak(date, this.signerCert)) {
            return true;
        }
        if (Constants.OUT_DATES.containsKey(this.signatureHeader.signatureAlgorithm) && !date.before(Constants.OUT_DATES.get(this.signatureHeader.signatureAlgorithm))) {
            return true;
        }
        String[] digMeths = this.signatureHeader.getDigestMethods().values().toArray(new String[0]);
        for (int i = 0; i < digMeths.length; ++i) {
            if (!Constants.OUT_DATES.containsKey(digMeths[i]) || date.before(Constants.OUT_DATES.get(digMeths[i]))) continue;
            return true;
        }
        return false;
    }

    public boolean isSigned() {
        return this.signatureHeader != null;
    }

    public void addRole(Role role) throws IllegalArgumentException {
        if (role instanceof Originator) {
            this.originator = (Originator)role;
        } else if (role instanceof Addressee) {
            this.addressee = (Addressee)role;
        } else if (role instanceof Author && !this.otherAutors.containsValue(role)) {
            if (this.otherAutors.containsKey(role.id)) {
                role.cipherRefId = role.getCipherCertificateId();
                role.signatureRefId = role.getSignatureCertificateId();
                role.id = role.id + "0";
            }
            this.otherAutors.put(role.id, (Author)role);
        } else if (role instanceof Reader && !this.otherReaders.containsValue(role)) {
            if (this.otherReaders.containsKey(role.id)) {
                role.cipherRefId = role.getCipherCertificateId();
                role.id = role.id + "0";
            }
            this.otherReaders.put(role.id, (Reader)role);
        }
    }

    public void addReadersAndAuthors(NonIntermediaryCertificatesH nonIntermediaryCertificates) {
        for (Reader reader : nonIntermediaryCertificates.getCipherCertificatesOtherReaders()) {
            if (log.isDebugEnabled()) {
                log.debug("Ein weiteres Leser-Verschl\u00fcsselungs-Objekt wird der Nachricht hinzugef\u00fcgt.");
            }
            this.addRole(reader);
        }
        for (Role role : nonIntermediaryCertificates.getSignatureCertificatesOtherAuthors()) {
            if (log.isDebugEnabled()) {
                log.debug("Ein weiteres Autor-Signatur-Objekt wird der Nachricht hinzugef\u00fcgt.");
            }
            this.addRole(role);
        }
        for (Role role : nonIntermediaryCertificates.getCipherCertificatesOtherAuthors()) {
            if (log.isDebugEnabled()) {
                log.debug("Ein weiteres Autor-Verschl\u00fcsselungs-Objekt wird der Nachricht hinzugef\u00fcgt.");
            }
            this.addRole(role);
        }
    }

    void addContentContainer(ContentContainer container) throws OSCIRoleException {
        Attachment[] atts;
        if (log.isDebugEnabled()) {
            log.debug("ContentContainer wird hinzugef\u00fcgt.");
        }
        this.contentContainer.put(container.getRefID(), container);
        Role[] roles = container.getRoles();
        for (int i = 0; i < roles.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Ein weiteres Role-Objekt wird der Nachricht hinzugef\u00fcgt.");
            }
            if (roles[i] instanceof Originator) {
                if (this.originator != null && this.originator != roles[i]) {
                    throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Originator");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Eine Originator wird hinzugef\u00fcgt.");
                }
                this.originator = (Originator)roles[i];
            } else if (roles[i] instanceof Addressee) {
                if (this.addressee != null && this.addressee != roles[i]) {
                    throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Addressee");
                }
                this.addressee = (Addressee)roles[i];
                if (!log.isDebugEnabled()) break;
                log.debug("Eine Addressee wird hinzugef\u00fcgt.");
                break;
            }
            if (roles[i] instanceof Author) {
                if (log.isDebugEnabled()) {
                    log.debug("Eine Author wird hinzugef\u00fcgt.\n" + roles[i].id + "\n" + roles[i].getSignatureCertificateId());
                }
                this.addRole(roles[i]);
            }
            if (!(roles[i] instanceof Reader)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Eine Reader wird hinzugef\u00fcgt.");
            }
            this.addRole(roles[i]);
        }
        if ((atts = container.getAttachments()) != null && atts.length > 0) {
            for (int i = 0; i < atts.length; ++i) {
                this.addAttachment(atts[i]);
            }
        }
    }

    void addCustomHeaderExtention(CustomHeaderExtention extention) {
        this.addCustomHeader(extention.getOutgoingHeader());
    }

    CustomHeaderExtention getCustomHeader(CustomHeaderExtention ext) throws IOException {
        for (CustomHeader customHeader : this.customHeaders) {
            if (!ext.getCustomHeaderRefID().equals(customHeader.getRefID())) continue;
            log.debug("Found MessageMetaData-CustomHeader");
            return ext.parseIncomingHeader(customHeader.getData());
        }
        return null;
    }

    void removeContentContainer(ContentContainer container) {
        this.contentContainer.remove(container.getRefID());
    }

    ContentContainer[] getContentContainer() {
        return this.contentContainer.values().toArray(new ContentContainer[0]);
    }

    protected ContentContainer getContentContainerByRefID(String refID) {
        ContentContainer[] containers = this.getContentContainer();
        MessagePart ret = null;
        for (int i = 0; i < containers.length; ++i) {
            ret = this.searchMessagePart(containers[i], refID);
            if (ret == null) continue;
            if (ret instanceof ContentContainer) {
                return (ContentContainer)ret;
            }
            log.info("RefID " + refID + " does not refer to a ContentContainer.");
            return null;
        }
        log.info("RefID " + refID + " not found.");
        return null;
    }

    public Content getContentByRefID(String refID) {
        ContentContainer[] containers = this.getContentContainer();
        MessagePart ret = null;
        for (int i = 0; i < containers.length; ++i) {
            ret = this.searchMessagePart(containers[i], refID);
            if (ret == null) continue;
            if (ret instanceof Content) {
                return (Content)ret;
            }
            log.info("RefID " + refID + " does not refer to a Content.");
            return null;
        }
        log.info("RefID " + refID + " not found.");
        return null;
    }

    public FeatureDescriptionH getFeatureDescription() {
        return this.featureDescription;
    }

    public void setFeatureDescription(FeatureDescriptionH featureDescription) {
        this.featureDescription = featureDescription;
    }

    private MessagePart searchMessagePart(ContentContainer cnt, String refID) {
        if (cnt.getRefID().equals(refID)) {
            return cnt;
        }
        Content[] contents = cnt.getContents();
        for (int i = 0; i < contents.length; ++i) {
            MessagePart mp;
            if (contents[i].getRefID().equals(refID)) {
                return contents[i];
            }
            if (contents[i].getContentType() != 1 || (mp = this.searchMessagePart(contents[i].getContentContainer(), refID)) == null) continue;
            return mp;
        }
        return null;
    }

    void addEncryptedData(EncryptedDataOSCI encData) throws OSCIRoleException {
        if (encData.getRefID() == null || encData.getRefID().equals("")) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + " refId");
        }
        this.encryptedData.put(encData.getRefID(), encData);
        Role[] roles = encData.getRoles();
        for (int i = 0; i < roles.length; ++i) {
            if (roles[i] instanceof Originator) {
                if (this.originator != null && this.originator != roles[i]) {
                    throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Originator");
                }
                this.originator = (Originator)roles[i];
            } else if (roles[i] instanceof Addressee) {
                if (this.addressee != null && this.addressee != roles[i]) {
                    throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Addressee");
                }
                this.addressee = (Addressee)roles[i];
            }
            if (roles[i] instanceof Author) {
                this.addRole(roles[i]);
            }
            if (!(roles[i] instanceof Reader)) continue;
            this.addRole(roles[i]);
        }
        Attachment[] atts = encData.getAttachments();
        for (int i = 0; i < atts.length; ++i) {
            this.addAttachment(atts[i]);
        }
    }

    void removeEncryptedData(EncryptedDataOSCI encData) {
        this.encryptedData.remove(encData.getRefID());
    }

    EncryptedDataOSCI[] getEncryptedData() {
        return this.encryptedData.values().toArray(new EncryptedDataOSCI[0]);
    }

    void addAttachment(Attachment attachment) {
        if (attachment == null) {
            log.debug("Attachment to add is null!");
            return;
        }
        log.debug("Add attachment to msg: " + attachment.getRefID());
        this.attachments.put(attachment.getRefID(), attachment);
        if (this.boundaryString != null) {
            attachment.setBoundary(this.boundaryString);
        }
    }

    void removeAttachment(Attachment attachment) {
        this.attachments.remove(attachment.getRefID());
    }

    Attachment[] getAttachments() {
        return this.attachments.values().toArray(new Attachment[0]);
    }

    private boolean cmpRoles(Role org, Role next) {
        try {
            if (org.hasCipherCertificate()) {
                if (next.hasCipherCertificate() && !org.getCipherCertificate().equals(next.getCipherCertificate())) {
                    return false;
                }
            } else if (next.hasCipherCertificate()) {
                org.setCipherCertificate(next.getCipherCertificate());
            }
            if (org.hasSignatureCertificate()) {
                if (next.hasSignatureCertificate() && !org.getSignatureCertificate().equals(next.getSignatureCertificate())) {
                    return false;
                }
            } else if (next.hasSignatureCertificate()) {
                org.setSignatureCertificate(next.getSignatureCertificate());
            }
            return true;
        }
        catch (OSCIRoleException ex) {
            return false;
        }
    }

    private void importCertificates(Role[] roles) throws OSCIRoleException {
        for (int i = 0; i < roles.length; ++i) {
            if (roles[i] instanceof Originator && this.originator != null && !this.cmpRoles(this.originator, roles[i])) {
                throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Originator");
            }
            if (roles[i] instanceof Addressee && this.addressee != null && !this.cmpRoles(this.addressee, roles[i])) {
                throw new OSCIRoleException(INCOMPATIBLE_ROLE_ERROR, "Addressee");
            }
            if (roles[i] instanceof Reader) {
                this.addRole(roles[i]);
                continue;
            }
            if (!(roles[i] instanceof Author)) continue;
            this.addRole(roles[i]);
        }
    }

    protected void collectCertificatesFromContentContainer(ContentContainer coco) throws OSCIRoleException {
        this.importCertificates(coco.getRoles());
        Content[] cnt = coco.getContents();
        for (int i = 0; i < cnt.length; ++i) {
            if (cnt[i].getContentType() != 1) continue;
            this.collectCertificatesFromContentContainer(cnt[i].getContentContainer());
        }
        EncryptedDataOSCI[] enc = coco.getEncryptedData();
        for (int i = 0; i < enc.length; ++i) {
            this.importCertificates(enc[i].getRoles());
        }
    }

    protected void importAllCertificates() throws OSCIRoleException {
        for (ContentContainer coco : this.contentContainer.values()) {
            this.collectCertificatesFromContentContainer(coco);
        }
        for (EncryptedDataOSCI data : this.encryptedData.values()) {
            this.importCertificates(data.getRoles());
        }
    }

    public void setDigestAlgorithm(String _digestAlgorithm) {
        if (this.isSigned()) {
            throw new IllegalStateException("Message is already signed.");
        }
        this.digestAlgorithm = _digestAlgorithm;
    }

    protected void sign(Role role) throws IOException, OSCIException, NoSuchAlgorithmException {
        if ((this.stateOfMsg & 1) == 0) {
            this.compose();
        }
        Object name = "";
        name = this instanceof OSCIRequest ? "<" + this.osciNSPrefix + ":ClientSignature Id=\"clientsignature\" " + this.soapNSPrefix + ":actor=\"http://schemas.xmlsoap.org/soap/actor/next\" " + this.soapNSPrefix + ":mustUnderstand=\"1\">" : "<" + this.osciNSPrefix + ":SupplierSignature Id=\"suppliersignature\" " + this.soapNSPrefix + ":actor=\"http://schemas.xmlsoap.org/soap/actor/next\" " + this.soapNSPrefix + ":mustUnderstand=\"1\">";
        this.signatureHeader = MessagePartsFactory.createOSCISignature((String)name);
        this.signatureHeader.setNSPrefixes(this);
        this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.dialogHandler.getControlblock(), this.digestAlgorithm));
        if (this.desiredLanguagesH != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.desiredLanguagesH, this.digestAlgorithm));
        }
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.featureDescription, this.digestAlgorithm));
        }
        if (this.qualityOfTimestampTypeCreation != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.qualityOfTimestampTypeCreation, this.digestAlgorithm));
        }
        if (this.qualityOfTimestampTypeReception != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.qualityOfTimestampTypeReception, this.digestAlgorithm));
        }
        if (this.osciH != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.osciH, this.digestAlgorithm));
        }
        for (int i = 0; i < this.customHeaders.size(); ++i) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.customHeaders.get(i), this.digestAlgorithm));
        }
        if (this.attachments.size() > 0) {
            Enumeration<Attachment> atts = this.attachments.elements();
            byte[] tmp = null;
            while (atts.hasMoreElements()) {
                Attachment att = atts.nextElement();
                tmp = null;
                if (att.hasDigestValue(this.digestAlgorithm)) {
                    tmp = att.getDigestValue(this.digestAlgorithm);
                }
                MessagePartsFactory.setDigestValue(att, att.getEncryptedDigestValue(this.digestAlgorithm), this.digestAlgorithm);
                this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(att, this.digestAlgorithm));
                if (tmp == null) continue;
                MessagePartsFactory.setDigestValue(att, tmp, this.digestAlgorithm);
            }
        }
        if (role instanceof Intermed) {
            if (this.intermediaryCertificatesH == null) {
                this.intermediaryCertificatesH = new IntermediaryCertificatesH();
            }
            this.intermediaryCertificatesH.setSignatureCertificateIntermediary((Intermed)role);
        } else {
            if (this.nonIntermediaryCertificatesH == null) {
                this.nonIntermediaryCertificatesH = new NonIntermediaryCertificatesH();
            }
            if (role instanceof Originator) {
                this.nonIntermediaryCertificatesH.setSignatureCertificateOriginator((Originator)role);
            } else {
                this.nonIntermediaryCertificatesH.setSignatureCertificateAddressee((Addressee)role);
            }
        }
        if (this.intermediaryCertificatesH != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.intermediaryCertificatesH, this.digestAlgorithm));
        }
        if (this.nonIntermediaryCertificatesH != null) {
            this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.nonIntermediaryCertificatesH, this.digestAlgorithm));
        }
        this.signatureHeader.addSignatureReference(MessagePartsFactory.createOSCISignatureReference(this.body, this.digestAlgorithm));
        try {
            this.signatureHeader.sign(role);
        }
        catch (SignatureException ex) {
            log.warn("Error:", (Throwable)ex);
            throw new OSCISignatureException("signature_creation_failed");
        }
        this.messageParts.set(1, this.signatureHeader);
    }

    protected void createNonIntermediaryCertificatesH() throws OSCIRoleException {
        Vector<Role> v;
        if ((this.stateOfMsg & 4) != 0) {
            return;
        }
        boolean empty = true;
        if (this.nonIntermediaryCertificatesH == null) {
            this.nonIntermediaryCertificatesH = new NonIntermediaryCertificatesH();
        } else {
            empty = false;
        }
        if (this.originator != null) {
            if (this.originator.hasSignatureCertificate()) {
                this.nonIntermediaryCertificatesH.setSignatureCertificateOriginator(this.originator);
                empty = false;
            } else {
                log.info("Kein Originator-Signaturzertifikat gefunden");
            }
            if (this.originator.hasCipherCertificate()) {
                this.nonIntermediaryCertificatesH.setCipherCertificateOriginator(this.originator);
                empty = false;
            } else {
                log.info("Kein Originator-Verschl\u00fcsselungszertifikat gefunden");
            }
        }
        if (!(v = this.searchCertificates(false, this.getOtherAuthors())).isEmpty()) {
            empty = false;
        }
        this.nonIntermediaryCertificatesH.setCipherCertificatesOtherAuthors(v.toArray(new Author[v.size()]));
        if (this.addressee != null) {
            if (this.addressee.hasCipherCertificate()) {
                this.nonIntermediaryCertificatesH.setCipherCertificateAddressee(this.addressee);
                empty = false;
            } else {
                log.info("Kein Addressee-Verschl\u00fcsselungszertifikat gefunden");
            }
        }
        if (!(v = this.searchCertificates(false, this.getOtherReaders())).isEmpty()) {
            empty = false;
        }
        this.nonIntermediaryCertificatesH.setCipherCertificatesOtherReaders(v.toArray(new Reader[v.size()]));
        v = this.searchCertificates(true, this.getOtherAuthors());
        if (!v.isEmpty()) {
            empty = false;
        }
        this.nonIntermediaryCertificatesH.setSignatureCertificatesOtherAuthors(v.toArray(new Author[v.size()]));
        if (empty) {
            this.nonIntermediaryCertificatesH = null;
        }
    }

    private Vector<Role> searchCertificates(boolean signature, Role[] roles) {
        Vector<Role> v = new Vector<Role>();
        for (int i = 0; i < roles.length; ++i) {
            if ((!signature || !roles[i].hasSignatureCertificate()) && (signature || !roles[i].hasCipherCertificate())) continue;
            v.add(roles[i]);
        }
        return v;
    }

    void setDialogHandler(DialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    public DialogHandler getDialogHandler() {
        return this.dialogHandler;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Role getRoleForRefID(String refId) {
        for (Author author : this.otherAutors.values()) {
            if (!this.checkRole(refId, author)) continue;
            return author;
        }
        for (Reader reader : this.otherReaders.values()) {
            if (!this.checkRole(refId, reader)) continue;
            return reader;
        }
        if (this.checkRole(refId, this.getOriginator())) {
            return this.getOriginator();
        }
        if (this.checkRole(refId, this.getAddressee())) {
            return this.getAddressee();
        }
        if (this.checkRole(refId, this.dialogHandler.getSupplier())) {
            return this.dialogHandler.getSupplier();
        }
        if (this.checkRole(refId, this.dialogHandler.getClient())) {
            return this.dialogHandler.getClient();
        }
        return null;
    }

    private boolean checkRole(String uri, Role role) {
        try {
            if (uri.equals(role.getCipherCertificateId()) || uri.equals(role.getSignatureCertificateId())) {
                return true;
            }
        }
        catch (NullPointerException ex) {
            log.trace(String.valueOf(ex));
        }
        return false;
    }

    public Addressee getAddressee() {
        return this.addressee;
    }

    void setAddressee(Addressee addressee) {
        this.addressee = addressee;
    }

    public Originator getOriginator() {
        return this.originator;
    }

    void setOriginator(Originator originator) {
        this.originator = originator;
    }

    public Author[] getOtherAuthors() {
        return this.otherAutors.values().toArray(new Author[0]);
    }

    public Reader[] getOtherReaders() {
        return this.otherReaders.values().toArray(new Reader[0]);
    }

    public void addCustomHeader(String xml) {
        if (log.isDebugEnabled()) {
            log.debug("Custom-Header: " + xml);
        }
        this.customHeaders.add(new CustomHeader(xml));
    }

    public void addCustomHeader(String xml, boolean makeOsciStructure) {
        if (!makeOsciStructure) {
            this.addCustomHeader(xml);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Custom-Header vor Kanonisierung: " + xml);
            }
            CustomHeader canonizedHeader = new CustomHeader(CustomHeaderExtention.makeOSCICustomHeader(xml));
            if (log.isDebugEnabled()) {
                log.debug("Custom-Header nach Kanonisierung: " + canonizedHeader.getData());
            }
            this.customHeaders.add(canonizedHeader);
        }
    }

    public String[] getCustomHeaders() {
        String[] headers = new String[this.customHeaders.size()];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.customHeaders.get(i).getData();
        }
        return headers;
    }

    public static String formatISO8601(Date date) {
        Instant instant = date.toInstant();
        return date != null ? DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(instant.atOffset(ZoneId.systemDefault().getRules().getOffset(instant))) : null;
    }

    public static Date parseISO8601(String date) {
        return date != null ? Date.from(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date))) : null;
    }

    public void setBase64Encoding(boolean b64) {
        this.base64 = b64;
    }

    public boolean getBase64Encoding() {
        return this.base64;
    }

    protected long calcLength() throws IOException, OSCIException, NoSuchAlgorithmException {
        if ((this.stateOfMsg & 1) == 0) {
            this.compose();
        }
        long len = 431L;
        len += (long)((this.attachments.keySet().size() + 3) * this.boundaryString.getBytes(Constants.CHARSET_ENCODING).length);
        len += (long)contentID.getBytes(Constants.CHARSET_ENCODING).length;
        len += (long)(4 * this.soapNSPrefix.getBytes(Constants.CHARSET_ENCODING).length);
        len += (long)this.ns.getBytes(Constants.CHARSET_ENCODING).length;
        len += (long)this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1).getBytes(Constants.CHARSET_ENCODING).length;
        for (Attachment att : this.attachments.values()) {
            len += 87L;
            len += (long)att.getContentType().getBytes(Constants.CHARSET_ENCODING).length;
            len += (long)att.getRefID().getBytes(Constants.CHARSET_ENCODING).length;
            len += att.getLength();
            len += (long)Long.toString(att.getLength()).getBytes(Constants.CHARSET_ENCODING).length;
            len += (long)(MessagePartsFactory.attachmentIsBase64(att) ? 6 : 5);
        }
        for (int i = 0; i < this.messageParts.size(); ++i) {
            if (this.messageParts.get(i) == null) continue;
            len += this.messageParts.get(i).getLength();
        }
        log.debug("Laenge der Nachricht: " + len);
        return len;
    }

    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        if (this.boundaryString == null) {
            this.boundaryString = DialogHandler.boundary + "_" + Tools.createRandom(24);
        }
        this.messageParts.clear();
        if (this.controlBlock != null) {
            this.messageParts.add(this.controlBlock);
        } else {
            this.messageParts.add(this.dialogHandler.getControlblock());
        }
        this.messageParts.add(this.signatureHeader);
        for (Attachment att : this.attachments.values()) {
            att.setBoundary(this.boundaryString);
        }
    }

    void writeXML(OutputStream out) throws IOException, OSCIException, NoSuchAlgorithmException {
        if ((this.stateOfMsg & 1) == 0) {
            this.compose();
        }
        out.write(("MIME-Version: 1.0\r\nContent-Type: Multipart/Related; boundary=" + this.boundaryString + "; type=text/xml\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write(("\r\n--" + this.boundaryString + "\r\nContent-Type: text/xml; charset=UTF-8\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write("Content-Transfer-Encoding: 8bit\r\nContent-ID: <osci@message>\r\n\r\n".getBytes(Constants.CHARSET_ENCODING));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<".getBytes(Constants.CHARSET_ENCODING));
        out.write(this.soapNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        out.write(":Envelope".getBytes(Constants.CHARSET_ENCODING));
        out.write(this.ns.getBytes(Constants.CHARSET_ENCODING));
        out.write(" xsi:schemaLocation=\"http://schemas.xmlsoap.org/soap/envelope/ soap".getBytes(Constants.CHARSET_ENCODING));
        out.write((this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + ".xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd\"><").getBytes(Constants.CHARSET_ENCODING));
        out.write(this.soapNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        out.write(":Header>".getBytes(Constants.CHARSET_ENCODING));
        for (int i = 0; i < this.messageParts.size() - 1; ++i) {
            if (this.messageParts.get(i) == null) continue;
            MessagePartsFactory.writeXML(this.messageParts.get(i), out);
        }
        out.write(("</" + this.soapNSPrefix + ":Header>").getBytes(Constants.CHARSET_ENCODING));
        MessagePartsFactory.writeXML((Body)this.messageParts.lastElement(), out);
        out.write(("</" + this.soapNSPrefix + ":Envelope>").getBytes(Constants.CHARSET_ENCODING));
        for (Attachment att : this.attachments.values()) {
            MessagePartsFactory.writeXML(att, out);
        }
        out.write(("\r\n--" + this.boundaryString + "--\r\n").getBytes(Constants.CHARSET_ENCODING));
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeXML(out);
            out.close();
            return new String(out.toByteArray(), Constants.CHARSET_ENCODING);
        }
        catch (Exception ex) {
            log.trace(String.valueOf(ex));
            return "";
        }
    }
}

