/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.CanParser;
import de.osci.helper.Canonizer;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessage;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OSCIMessageBuilder
extends DefaultHandler {
    public static final String SOAP_XMLNS = Constants.Namespaces.SOAP.getUri();
    public static final String OSCI_XMLNS = Constants.Namespaces.OSCI.getUri();
    public static final String OSCI_2019_XMLNS = Constants.Namespaces.OSCI128.getUri();
    public static final String DS_XMLNS = Constants.Namespaces.XML_SIG.getUri();
    public static final String XENC_XMLNS = Constants.Namespaces.XML_ENC.getUri();
    public static final String XSI_XMLNS = Constants.Namespaces.XML_SCHEMA.getUri();
    private static Logger log = LoggerFactory.getLogger(OSCIMessageBuilder.class);
    protected StringBuffer currentElement = null;
    protected OSCIMessage msg = null;
    protected boolean contentPackageAlreadySet = false;
    protected boolean insideHeader = false;
    protected boolean insideBody = false;
    private HashSet<String> parsedMsgPartsElementNames = new HashSet();
    protected Hashtable<String, String> parsedMsgPartsIds = new Hashtable();
    public OSCIEnvelopeBuilder parentBuilder = null;
    protected Vector<String> customSoapHeader = new Vector();

    public OSCIMessageBuilder(OSCIEnvelopeBuilder eb) {
        this.parentBuilder = eb;
    }

    public OSCIMessage getOSCIMessage() {
        return this.msg;
    }

    public XMLReader getXMLReader() {
        return this.parentBuilder.xmlReader;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        log.debug("ENV-Builder startElement: " + localName + " " + uri.length());
        if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
            if (this.insideHeader) {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            this.insideHeader = true;
        } else if (localName.equals("Body") && uri.equals(SOAP_XMLNS)) {
            if (this.insideBody) {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            this.insideBody = true;
            this.addFoundMsgPartIds(attributes.getValue("Id"), SOAP_XMLNS + ":Body");
        } else if (!localName.equals("Envelope") || !uri.equals(SOAP_XMLNS)) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    protected void startCustomSoapHeader(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            CanParser cp = new CanParser(this.customSoapHeader, this.parentBuilder.xmlReader, this.parentBuilder.xmlReader.getContentHandler(), qName);
            this.parentBuilder.xmlReader.setContentHandler(cp);
            cp.startDocument();
            cp.startElement(uri, localName, qName, attributes);
            this.addFoundMsgPartIds(attributes.getValue("Id"), uri + ":" + localName);
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SAXException(DialogHandler.text.getString("sax_exception_customheader"), ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
            this.insideHeader = false;
        } else if (localName.equals("Body") && uri.equals(SOAP_XMLNS)) {
            this.insideBody = false;
        } else if (localName.equals("Envelope") && uri.equals(SOAP_XMLNS)) {
            this.parentBuilder.xmlReader.setContentHandler(this.parentBuilder);
            for (int i = 0; i < this.customSoapHeader.size(); ++i) {
                this.msg.addCustomHeader(this.customSoapHeader.get(i));
            }
        }
        this.currentElement = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }

    public Canonizer getCanStream() {
        return this.parentBuilder.hashNCanStream;
    }

    private void addFoundMsgPart(String qName) throws SAXException {
        if (!this.parsedMsgPartsElementNames.add(qName)) {
            log.error("MessagePart already found: " + qName);
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            this.msg.osci2017NSPrefix = prefix;
        }
    }

    public void addFoundMsgPartIds(String id, String qName) throws SAXException {
        this.addFoundMsgPart(qName);
        if (id == null) {
            log.error("No Id attribute found: " + qName);
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
        }
        if (this.parsedMsgPartsIds.containsKey(id = "#".concat(id))) {
            log.error("Id already found: " + qName);
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()));
        }
        this.parsedMsgPartsIds.put(id, qName);
    }

    public void setContentPackageHandler(String localName) throws SAXException {
        if (this.contentPackageAlreadySet) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
        this.contentPackageAlreadySet = true;
        this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createContentPackageBuilder(this));
    }
}

