/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.StoreOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.messagetypes.AcceptDelivery;
import de.osci.osci12.messagetypes.IncomingMSGParser;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.PassiveRecipientParser;
import de.osci.osci12.messagetypes.ProcessDelivery;
import de.osci.osci12.messagetypes.SOAPMessageEncrypted;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.FeatureDescriptionH;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;

public abstract class OSCIRequest
extends OSCIMessage {
    protected URI uriReceiver;
    static IncomingMSGParser parser = new PassiveRecipientParser();

    OSCIRequest() {
    }

    OSCIRequest(DialogHandler dh) {
        super(dh);
        this.featureDescription = new FeatureDescriptionH();
        for (Constants.OSCIFeatures feature : Constants.OSCIFeatures.values()) {
            this.featureDescription.getSupportedFeatures().add(feature);
        }
        this.desiredLanguagesH = new DesiredLanguagesH(dh.getLanguageList());
    }

    public String getDesiredLanguages() {
        return this.dialogHandler.getLanguageList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OSCIMessage transmit(OutputStream outp, OutputStream inp) throws IOException, OSCIException, NoSuchAlgorithmException {
        OSCIMessage rsp;
        TransportI transport;
        TransportI transportI = this.dialogHandler.getTransportModule();
        synchronized (transportI) {
            transport = this.dialogHandler.getTransportModule().newInstance();
        }
        boolean intermed = this instanceof AcceptDelivery || this instanceof ProcessDelivery;
        URI uri = !intermed ? ((Intermed)this.dialogHandler.getSupplier()).getUri() : this.uriReceiver;
        this.dialogHandler.fireEvent(0);
        this.dialogHandler.fireEvent(1);
        if (this.dialogHandler.isCreateSignatures()) {
            this.sign();
        }
        OutputStream out = null;
        this.dialogHandler.fireEvent(2);
        try {
            if (this.dialogHandler.isEncryption()) {
                SOAPMessageEncrypted sme = new SOAPMessageEncrypted(this, outp);
                out = transport.getConnection(uri, sme.calcLength());
                sme.writeXML(out);
            } else {
                out = transport.getConnection(uri, this.calcLength());
                if (outp != null) {
                    StoreOutputStream sos = new StoreOutputStream(out, outp);
                    this.writeXML(sos);
                    sos.close();
                } else {
                    this.writeXML(out);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outp != null) {
                outp.close();
            }
        }
        this.dialogHandler.fireEvent(3);
        InputStream in = null;
        try {
            in = transport.getResponseStream();
            rsp = parser.parseStream(in, this.dialogHandler, false, inp);
            this.dialogHandler.fireEvent(4);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (inp != null) {
                inp.close();
            }
        }
        return rsp;
    }

    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign(this.dialogHandler.getClient());
        this.messageParts.set(3, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, NoSuchAlgorithmException, IOException {
        super.compose();
        this.messageParts.add(this.desiredLanguagesH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
    }
}

