/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.MediateDelivery;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.IntermediaryCertificatesH;
import de.osci.osci12.soapheader.OsciH;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class ProcessDelivery
extends OSCIRequest
implements ContentPackageI {
    ProcessCardBundle processCardBundle;

    ProcessDelivery(MediateDelivery mediateDelivery) throws OSCIRoleException, NoSuchAlgorithmException {
        super(new DialogHandler((Intermed)mediateDelivery.dialogHandler.getSupplier(), mediateDelivery.addressee, (TransportI)null));
        int i;
        this.messageType = 9;
        this.uriReceiver = mediateDelivery.uriReceiver;
        this.addressee = mediateDelivery.addressee;
        this.originator = mediateDelivery.originator;
        this.desiredLanguagesH = new DesiredLanguagesH(mediateDelivery.desiredLanguagesH.getLanguageList());
        ContentContainer[] con = mediateDelivery.getContentContainer();
        for (int i2 = 0; i2 < con.length; ++i2) {
            this.addContentContainer(con[i2]);
        }
        EncryptedDataOSCI[] enc = mediateDelivery.getEncryptedData();
        for (int i3 = 0; i3 < enc.length; ++i3) {
            this.addEncryptedData(enc[i3]);
        }
        Attachment[] att = mediateDelivery.getAttachments();
        for (i = 0; i < att.length; ++i) {
            this.addAttachment(att[i]);
        }
        for (i = 0; i < mediateDelivery.getOtherAuthors().length; ++i) {
            this.otherAutors.put(mediateDelivery.getOtherAuthors()[i].id, mediateDelivery.getOtherAuthors()[i]);
        }
        for (i = 0; i < mediateDelivery.getOtherReaders().length; ++i) {
            this.otherReaders.put(mediateDelivery.getOtherReaders()[i].id, mediateDelivery.getOtherReaders()[i]);
        }
        this.dialogHandler.setEncryption(mediateDelivery.getDialogHandler().isEncryption());
        this.dialogHandler.getControlblock().setResponse(null);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setConversationID(null);
        this.dialogHandler.getControlblock().setSequenceNumber(-1);
    }

    ProcessDelivery(DialogHandler dh) {
        super(dh);
        this.addressee = (Addressee)dh.getSupplier();
        this.messageType = 9;
    }

    public ProcessDelivery() {
        this.messageType = 9;
    }

    public ProcessCardBundle getProcessCardBundle() {
        return this.processCardBundle;
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addCustomHeaderExtention(CustomHeaderExtention extention) {
        super.addCustomHeaderExtention(extention);
    }

    @Override
    public CustomHeaderExtention getCustomHeader(CustomHeaderExtention ext) throws IOException {
        return super.getCustomHeader(ext);
    }

    public Timestamp getTimestampCreation() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getCreation();
        }
        return null;
    }

    public Timestamp getTimestampForwarding() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getForwarding();
        }
        return null;
    }

    public Inspection[] getInspections() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getInspections();
        }
        return null;
    }

    @Override
    public String getSubject() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getSubject();
        }
        return null;
    }

    public String getRecentModification() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getRecentModification();
        }
        return null;
    }

    @Override
    public String getMessageId() {
        if (this.processCardBundle != null) {
            return this.processCardBundle.getMessageId();
        }
        return null;
    }

    public String getMessageIdResponse() {
        return this.messageId;
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(5, this.intermediaryCertificatesH);
        this.messageParts.set(3, null);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        if (this.processCardBundle != null) {
            String pdh = "<" + this.osciNSPrefix + ":MessageIdResponse>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageIdResponse>" + this.processCardBundle.writeToString();
            this.osciH = new OsciH(Constants.HeaderTags.processDelivery.getElementName(), pdh);
        } else {
            this.osciH = new OsciH(Constants.HeaderTags.processDelivery.getElementName(), "");
        }
        this.messageParts.add(this.osciH);
        if (this.dialogHandler.getClient().hasCipherCertificate()) {
            if (this.intermediaryCertificatesH == null) {
                this.intermediaryCertificatesH = new IntermediaryCertificatesH();
            }
            this.intermediaryCertificatesH.setCipherCertificateIntermediary((Intermed)this.dialogHandler.getClient());
        }
        this.messageParts.add(this.intermediaryCertificatesH);
        this.createNonIntermediaryCertificatesH();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

