/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ProcessDelivery;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesHBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ProcessDeliveryBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ProcessDeliveryBuilder.class);
    private ProcessCardBundleBuilder processCardBuilder = null;
    private Boolean insideProcessDelivery = null;

    ProcessDeliveryBuilder(OSCIEnvelopeBuilder parentBuilder) {
        super(parentBuilder);
        if (log.isDebugEnabled()) {
            log.debug("Konstruktor");
        }
        this.msg = new ProcessDelivery();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Start-Element: " + localName);
            }
            if (this.insideBody) {
                if (ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) {
                    this.setContentPackageHandler(localName);
                }
            } else if (this.insideHeader) {
                if (log.isDebugEnabled()) {
                    log.debug("inside Header");
                }
                if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                    this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{0, 1, 0, 0}));
                } else if (ParserHelper.isElement(Constants.HeaderTags.ClientSignature, localName, uri)) {
                    this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
                } else if (ParserHelper.isElement(Constants.HeaderTags.DesiredLanguages, localName, uri)) {
                    this.msg.desiredLanguagesH = new DesiredLanguagesH(this, attributes.getValue("Id"), attributes.getValue("LanguagesList"));
                    this.msg.desiredLanguagesH.setRefID(attributes.getValue("Id"));
                    this.msg.desiredLanguagesH.setNSPrefixes(this.msg);
                    this.msg.dialogHandler.setLanguageList(attributes.getValue("LanguagesList"));
                } else if (ParserHelper.isElement(Constants.HeaderTags.processDelivery, localName, uri)) {
                    this.addFoundMsgPartIds(attributes.getValue("Id"), Constants.HeaderTags.processDelivery.getNamespace().getUri() + ":" + Constants.HeaderTags.processDelivery.getElementName());
                    if (this.insideProcessDelivery != null) {
                        throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                    }
                    this.insideProcessDelivery = true;
                } else if (localName.equals("MessageIdResponse") && uri.equals(OSCI_XMLNS) && this.insideProcessDelivery.booleanValue()) {
                    this.currentElement = new StringBuffer();
                } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri) && this.insideProcessDelivery.booleanValue()) {
                    int[] check = new int[]{1, 1, 0, -1};
                    this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                    this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
                } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                    int[] check = new int[]{-1, -1};
                    this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
                } else if (ParserHelper.isElement(Constants.HeaderTags.NonIntermediaryCertificates, localName, uri)) {
                    int[] check = new int[]{-1, -1, -1, -1, -1, -1, 0};
                    this.parentBuilder.xmlReader.setContentHandler(new NonIntermediaryCertificatesHBuilder(this, attributes, check));
                } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                    FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                    this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                    featureBuilder.startElement(uri, localName, qName, attributes);
                } else {
                    this.startCustomSoapHeader(uri, localName, qName, attributes);
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + localName);
            }
            if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
                if (this.processCardBuilder != null) {
                    ((ProcessDelivery)this.msg).processCardBundle = this.processCardBuilder.getProcessCardBundleObject();
                }
                this.insideHeader = false;
            } else if (ParserHelper.isElement(Constants.HeaderTags.processDelivery, localName, uri)) {
                this.insideProcessDelivery = false;
            } else if (this.insideProcessDelivery != null && this.insideProcessDelivery.booleanValue() && localName.equals("MessageIdResponse") && uri.equals(OSCI_XMLNS)) {
                this.msg.messageId = new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING);
            } else {
                super.endElement(uri, localName, qName);
            }
        }
        catch (Exception ex) {
            log.error("Fehler End-Element!", (Throwable)ex);
            throw new SAXException(ex);
        }
        this.currentElement = null;
    }
}

