/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.StoreOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.AcceptDelivery;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.messagetypes.SOAPMessageEncrypted;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.soapheader.OsciH;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Vector;

public class ResponseToAcceptDelivery
extends OSCIResponseTo {
    public ResponseToAcceptDelivery(AcceptDelivery request) {
        super(request.getDialogHandler());
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(null);
        this.dialogHandler.getControlblock().setConversationID(null);
        this.dialogHandler.getControlblock().setSequenceNumber(-1);
        this.messageType = 16;
    }

    ResponseToAcceptDelivery(DialogHandler dh) {
        super(dh);
        this.addressee = (Addressee)dh.getSupplier();
        this.messageType = 16;
    }

    @Override
    public void setFeedback(String[] code) {
        super.setFeedback(code);
    }

    public void setFeedback(String[][] entries) {
        this.feedBack = new Vector();
        this.feedBack.addAll(Arrays.asList(entries));
    }

    @Override
    public void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign(this.dialogHandler.getSupplier());
        this.messageParts.set(4, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, NoSuchAlgorithmException, IOException {
        super.compose();
        this.osciH = new OsciH(Constants.HeaderTags.responseToAcceptDelivery.getElementName(), this.writeFeedBack());
        this.messageParts.add(this.osciH);
        this.createNonIntermediaryCertificatesH();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body("");
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }

    public void writeToStream(OutputStream out, OutputStream storeOutput) throws IOException, OSCIException, NoSuchAlgorithmException {
        if (this.dialogHandler.isEncryption()) {
            new SOAPMessageEncrypted(this, storeOutput).writeXML(out);
        } else if (storeOutput != null) {
            StoreOutputStream sos = new StoreOutputStream(out, storeOutput);
            this.writeXML(sos);
            sos.close();
        } else {
            this.writeXML(out);
        }
    }
}

