/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.FetchRequestAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchDeliveryMessageParser;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class ResponseToFetchDelivery
extends ResponseToFetchAbstract
implements ContentPackageI {
    private static final String FETCH_DELIVERY = ":fetchDelivery>";

    public static ResponseToFetchDelivery parseResponseToFetchDelivery(InputStream streamRspStrDel) throws NoSuchAlgorithmException, IOException, OSCIException {
        ResponseToFetchDeliveryMessageParser obj = new ResponseToFetchDeliveryMessageParser();
        return obj.parseStream(streamRspStrDel);
    }

    ResponseToFetchDelivery(FetchRequestAbstract fetchDel, StoreDelivery storeDel) throws NoSuchAlgorithmException, OSCIRoleException {
        super(fetchDel.dialogHandler);
        this.messageType = 48;
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.setSelectionMode(fetchDel.getSelectionMode());
        this.setSelectionRule(fetchDel.getSelectionRule());
        if (storeDel == null) {
            this.setFeedback(new String[]{OSCIExceptionCodes.OSCIErrorCodes.NoDeliveryPresent.getOSCICode()});
        } else {
            int i;
            this.addressee = storeDel.addressee;
            this.originator = storeDel.originator;
            ContentContainer[] con = storeDel.getContentContainer();
            for (int i2 = 0; i2 < con.length; ++i2) {
                this.addContentContainer(con[i2]);
            }
            EncryptedDataOSCI[] enc = storeDel.getEncryptedData();
            for (int i3 = 0; i3 < enc.length; ++i3) {
                this.addEncryptedData(enc[i3]);
            }
            Attachment[] att = storeDel.getAttachments();
            for (i = 0; i < att.length; ++i) {
                this.addAttachment(att[i]);
            }
            for (i = 0; i < storeDel.getOtherAuthors().length; ++i) {
                this.otherAutors.put(storeDel.getOtherAuthors()[i].id, storeDel.getOtherAuthors()[i]);
            }
            for (i = 0; i < storeDel.getOtherReaders().length; ++i) {
                this.otherReaders.put(storeDel.getOtherReaders()[i].id, storeDel.getOtherReaders()[i]);
            }
        }
    }

    ResponseToFetchDelivery(DialogHandler dh) {
        super(dh);
        this.originator = (Originator)dh.getClient();
        this.messageType = 48;
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(2, null);
        this.createNonIntermediaryCertificatesH();
        Object selection = "";
        selection = this.selectionMode == 0 ? "<" + this.osciNSPrefix + ":fetchDelivery><" + this.osciNSPrefix + ":SelectionRule><" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.selectionRule.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId></" + this.osciNSPrefix + ":SelectionRule></" + this.osciNSPrefix + FETCH_DELIVERY : (this.selectionMode == 1 ? "<" + this.osciNSPrefix + ":fetchDelivery><" + this.osciNSPrefix + ":SelectionRule><" + this.osciNSPrefix + ":ReceptionOfDelivery>" + this.selectionRule + "</" + this.osciNSPrefix + ":ReceptionOfDelivery></" + this.osciNSPrefix + ":SelectionRule></" + this.osciNSPrefix + FETCH_DELIVERY : "<" + this.osciNSPrefix + ":fetchDelivery></" + this.osciNSPrefix + FETCH_DELIVERY);
        if (this.processCardBundle == null) {
            this.osciH = new OsciH(Constants.HeaderTags.responseToFetchDelivery.getElementName(), this.writeFeedBack() + (String)selection);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePartsFactory.writeXML(this.processCardBundle, out);
            this.osciH = new OsciH(Constants.HeaderTags.responseToFetchDelivery.getElementName(), this.writeFeedBack() + (String)selection + out.toString(Constants.CHARSET_ENCODING));
        }
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.intermediaryCertificatesH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.stateOfMsg |= 1;
        this.messageParts.add(this.body);
    }
}

