/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ResponseToFetchProcessCard;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import java.io.IOException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseToFetchProcessCardBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ResponseToFetchProcessCardBuilder.class);
    private ProcessCardBundleBuilder processCardBuilder = null;
    private Vector<ProcessCardBundle> processCardBundles = new Vector();
    private StringBuffer messageIds = new StringBuffer();
    private Boolean insideResponseToFetchProcessCard = null;
    private Boolean insideFetchProcessCard = null;

    public ResponseToFetchProcessCardBuilder(OSCIEnvelopeBuilder parentHandler) {
        super(parentHandler);
        this.msg = new ResponseToFetchProcessCard(parentHandler.dhHandler);
    }

    private void setSelectionAttributes(Attributes att) {
        if ("true".equals(att.getValue("NoReception"))) {
            ((ResponseToFetchProcessCard)this.msg).setSelectNoReceptionOnly(true);
        }
        if ("Addressee".equals(att.getValue("Role"))) {
            ((ResponseToFetchProcessCard)this.msg).setRoleForSelection(0);
        } else if ("Originator".equals(att.getValue("Role"))) {
            ((ResponseToFetchProcessCard)this.msg).setRoleForSelection(1);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element RspFtProc: " + localName);
        }
        if (this.insideBody) {
            if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri) && this.insideResponseToFetchProcessCard.booleanValue()) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri) && this.insideFetchProcessCard.booleanValue()) {
                ((ResponseToFetchProcessCard)this.msg).setSelectionMode(0);
                this.setSelectionAttributes(attributes);
                this.currentElement = new StringBuffer();
            } else if (localName.equals("ReceptionOfDelivery") && uri.equals(OSCI_XMLNS) && this.insideFetchProcessCard.booleanValue()) {
                ((ResponseToFetchProcessCard)this.msg).setSelectionMode(1);
                this.setSelectionAttributes(attributes);
                this.currentElement = new StringBuffer();
            } else if (localName.equals("RecentModification") && uri.equals(OSCI_XMLNS) && this.insideFetchProcessCard.booleanValue()) {
                ((ResponseToFetchProcessCard)this.msg).setSelectionMode(2);
                this.currentElement = new StringBuffer();
            } else if (localName.equals("Quantity") && uri.equals(OSCI_XMLNS) && this.insideFetchProcessCard.booleanValue()) {
                ((ResponseToFetchProcessCard)this.msg).setQuantityLimit(Long.parseLong(attributes.getValue("Limit")));
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToFetchProcessCard, localName, uri) && uri.equals(OSCI_XMLNS)) {
                if (this.insideResponseToFetchProcessCard != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideResponseToFetchProcessCard = true;
            } else if (ParserHelper.isElement(Constants.HeaderTags.fetchProcessCard, localName, uri) && this.insideResponseToFetchProcessCard.booleanValue()) {
                if (this.insideFetchProcessCard != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideFetchProcessCard = true;
            } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri) && this.insideResponseToFetchProcessCard.booleanValue()) {
                if (this.processCardBuilder != null) {
                    this.processCardBundles.add(this.processCardBuilder.getProcessCardBundleObject());
                }
                int[] check = new int[]{1, -1, -1, -1};
                this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
            }
        } else if (this.insideHeader) {
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{1, 1, 1, 1}));
            } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
            } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{0, -1};
                this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
            } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                featureBuilder.startElement(uri, localName, qName, attributes);
            } else {
                this.startCustomSoapHeader(uri, localName, qName, attributes);
            }
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri)) {
            if (this.messageIds.length() > 0) {
                this.messageIds.append(';');
            }
            try {
                this.messageIds.append(new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING));
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        } else if (localName.equals("ReceptionOfDelivery") && uri.equals(OSCI_XMLNS) || localName.equals("RecentModification") && uri.equals(OSCI_XMLNS) && this.insideFetchProcessCard.booleanValue()) {
            ((ResponseToFetchProcessCard)this.msg).setSelectionRule(this.currentElement.toString());
        } else if (localName.equals("SelectionRule") && uri.equals(OSCI_XMLNS) && this.insideFetchProcessCard.booleanValue()) {
            if (((ResponseToFetchProcessCard)this.msg).getSelectionMode() == 0) {
                ((ResponseToFetchProcessCard)this.msg).setSelectionRule(this.messageIds.toString());
            }
        } else if (ParserHelper.isElement(Constants.HeaderTags.responseToFetchProcessCard, localName, uri)) {
            this.insideResponseToFetchProcessCard = false;
        } else if (ParserHelper.isElement(Constants.HeaderTags.fetchProcessCard, localName, uri)) {
            this.insideFetchProcessCard = false;
        } else if (localName.equals("Body") && uri.equals(SOAP_XMLNS)) {
            ResponseToFetchProcessCard rtmd = (ResponseToFetchProcessCard)this.msg;
            if (this.processCardBuilder != null) {
                this.processCardBundles.add(this.processCardBuilder.getProcessCardBundleObject());
            }
            rtmd.processCardBundles = this.processCardBundles.toArray(new ProcessCardBundle[0]);
            this.insideBody = false;
        } else {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

