/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ResponseToForwardDelivery;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseToForwardDeliveryBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ResponseToForwardDeliveryBuilder.class);
    private ProcessCardBundleBuilder processCardBuilder = null;
    private Boolean insideResponseToForwardDelivery = null;

    ResponseToForwardDeliveryBuilder(OSCIEnvelopeBuilder parentHandler) {
        super(parentHandler);
        this.msg = new ResponseToForwardDelivery(parentHandler.dhHandler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element RspFwdDel: " + localName);
        }
        if (this.insideHeader) {
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{1, -1, -1, 1}));
            } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToForwardDelivery, localName, uri)) {
                this.addFoundMsgPartIds(attributes.getValue("Id"), Constants.HeaderTags.responseToForwardDelivery.getNamespace().getUri() + ":" + Constants.HeaderTags.responseToForwardDelivery.getElementName());
                if (this.insideResponseToForwardDelivery != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideResponseToForwardDelivery = true;
            } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri) && this.insideResponseToForwardDelivery.booleanValue()) {
                int[] check = new int[]{1, -1, -1, -1};
                this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
            } else if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri) && this.insideResponseToForwardDelivery.booleanValue()) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{0, -1};
                this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
            } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                featureBuilder.startElement(uri, localName, qName, attributes);
            } else {
                this.startCustomSoapHeader(uri, localName, qName, attributes);
            }
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
            if (this.processCardBuilder != null) {
                ((ResponseToForwardDelivery)this.msg).setProcessCardBundle(this.processCardBuilder.getProcessCardBundleObject());
            }
            this.insideHeader = false;
        } else if (ParserHelper.isElement(Constants.HeaderTags.responseToForwardDelivery, localName, uri)) {
            this.insideResponseToForwardDelivery = false;
        } else {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

