/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ResponseToGetMessageIdBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ResponseToGetMessageIdBuilder.class);
    private Boolean insideResponseToGetMessageId = null;

    public ResponseToGetMessageIdBuilder(OSCIEnvelopeBuilder parentHandler) throws NoSuchAlgorithmException {
        super(parentHandler);
        this.msg = new ResponseToGetMessageId(parentHandler.dhHandler, true);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element RspFwdDel: " + localName);
        }
        if (this.insideBody) {
            if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri) && this.insideResponseToGetMessageId.booleanValue()) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri) && this.insideResponseToGetMessageId.booleanValue()) {
                this.currentElement = new StringBuffer();
            } else if (localName.equals("responseToGetMessageId") && uri.equals(OSCI_XMLNS)) {
                if (this.insideResponseToGetMessageId != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideResponseToGetMessageId = true;
            }
        } else if (this.insideHeader) {
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{1, -1, 1, 1}));
            } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
            } else if (!localName.equals("responseToGetMessageId") || !uri.equals(OSCI_XMLNS)) {
                if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                    FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                    this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                    featureBuilder.startElement(uri, localName, qName, attributes);
                } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                    int[] check = new int[]{0, -1};
                    this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
                } else {
                    this.startCustomSoapHeader(uri, localName, qName, attributes);
                }
            }
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (localName.equals("Body") && uri.equals(SOAP_XMLNS)) {
            this.insideBody = false;
        } else if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri) && this.insideResponseToGetMessageId.booleanValue()) {
            try {
                ((ResponseToGetMessageId)this.msg).setMessageId(new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING));
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        } else if (localName.equals("responseToGetMessageId") && uri.equals(OSCI_XMLNS)) {
            this.insideResponseToGetMessageId = false;
        } else if (!ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

