/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ResponseToMediateDelivery;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesHBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseToMediateDeliveryBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ResponseToMediateDeliveryBuilder.class);
    private ProcessCardBundleBuilder requestProcessCardBuilder = null;
    private ProcessCardBundleBuilder replyProcessCardBuilder = null;
    private Boolean insideResponseToMediateDelivery = null;

    public ResponseToMediateDeliveryBuilder(OSCIEnvelopeBuilder parentHandler) throws OSCIRoleException {
        super(parentHandler);
        this.msg = new ResponseToMediateDelivery(parentHandler.dhHandler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element RspFwdDel: " + localName + " : " + this.insideHeader + "/" + this.insideBody);
        }
        if (this.insideBody) {
            if (ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) {
                this.setContentPackageHandler(localName);
            }
        } else if (this.insideHeader) {
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{1, 1, 1, 1}));
            } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToMediateDelivery, localName, uri)) {
                this.addFoundMsgPartIds(attributes.getValue("Id"), Constants.HeaderTags.responseToMediateDelivery.getNamespace().getUri() + ":" + Constants.HeaderTags.responseToMediateDelivery.getElementName());
                if (this.insideResponseToMediateDelivery != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
                this.insideResponseToMediateDelivery = true;
            } else if (ParserHelper.isElement(Constants.CommonTags.RequestProcessCardBundle, localName, uri) && this.insideResponseToMediateDelivery.booleanValue()) {
                int[] check = new int[]{1, -1, -1, -1};
                this.requestProcessCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.RequestProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.requestProcessCardBuilder);
            } else if (ParserHelper.isElement(Constants.CommonTags.ReplyProcessCardBundle, localName, uri) && this.insideResponseToMediateDelivery.booleanValue()) {
                int[] check = new int[]{1, -1, -1, -1};
                this.replyProcessCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ReplyProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.replyProcessCardBuilder);
            } else if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri) && this.insideResponseToMediateDelivery.booleanValue()) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{0, -1};
                this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
            } else if (ParserHelper.isElement(Constants.HeaderTags.NonIntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{-1, -1, -1, -1, -1, -1, 0};
                this.parentBuilder.xmlReader.setContentHandler(new NonIntermediaryCertificatesHBuilder(this, attributes, check));
            } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                featureBuilder.startElement(uri, localName, qName, attributes);
            } else {
                this.startCustomSoapHeader(uri, localName, qName, attributes);
            }
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (localName.equals("Header") && uri.equals(SOAP_XMLNS)) {
            ResponseToMediateDelivery rtmd = (ResponseToMediateDelivery)this.msg;
            if (this.requestProcessCardBuilder != null) {
                rtmd.processCardBundleRequest = this.requestProcessCardBuilder.getProcessCardBundleObject();
                rtmd.messageId = this.requestProcessCardBuilder.getProcessCardBundleObject().getMessageId();
                if (this.replyProcessCardBuilder != null) {
                    rtmd.processCardBundleReply = this.replyProcessCardBuilder.getProcessCardBundleObject();
                }
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToMediateDelivery, localName, uri)) {
                this.insideResponseToMediateDelivery = false;
            }
            this.insideHeader = false;
        } else {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

