/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.FetchRequestAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchAbstract;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class ResponseToPartialFetchDelivery
extends ResponseToFetchAbstract {
    ChunkInformation chunkInformation = MessagePartsFactory.creatChunkInformation(ChunkInformation.CheckInstance.ResponsePartialFetchDelivery);

    ResponseToPartialFetchDelivery(FetchRequestAbstract fetchReq, Addressee addressee, Originator originator, Attachment chunkAttachment) throws NoSuchAlgorithmException, OSCIRoleException, IllegalArgumentException, IOException {
        super(fetchReq.dialogHandler);
        this.messageType = 49;
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.setSelectionMode(fetchReq.getSelectionMode());
        this.setSelectionRule(fetchReq.getSelectionRule());
        this.setChunkBlob(chunkAttachment);
        if (addressee == null || originator == null) {
            this.setFeedback(new String[]{OSCIExceptionCodes.OSCIErrorCodes.NoDeliveryPresent.getOSCICode()});
        } else {
            this.addressee = addressee;
            this.originator = originator;
        }
    }

    ResponseToPartialFetchDelivery(FetchRequestAbstract fetchReq, Addressee addressee, Originator originator, InputStream chunkBlob) throws NoSuchAlgorithmException, OSCIRoleException, IllegalArgumentException, IOException {
        super(fetchReq.dialogHandler);
        this.messageType = 49;
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.setSelectionMode(fetchReq.getSelectionMode());
        this.setSelectionRule(fetchReq.getSelectionRule());
        this.setChunkBlob(chunkBlob);
        if (addressee == null || originator == null) {
            this.setFeedback(new String[]{OSCIExceptionCodes.OSCIErrorCodes.NoDeliveryPresent.getOSCICode()});
        } else {
            this.addressee = addressee;
            this.originator = originator;
        }
    }

    ResponseToPartialFetchDelivery(DialogHandler dh) {
        super(dh);
        this.originator = (Originator)dh.getClient();
        this.messageType = 49;
    }

    public InputStream getChunkBlob() throws OSCICipherException, IOException {
        ContentContainer coco = (ContentContainer)this.contentContainer.get("ChunkContentContainer");
        Attachment att = coco.getContents()[0].getAttachment();
        return att.getStream();
    }

    void setChunkBlob(Attachment chunkAttachment) throws OSCIRoleException, NoSuchAlgorithmException, IOException {
        ContentContainer container = new ContentContainer();
        container.setRefID("ChunkContentContainer");
        chunkAttachment.setBase64Encoding(false);
        Content content = new Content(chunkAttachment);
        content.setRefID("ChunkContent");
        container.addContent(content);
        super.addContentContainer(container);
    }

    void setChunkBlob(InputStream chunkBlob) throws OSCIRoleException, NoSuchAlgorithmException, IOException {
        ContentContainer container = new ContentContainer();
        container.setRefID("ChunkContentContainer");
        Attachment atta = new Attachment(chunkBlob, "ChunkBlobStoreDelivery");
        atta.setBase64Encoding(false);
        Content content = new Content(atta);
        content.setRefID("ChunkContent");
        container.addContent(content);
        super.addContentContainer(container);
    }

    public ChunkInformation getChunkInformation() {
        return this.chunkInformation;
    }

    public void setChunkInformation(ChunkInformation chunkInformation) {
        this.chunkInformation = chunkInformation;
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(2, null);
        this.createNonIntermediaryCertificatesH();
        ByteArrayOutputStream chunkInformationXml = new ByteArrayOutputStream();
        MessagePartsFactory.writeXML(this.chunkInformation, chunkInformationXml);
        Object selection = "";
        Object msgIdElement = "";
        if (this.getSelectionMode() == 0) {
            try {
                selection = "<" + this.osciNSPrefix + ":fetchDelivery><" + this.osciNSPrefix + ":SelectionRule><" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.getSelectionRule().getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId></" + this.osciNSPrefix + ":SelectionRule></" + this.osciNSPrefix + ":fetchDelivery>";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            selection = this.getSelectionMode() == 1 ? "<" + this.osciNSPrefix + ":fetchDelivery><" + this.osciNSPrefix + ":SelectionRule><" + this.osciNSPrefix + ":ReceptionOfDelivery>" + this.getSelectionRule() + "</" + this.osciNSPrefix + ":ReceptionOfDelivery></" + this.osciNSPrefix + ":SelectionRule></" + this.osciNSPrefix + ":fetchDelivery>" : "<" + this.osciNSPrefix + ":fetchDelivery></" + this.osciNSPrefix + ":fetchDelivery>";
        }
        if (this.messageId != null) {
            msgIdElement = "<" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId>";
        }
        this.osciH = new OsciH(Constants.HeaderTags.responseToPartialFetchDelivery.getElementName(), this.writeFeedBack() + (String)selection + chunkInformationXml.toString(Constants.CHARSET_ENCODING) + (String)msgIdElement, this.osci2017NSPrefix);
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.intermediaryCertificatesH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.stateOfMsg |= 1;
        this.messageParts.add(this.body);
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }
}

