/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.ChunkInformationBuilder;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ResponseToPartialStoreDelivery;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseToPartialStoreDeliveryBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(ResponseToPartialStoreDeliveryBuilder.class);
    private boolean insideRspToPartialStoreDelivery = false;
    ResponseToPartialStoreDelivery rspToPartialStoreDelivery = null;
    ChunkInformationBuilder chunkInformationBuilder = null;
    FeedbackBuilder feedbackBuilder = null;
    private ProcessCardBundleBuilder processCardBuilder = null;

    public ResponseToPartialStoreDeliveryBuilder(OSCIEnvelopeBuilder parentHandler) throws NoSuchAlgorithmException {
        super(parentHandler);
        this.rspToPartialStoreDelivery = new ResponseToPartialStoreDelivery(parentHandler.dhHandler, true);
        this.msg = this.rspToPartialStoreDelivery;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start Element RspStrDel: " + localName);
        }
        if (this.insideHeader) {
            if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{1, -1, 1, 1}));
            } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToPartialStoreDelivery, localName, uri)) {
                this.insideRspToPartialStoreDelivery = true;
            } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri)) {
                int[] check = new int[]{1, -1, -1, -1};
                this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
            } else if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                int[] check = new int[]{0, -1};
                this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
            } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                featureBuilder.startElement(uri, localName, qName, attributes);
            } else if (this.insideRspToPartialStoreDelivery) {
                if (ParserHelper.isElement(Constants.CommonTags.ChunkInformation, localName, uri)) {
                    this.chunkInformationBuilder = new ChunkInformationBuilder(this.parentBuilder.xmlReader, this, ChunkInformation.CheckInstance.ResponsePartialStoreDelivery);
                    this.parentBuilder.xmlReader.setContentHandler(this.chunkInformationBuilder);
                    this.chunkInformationBuilder.startElement(uri, localName, qName, attributes);
                } else if (ParserHelper.isElement(Constants.CommonTags.InsideFeedback, localName, uri)) {
                    this.feedbackBuilder = new FeedbackBuilder(this, true);
                    this.parentBuilder.xmlReader.setContentHandler(this.feedbackBuilder);
                }
            } else {
                this.startCustomSoapHeader(uri, localName, qName, attributes);
            }
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("End-Element: " + localName);
            }
            if ("Header".equals(localName)) {
                if (this.processCardBuilder != null) {
                    ((ResponseToPartialStoreDelivery)this.msg).processCardBundle = this.processCardBuilder.getProcessCardBundleObject();
                }
                this.insideHeader = false;
            } else if (ParserHelper.isElement(Constants.HeaderTags.responseToPartialStoreDelivery, localName, uri)) {
                this.insideRspToPartialStoreDelivery = false;
            } else if (ParserHelper.isElement(Constants.CommonTags.ChunkInformation, localName, uri)) {
                this.rspToPartialStoreDelivery.setChunkInformation(this.chunkInformationBuilder.getChunkInformationObject());
            } else if (ParserHelper.isElement(Constants.CommonTags.InsideFeedback, localName, uri)) {
                this.rspToPartialStoreDelivery.insideFeedBack = this.feedbackBuilder.getFeedback();
            } else {
                super.endElement(uri, localName, qName);
            }
        }
        catch (Exception ex) {
            log.error("Fehler End-Element!", (Throwable)ex);
            throw new SAXException(ex);
        }
        this.currentElement = null;
    }
}

