/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.StoreOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.messagetypes.ProcessDelivery;
import de.osci.osci12.messagetypes.SOAPMessageEncrypted;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import de.osci.osci12.soapheader.QualityOfTimestampH;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Vector;

public class ResponseToProcessDelivery
extends OSCIResponseTo
implements ContentPackageI {
    private String subject;

    ResponseToProcessDelivery(DialogHandler dh) {
        super(dh);
        this.messageType = 144;
    }

    public ResponseToProcessDelivery(ProcessDelivery procDel) {
        super(procDel.dialogHandler);
        this.messageType = 144;
        Signer signer = null;
        Decrypter decrypter = null;
        try {
            if (this.dialogHandler.getSupplier().hasSignaturePrivateKey()) {
                signer = this.dialogHandler.getSupplier().getSigner();
            }
            if (this.dialogHandler.getSupplier().hasCipherPrivateKey()) {
                decrypter = this.dialogHandler.getSupplier().getDecrypter();
            }
            this.originator = new Originator(signer, decrypter);
            X509Certificate signerCert = null;
            X509Certificate cipherCert = null;
            if (procDel.getOriginator().hasSignatureCertificate()) {
                signerCert = procDel.getOriginator().getSignatureCertificate();
            }
            if (procDel.getOriginator().hasCipherCertificate()) {
                cipherCert = procDel.getOriginator().getCipherCertificate();
            }
            this.addressee = new Addressee(signerCert, cipherCert);
            this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
            this.dialogHandler.getControlblock().setChallenge(null);
            this.dialogHandler.getControlblock().setConversationID(null);
            this.dialogHandler.getControlblock().setSequenceNumber(-1);
            this.setQualityOfTimeStampCreation(false);
            this.setQualityOfTimeStampReception(false);
        }
        catch (OSCIRoleException oSCIRoleException) {
            // empty catch block
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void setFeedback(String[] code) {
        super.setFeedback(code);
    }

    public void setFeedback(String[][] entries) {
        this.feedBack = new Vector();
        this.feedBack.addAll(Arrays.asList(entries));
    }

    public void setQualityOfTimeStampCreation(boolean cryptographic) {
        this.qualityOfTimestampTypeCreation = new QualityOfTimestampH(false, cryptographic);
    }

    public boolean getQualityOfTimeStampCreation() {
        return this.qualityOfTimestampTypeCreation.isQualityCryptographic();
    }

    public void setQualityOfTimeStampReception(boolean cryptographic) {
        this.qualityOfTimestampTypeReception = new QualityOfTimestampH(true, cryptographic);
    }

    public boolean getQualityOfTimeStampReception() {
        return this.qualityOfTimestampTypeReception.isQualityCryptographic();
    }

    @Override
    public void addContentContainer(ContentContainer container) throws OSCIRoleException {
        super.addContentContainer(container);
    }

    @Override
    public void removeContentContainer(ContentContainer container) {
        super.removeContentContainer(container);
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public void addEncryptedData(EncryptedDataOSCI encData) throws OSCIRoleException {
        super.addEncryptedData(encData);
    }

    @Override
    public void removeEncryptedData(EncryptedDataOSCI encData) {
        super.removeEncryptedData(encData);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addCustomHeaderExtention(CustomHeaderExtention extention) {
        super.addCustomHeaderExtention(extention);
    }

    @Override
    public CustomHeaderExtention getCustomHeader(CustomHeaderExtention ext) throws IOException {
        return super.getCustomHeader(ext);
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign(this.originator);
        this.messageParts.set(2, null);
        this.messageParts.set(6, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(2, null);
        Object head = this.writeFeedBack();
        if (this.messageId != null) {
            head = (String)head + "<" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId>";
            if (this.subject != null) {
                head = (String)head + "<" + this.osciNSPrefix + ":Subject>" + this.subject + "</" + this.osciNSPrefix + ":Subject>";
            }
        } else {
            this.qualityOfTimestampTypeCreation = null;
            this.qualityOfTimestampTypeReception = null;
        }
        this.messageParts.add(this.qualityOfTimestampTypeCreation);
        this.messageParts.add(this.qualityOfTimestampTypeReception);
        this.osciH = new OsciH(Constants.HeaderTags.responseToProcessDelivery.getElementName(), (String)head);
        this.messageParts.add(this.osciH);
        this.createNonIntermediaryCertificatesH();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }

    public void writeToStream(OutputStream out, OutputStream storeOutput) throws IOException, OSCIException, NoSuchAlgorithmException {
        if (this.dialogHandler.isEncryption()) {
            new SOAPMessageEncrypted(this, storeOutput).writeXML(out);
        } else if (storeOutput != null) {
            StoreOutputStream sos = new StoreOutputStream(out, storeOutput);
            this.writeXML(sos);
            sos.close();
        } else {
            this.writeXML(out);
        }
    }
}

