/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.EncryptedDataBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.SOAPMessageEncrypted;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SOAPMessageEncryptedBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(SOAPMessageEncryptedBuilder.class);
    private EncryptedDataBuilder edb;

    public SOAPMessageEncryptedBuilder(OSCIEnvelopeBuilder eb) throws NoSuchAlgorithmException {
        super(eb);
        if (log.isDebugEnabled()) {
            log.debug("Konstruktor");
        }
        this.msg = new SOAPMessageEncrypted(null, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName);
        }
        if (localName.equals("EncryptedData") && uri.equals(XENC_XMLNS)) {
            this.edb = new EncryptedDataBuilder(this.parentBuilder.xmlReader, this, attributes);
            this.parentBuilder.xmlReader.setContentHandler(this.edb);
        } else if (!localName.equals("Body") || !uri.equals(SOAP_XMLNS)) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void endDocument() {
        if (log.isDebugEnabled()) {
            log.debug("End-Document SOAP");
        }
        ((SOAPMessageEncrypted)this.msg).encData = this.edb.getEncryptedData();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
    }
}

