/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messagetypes.FeedbackBuilder;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.soapheader.ControlBlockHBuilder;
import de.osci.osci12.soapheader.DesiredLanguagesH;
import de.osci.osci12.soapheader.FeatureDescriptionHBuilder;
import de.osci.osci12.soapheader.IntermediaryCertificatesHBuilder;
import de.osci.osci12.soapheader.NonIntermediaryCertificatesHBuilder;
import de.osci.osci12.soapheader.QualityOfTimestampHBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class StoredMessageBuilder
extends OSCIMessageBuilder {
    private static Logger log = LoggerFactory.getLogger(StoredMessageBuilder.class);
    private ProcessCardBundleBuilder processCardBuilder = null;
    private Vector<ProcessCardBundle> processCardBundles = new Vector();
    private ProcessCardBundleBuilder replyProcessCardBuilder = null;
    FeedbackBuilder feedbackBuilder = null;

    public StoredMessageBuilder(OSCIEnvelopeBuilder parentHandler, int msgType) {
        super(parentHandler);
        this.msg = new StoredMessage(msgType);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName + ":" + uri);
        }
        if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri) || localName.equals("ReceptionOfDelivery") && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (this.insideHeader && localName.equals("MessageIdResponse") && uri.equals(OSCI_XMLNS) && this.msg.getMessageType() == 9) {
            this.currentElement = new StringBuffer();
        } else if (!localName.equals("SelectionRule") || !uri.equals(OSCI_XMLNS)) {
            if (localName.equals("Quantity") && uri.equals(OSCI_XMLNS)) {
                ((StoredMessage)this.msg).quantityLimit = Long.parseLong(attributes.getValue("Limit"));
            } else if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri)) {
                this.parentBuilder.xmlReader.setContentHandler(new FeedbackBuilder(this));
            } else if (ParserHelper.isElement(Constants.CommonTags.InsideFeedback, localName, uri)) {
                this.feedbackBuilder = new FeedbackBuilder(this, true);
                this.parentBuilder.xmlReader.setContentHandler(this.feedbackBuilder);
            } else if (ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri)) {
                if (this.processCardBuilder != null) {
                    this.processCardBundles.add(this.processCardBuilder.getProcessCardBundleObject());
                }
                int[] check = new int[]{-1, -1, -1, -1};
                this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
            } else if (this.insideBody) {
                if (ParserHelper.isElement(Constants.CommonTags.ContentPackage, localName, uri)) {
                    this.setContentPackageHandler(localName);
                }
            } else if (this.insideHeader) {
                if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                    this.parentBuilder.xmlReader.setContentHandler(new ControlBlockHBuilder(this, attributes, new int[]{-1, -1, -1, -1}));
                } else if (ParserHelper.isElement(Constants.HeaderTags.SupplierSignature, localName, uri) || ParserHelper.isElement(Constants.HeaderTags.ClientSignature, localName, uri)) {
                    this.parentBuilder.xmlReader.setContentHandler(MessagePartsFactory.createOsciSignatureBuilder(this.parentBuilder.xmlReader, this, attributes));
                } else if (ParserHelper.isElement(Constants.HeaderTags.DesiredLanguages, localName, uri)) {
                    this.msg.desiredLanguagesH = new DesiredLanguagesH(this, attributes.getValue("Id"), attributes.getValue("LanguagesList"));
                    this.msg.desiredLanguagesH.setRefID(attributes.getValue("Id"));
                    this.msg.desiredLanguagesH.setNSPrefixes(this.msg);
                    this.msg.dialogHandler.setLanguageList(attributes.getValue("LanguagesList"));
                } else if (!ParserHelper.isElement(Constants.CommonTags.ChunkInformation, localName, uri)) {
                    if (ParserHelper.isElement(Constants.HeaderTags.QualityOfTimestamp, localName, uri)) {
                        this.parentBuilder.xmlReader.setContentHandler(new QualityOfTimestampHBuilder(this, attributes));
                    } else if (ParserHelper.isElement(Constants.CommonTags.RequestProcessCardBundle, localName, uri)) {
                        int[] check = new int[]{-1, -1, -1, -1};
                        this.processCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.RequestProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                        this.parentBuilder.xmlReader.setContentHandler(this.processCardBuilder);
                    } else if (ParserHelper.isElement(Constants.CommonTags.ReplyProcessCardBundle, localName, uri)) {
                        int[] check = new int[]{-1, -1, -1, -1};
                        this.replyProcessCardBuilder = new ProcessCardBundleBuilder(Constants.CommonTags.ReplyProcessCardBundle, this.parentBuilder.xmlReader, (DefaultHandler)this, check);
                        this.parentBuilder.xmlReader.setContentHandler(this.replyProcessCardBuilder);
                    } else if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                        int[] check = new int[]{-1, -1};
                        this.parentBuilder.xmlReader.setContentHandler(new IntermediaryCertificatesHBuilder(this, attributes, check));
                    } else if (ParserHelper.isElement(Constants.HeaderTags.NonIntermediaryCertificates, localName, uri)) {
                        int[] check = new int[]{-1, -1, -1, -1, -1, -1, -1};
                        this.parentBuilder.xmlReader.setContentHandler(new NonIntermediaryCertificatesHBuilder(this, attributes, check));
                    } else if (localName.equals("Subject") && uri.equals(OSCI_XMLNS)) {
                        this.currentElement = new StringBuffer();
                    } else if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                        FeatureDescriptionHBuilder featureBuilder = new FeatureDescriptionHBuilder(this, attributes);
                        this.parentBuilder.xmlReader.setContentHandler(featureBuilder);
                        featureBuilder.startElement(uri, localName, qName, attributes);
                    } else if (localName.equals("ContentReceiver") && uri.equals(OSCI_XMLNS)) {
                        try {
                            ((StoredMessage)this.msg).uriReceiver = new URI(attributes.getValue("URI"));
                        }
                        catch (URISyntaxException ex) {
                            throw new SAXException(ex);
                        }
                    } else if (localName.equals(Constants.HeaderTags.QualityOfTimestamp.getElementName()) && uri.equals(OSCI_XMLNS)) {
                        this.parentBuilder.xmlReader.setContentHandler(new QualityOfTimestampHBuilder(this, attributes));
                    } else if (!((localName.equals(Constants.HeaderTags.mediateDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToMediateDelivery.getElementName()) || localName.equals(Constants.HeaderTags.storeDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToStoreDelivery.getElementName()) || localName.equals(Constants.HeaderTags.fetchDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToFetchDelivery.getElementName()) || localName.equals(Constants.HeaderTags.fetchProcessCard.getElementName()) || localName.equals(Constants.HeaderTags.responseToFetchProcessCard.getElementName()) || localName.equals(Constants.HeaderTags.forwardDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToForwardDelivery.getElementName()) || localName.equals(Constants.HeaderTags.acceptDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToAcceptDelivery.getElementName()) || localName.equals(Constants.HeaderTags.partialStoreDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToPartialStoreDelivery.getElementName()) || localName.equals(Constants.HeaderTags.processDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToProcessDelivery.getElementName())) && uri.equals(OSCI_XMLNS) || (localName.equals(Constants.HeaderTags.partialStoreDelivery.getElementName()) || localName.equals(Constants.HeaderTags.responseToPartialStoreDelivery.getElementName())) && uri.equals(Constants.Namespaces.OSCI2017.getUri()))) {
                        this.startCustomSoapHeader(uri, localName, qName, attributes);
                    }
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("End-Element: " + localName);
        }
        if (localName.equals("Envelope") && uri.equals(SOAP_XMLNS)) {
            StoredMessage sm = (StoredMessage)this.msg;
            if (this.processCardBuilder != null) {
                this.processCardBundles.add(this.processCardBuilder.getProcessCardBundleObject());
                sm.processCardBundles = this.processCardBundles.toArray(new ProcessCardBundle[0]);
                if (this.replyProcessCardBuilder != null) {
                    sm.processCardBundleReply = this.replyProcessCardBuilder.getProcessCardBundleObject();
                }
            }
            for (int i = 0; i < this.customSoapHeader.size(); ++i) {
                this.msg.addCustomHeader((String)this.customSoapHeader.get(i));
            }
            this.msg.dialogHandler.setCheckSignatures(false);
            this.parentBuilder.xmlReader.setContentHandler(this.parentBuilder);
        } else if (this.feedbackBuilder != null && ParserHelper.isElement(Constants.CommonTags.InsideFeedback, localName, uri)) {
            ((StoredMessage)this.msg).insideFeedBack = this.feedbackBuilder.getFeedback();
        } else if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri) || localName.equals("MessageIdResponse") && uri.equals(OSCI_XMLNS)) {
            try {
                if (this.msg.getMessageType() == 3 || this.msg.getMessageType() == 48 || this.msg.getMessageType() == 4 || this.msg.getMessageType() == 64) {
                    ((StoredMessage)this.msg).selectionMode = 0;
                    ((StoredMessage)this.msg).selectionRule = new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING);
                }
                this.msg.messageId = new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING);
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        } else if (localName.equals("ReceptionOfDelivery") && uri.equals(OSCI_XMLNS)) {
            ((StoredMessage)this.msg).selectionMode = 1;
            ((StoredMessage)this.msg).selectionRule = this.currentElement.toString();
        } else if (localName.equals("Subject") && uri.equals(OSCI_XMLNS)) {
            ((StoredMessage)this.msg).subject = this.currentElement.toString();
        } else {
            super.endElement(uri, localName, qName);
        }
        this.currentElement = null;
    }
}

