/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples.impl;

import de.osci.osci12.extinterfaces.TransportI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.util.Locale;
import java.util.ResourceBundle;

public class HttpTransport
implements TransportI {
    URLConnection con;
    ResourceBundle text = ResourceBundle.getBundle("de.osci.osci12.extinterfaces.language.Text", Locale.getDefault());

    @Override
    public String getVendor() {
        return "BOS";
    }

    @Override
    public String getVersion() {
        return "0.9";
    }

    @Override
    public TransportI newInstance() {
        return new HttpTransport();
    }

    @Override
    public InputStream getResponseStream() throws IOException {
        return this.con.getInputStream();
    }

    @Override
    public boolean isOnline(URI uri) throws IOException {
        try {
            this.con = uri.toURL().openConnection();
            this.con.connect();
            return true;
        }
        catch (MalformedURLException ex) {
            throw new IOException(this.text.getString("invalid_url") + ": " + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long getContentLength() {
        throw new UnsupportedOperationException("Methode getContentLength() noch nicht implementiert.");
    }

    @Override
    public OutputStream getConnection(URI uri, long laenge) throws IOException {
        try {
            this.con = uri.toURL().openConnection();
            HttpURLConnection httpCon = (HttpURLConnection)this.con;
            httpCon.setInstanceFollowRedirects(false);
            httpCon.setRequestMethod("POST");
            httpCon.setRequestProperty("Content-Type", "text/xml");
            httpCon.setRequestProperty("charset", "utf-8");
            httpCon.setRequestProperty("Content-Length", Long.toString(laenge));
            httpCon.setUseCaches(false);
            httpCon.setDoOutput(true);
            OutputStream s = httpCon.getOutputStream();
            return s;
        }
        catch (MalformedURLException ex) {
            throw new IOException(this.text.getString("invalid_url") + ": " + ex.getLocalizedMessage());
        }
    }
}

