/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples.impl.crypto;

import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCICancelledException;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PKCS12Decrypter
extends Decrypter {
    private X509Certificate cert;
    private String alias;
    private char[] pin = null;
    private KeyStore keyStore = null;
    private Key key;

    public PKCS12Decrypter(String p12_fileName, String pin) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        this.init(PKCS12Decrypter.class.getResourceAsStream(p12_fileName), pin);
    }

    public PKCS12Decrypter(InputStream in, String pin) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        this.init(in, pin);
    }

    private void init(InputStream in, String pin) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        this.pin = pin.toCharArray();
        this.keyStore = DialogHandler.getSecurityProvider() == null ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("PKCS12", DialogHandler.getSecurityProvider());
        this.keyStore.load(in, this.pin);
        String al = null;
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements() && !this.keyStore.isKeyEntry(al = e.nextElement())) {
        }
        if (al == null) {
            throw new NullPointerException("No private key found in keystore.");
        }
        this.alias = al;
        this.cert = (X509Certificate)this.keyStore.getCertificate(this.alias);
        this.key = this.keyStore.getKey(this.alias, this.pin);
    }

    @Override
    public String getVendor() {
        return "BOS";
    }

    @Override
    public String getVersion() {
        return "1.6";
    }

    @Override
    public X509Certificate getCertificate() {
        return this.cert;
    }

    @Override
    public byte[] decrypt(byte[] data) throws OSCICipherException {
        try {
            return Crypto.doRSADecryption(this.key, data);
        }
        catch (Exception ex) {
            throw new OSCICipherException("decryption_error");
        }
    }

    @Override
    public byte[] decrypt(byte[] data, String mgfAlgorithm, String digestAlgorithm) throws OSCICipherException, OSCICancelledException {
        try {
            return Crypto.doRSADecryption(this.key, data, "http://www.w3.org/2009/xmlenc11#rsa-oaep", mgfAlgorithm, digestAlgorithm, null);
        }
        catch (Exception ex) {
            throw new OSCICipherException("decryption_error");
        }
    }
}

