/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.signature;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.encryption.EncryptedKey;
import de.osci.osci12.signature.RetrievalMethod;
import de.osci.osci12.signature.X509Data;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInfo {
    private static Logger log = LoggerFactory.getLogger(KeyInfo.class);
    private String keyName;
    private int typeOfKey = -1;
    private RetrievalMethod retrievalMethod;
    X509Data x509Data = null;
    private String mgmtData = null;
    private String keyValue;
    private Vector<EncryptedKey> encryptedKey = new Vector();
    private String agreementMethod;
    private String id;

    public KeyInfo(String uRI, String id) {
        this.id = id;
        this.typeOfKey = 1;
        if (log.isDebugEnabled()) {
            log.debug("Konstruktortype: RetrievelMethod");
        }
        RetrievalMethod retrievalMethod = new RetrievalMethod();
        retrievalMethod.setURI(uRI);
        this.retrievalMethod = retrievalMethod;
    }

    public KeyInfo(String uRI) {
        this.typeOfKey = 1;
        if (log.isDebugEnabled()) {
            log.debug("Konstruktortype: RetrievelMethod");
        }
        RetrievalMethod retrievalMethod = new RetrievalMethod();
        retrievalMethod.setURI(uRI);
        this.retrievalMethod = retrievalMethod;
    }

    public KeyInfo() {
        if (log.isDebugEnabled()) {
            log.debug("KeyInfo Konstruktortype noch nicht definiert.");
        }
    }

    public KeyInfo(X509Certificate cert) {
        this.typeOfKey = 2;
        if (log.isDebugEnabled()) {
            log.debug("Konstruktortype: X509Certificate Data");
        }
        this.x509Data = new X509Data(cert);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setRetrievalMethod(RetrievalMethod retrievalMethod) {
        if (this.typeOfKey > -1) {
            throw new IllegalStateException();
        }
        this.typeOfKey = 1;
        this.retrievalMethod = retrievalMethod;
    }

    public RetrievalMethod getRetrievalMethod() {
        return this.retrievalMethod;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void addEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey.add(encryptedKey);
    }

    public EncryptedKey[] getEncryptedKeys() {
        return this.encryptedKey.toArray(new EncryptedKey[0]);
    }

    public void setAgreementMethod(String agreementMethod) {
        this.agreementMethod = agreementMethod;
    }

    public String getAgreementMethod() {
        return this.agreementMethod;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void writeXML(OutputStream out, String ds, String xenc) throws IOException, OSCIException {
        out.write(("<" + ds + ":KeyInfo").getBytes(Constants.CHARSET_ENCODING));
        if (this.id != null) {
            out.write((" Id=\"" + this.id + "\">").getBytes(Constants.CHARSET_ENCODING));
        } else {
            out.write(62);
        }
        if (!this.encryptedKey.isEmpty()) {
            for (int i = 0; i < this.encryptedKey.size(); ++i) {
                this.encryptedKey.get(i).writeXML(out, ds, xenc);
            }
        }
        if (this.retrievalMethod != null) {
            out.write(("<" + ds + ":RetrievalMethod Type=\"" + this.getRetrievalMethod().getType() + "\" URI=\"" + this.getRetrievalMethod().getURI() + "\"></" + ds + ":RetrievalMethod>").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.x509Data != null) {
            this.x509Data.writeXML(out, ds);
        } else if (this.mgmtData != null) {
            out.write(("<" + ds + ":MgmtData>" + this.mgmtData + "</" + ds + ":MgmtData>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + ds + ":KeyInfo>").getBytes(Constants.CHARSET_ENCODING));
    }

    public int getTypeOfKey() {
        return this.typeOfKey;
    }

    public X509Data getX509Data() {
        return this.x509Data;
    }

    public String getMgmtData() {
        return this.mgmtData;
    }

    public void setMgmtData(String mgmtData) {
        this.mgmtData = mgmtData;
    }
}

