/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.signature;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.EncryptedDataBuilder;
import de.osci.osci12.encryption.EncryptedKeyBuilder;
import de.osci.osci12.signature.KeyInfo;
import de.osci.osci12.signature.RetrievalMethodBuilder;
import de.osci.osci12.signature.X509DataBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class KeyInfoBuilder
extends DefaultHandler {
    DefaultHandler parentHandler = null;
    XMLReader xmlReader = null;
    private static Logger log = LoggerFactory.getLogger(KeyInfoBuilder.class);
    protected static final String DS_XMLNS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XENC_XMLNS = "http://www.w3.org/2001/04/xmlenc#";
    private StringBuffer currentElement = null;
    private X509DataBuilder x509Builder = null;
    private String keyId = "";
    KeyInfo keyInfo = null;

    public KeyInfoBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes attributes) {
        this.xmlReader = xmlReader;
        this.parentHandler = parentHandler;
        this.keyInfo = new KeyInfo();
        if (attributes != null && attributes.getValue("Id") != null) {
            this.keyId = attributes.getValue("Id");
            this.keyInfo.setId(this.keyId);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXParseException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element: " + localName);
        }
        if (localName.equals("KeyName") && uri.equals(DS_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else {
            if (localName.equals("KeyValue") && uri.equals(DS_XMLNS)) {
                throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
            }
            if (localName.equals("RetrievalMethod") && uri.equals(DS_XMLNS)) {
                RetrievalMethodBuilder retrievalMethodBuilder = new RetrievalMethodBuilder(this.xmlReader, this, attributes);
                this.xmlReader.setContentHandler(retrievalMethodBuilder);
            } else if (localName.equals("X509Data") && uri.equals(DS_XMLNS)) {
                this.x509Builder = new X509DataBuilder(this.xmlReader, this, attributes);
                this.xmlReader.setContentHandler(this.x509Builder);
            } else {
                if (localName.equals("PGPData") && uri.equals(DS_XMLNS)) {
                    throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
                }
                if (localName.equals("SPKIData") && uri.equals(DS_XMLNS)) {
                    throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
                }
                if (localName.equals("MgmtData") && uri.equals(DS_XMLNS)) {
                    this.currentElement = new StringBuffer();
                } else if (localName.equals("EncryptedKey") && uri.equals(XENC_XMLNS)) {
                    this.xmlReader.setContentHandler(new EncryptedKeyBuilder(this.xmlReader, this, attributes));
                } else {
                    if (localName.equals("AgreementMethod") && uri.equals(XENC_XMLNS)) {
                        throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
                    }
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName, null);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Start-Element :" + localName);
        }
        if (localName.equals("KeyInfo") && uri.equals(DS_XMLNS)) {
            if (this.parentHandler instanceof EncryptedDataBuilder) {
                ((EncryptedDataBuilder)this.parentHandler).getEncryptedData().setKeyInfo(this.keyInfo);
            } else if (this.parentHandler instanceof EncryptedKeyBuilder) {
                ((EncryptedKeyBuilder)this.parentHandler).getEncKey().setKeyInfo(this.keyInfo);
            }
            this.xmlReader.setContentHandler(this.parentHandler);
        } else if (localName.equals("KeyName") && uri.equals(DS_XMLNS)) {
            this.keyInfo.setKeyName(this.currentElement.toString());
        } else if (!(localName.equals("RetrievalMethod") && uri.equals(DS_XMLNS) || localName.equals("X509Data") && uri.equals(DS_XMLNS))) {
            if (localName.equals("MgmtData") && uri.equals(DS_XMLNS)) {
                this.keyInfo.setMgmtData(this.currentElement.toString());
            } else if (!localName.equals("EncryptedData") || !uri.equals(XENC_XMLNS)) {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
        }
        this.currentElement = null;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Character: " + new String(ch, start, length));
        }
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }
}

